Package["core-runtime"].queue("accounts-base",function () {/* Imports */
var Meteor = Package.meteor.Meteor;
var global = Package.meteor.global;
var meteorEnv = Package.meteor.meteorEnv;
var EmitterPromise = Package.meteor.EmitterPromise;
var ECMAScript = Package.ecmascript.ECMAScript;
var DDPRateLimiter = Package['ddp-rate-limiter'].DDPRateLimiter;
var check = Package.check.check;
var Match = Package.check.Match;
var Random = Package.random.Random;
var EJSON = Package.ejson.EJSON;
var Hook = Package['callback-hook'].Hook;
var URL = Package.url.URL;
var URLSearchParams = Package.url.URLSearchParams;
var DDP = Package['ddp-client'].DDP;
var DDPServer = Package['ddp-server'].DDPServer;
var MongoInternals = Package.mongo.MongoInternals;
var Mongo = Package.mongo.Mongo;
var meteorInstall = Package.modules.meteorInstall;
var Promise = Package.promise.Promise;

/* Package-scope variables */
var Accounts;

var require = meteorInstall({"node_modules":{"meteor":{"accounts-base":{"server_main.js":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// packages/accounts-base/server_main.js                                                                               //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module1, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module1.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    var _Meteor$settings$pack, _Meteor$settings$pack2;
    module1.export({
      AccountsServer: () => AccountsServer
    });
    let AccountsServer;
    module1.link("./accounts_server.js", {
      AccountsServer(v) {
        AccountsServer = v;
      }
    }, 0);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    /**
     * @namespace Accounts
     * @summary The namespace for all server-side accounts-related methods.
     */
    Accounts = new AccountsServer(Meteor.server, _objectSpread(_objectSpread({}, (_Meteor$settings$pack = Meteor.settings.packages) === null || _Meteor$settings$pack === void 0 ? void 0 : _Meteor$settings$pack.accounts), (_Meteor$settings$pack2 = Meteor.settings.packages) === null || _Meteor$settings$pack2 === void 0 ? void 0 : _Meteor$settings$pack2['accounts-base']));
    // TODO[FIBERS]: I need TLA
    Accounts.init().then();

    // Users table. Don't use the normal autopublish, since we want to hide
    // some fields. Code to autopublish this is in accounts_server.js.
    // XXX Allow users to configure this collection name.

    /**
     * @summary A [Mongo.Collection](#collections) containing user documents.
     * @locus Anywhere
     * @type {Mongo.Collection}
     * @importFromPackage meteor
     */
    Meteor.users = Accounts.users;
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"accounts_common.js":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// packages/accounts-base/accounts_common.js                                                                           //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    module.export({
      AccountsCommon: () => AccountsCommon,
      EXPIRE_TOKENS_INTERVAL_MS: () => EXPIRE_TOKENS_INTERVAL_MS
    });
    let Meteor;
    module.link("meteor/meteor", {
      Meteor(v) {
        Meteor = v;
      }
    }, 0);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    // config option keys
    const VALID_CONFIG_KEYS = ['sendVerificationEmail', 'forbidClientAccountCreation', 'restrictCreationByEmailDomain', 'loginExpiration', 'loginExpirationInDays', 'oauthSecretKey', 'passwordResetTokenExpirationInDays', 'passwordResetTokenExpiration', 'passwordEnrollTokenExpirationInDays', 'passwordEnrollTokenExpiration', 'ambiguousErrorMessages', 'bcryptRounds', 'argon2Enabled', 'argon2Type', 'argon2TimeCost', 'argon2MemoryCost', 'argon2Parallelism', 'defaultFieldSelector', 'collection', 'loginTokenExpirationHours', 'tokenSequenceLength', 'clientStorage', 'ddpUrl', 'connection'];

    /**
     * @summary Super-constructor for AccountsClient and AccountsServer.
     * @locus Anywhere
     * @class AccountsCommon
     * @instancename accountsClientOrServer
     * @param options {Object} an object with fields:
     * - connection {Object} Optional DDP connection to reuse.
     * - ddpUrl {String} Optional URL for creating a new DDP connection.
     * - collection {String|Mongo.Collection} The name of the Mongo.Collection
     *     or the Mongo.Collection object to hold the users.
     */
    class AccountsCommon {
      constructor(options) {
        // Validate config options keys
        for (const key of Object.keys(options)) {
          if (!VALID_CONFIG_KEYS.includes(key)) {
            console.error("Accounts.config: Invalid key: ".concat(key));
          }
        }

        // Currently this is read directly by packages like accounts-password
        // and accounts-ui-unstyled.
        this._options = options || {};

        // Note that setting this.connection = null causes this.users to be a
        // LocalCollection, which is not what we want.
        this.connection = undefined;
        this._initConnection(options || {});

        // There is an allow call in accounts_server.js that restricts writes to
        // this collection.
        this.users = this._initializeCollection(options || {});

        // Callback exceptions are printed with Meteor._debug and ignored.
        this._onLoginHook = new Hook({
          bindEnvironment: false,
          debugPrintExceptions: 'onLogin callback'
        });
        this._onLoginFailureHook = new Hook({
          bindEnvironment: false,
          debugPrintExceptions: 'onLoginFailure callback'
        });
        this._onLogoutHook = new Hook({
          bindEnvironment: false,
          debugPrintExceptions: 'onLogout callback'
        });

        // Expose for testing.
        this.DEFAULT_LOGIN_EXPIRATION_DAYS = DEFAULT_LOGIN_EXPIRATION_DAYS;
        this.LOGIN_UNEXPIRING_TOKEN_DAYS = LOGIN_UNEXPIRING_TOKEN_DAYS;

        // Thrown when the user cancels the login process (eg, closes an oauth
        // popup, declines retina scan, etc)
        const lceName = 'Accounts.LoginCancelledError';
        this.LoginCancelledError = Meteor.makeErrorType(lceName, function (description) {
          this.message = description;
        });
        this.LoginCancelledError.prototype.name = lceName;

        // This is used to transmit specific subclass errors over the wire. We
        // should come up with a more generic way to do this (eg, with some sort of
        // symbolic error code rather than a number).
        this.LoginCancelledError.numericError = 0x8acdc2f;
      }
      _initializeCollection(options) {
        if (options.collection && typeof options.collection !== 'string' && !(options.collection instanceof Mongo.Collection)) {
          throw new Meteor.Error('Collection parameter can be only of type string or "Mongo.Collection"');
        }
        let collectionName = 'users';
        if (typeof options.collection === 'string') {
          collectionName = options.collection;
        }
        let collection;
        if (options.collection instanceof Mongo.Collection) {
          collection = options.collection;
        } else {
          collection = new Mongo.Collection(collectionName, {
            _preventAutopublish: true,
            connection: this.connection
          });
        }
        return collection;
      }

      /**
       * @summary Get the current user id, or `null` if no user is logged in. A reactive data source.
       * @locus Anywhere
       */
      userId() {
        throw new Error('userId method not implemented');
      }

      // merge the defaultFieldSelector with an existing options object
      _addDefaultFieldSelector() {
        let options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        // this will be the most common case for most people, so make it quick
        if (!this._options.defaultFieldSelector) return options;

        // if no field selector then just use defaultFieldSelector
        if (!options.fields) return _objectSpread(_objectSpread({}, options), {}, {
          fields: this._options.defaultFieldSelector
        });

        // if empty field selector then the full user object is explicitly requested, so obey
        const keys = Object.keys(options.fields);
        if (!keys.length) return options;

        // if the requested fields are +ve then ignore defaultFieldSelector
        // assume they are all either +ve or -ve because Mongo doesn't like mixed
        if (!!options.fields[keys[0]]) return options;

        // The requested fields are -ve.
        // If the defaultFieldSelector is +ve then use requested fields, otherwise merge them
        const keys2 = Object.keys(this._options.defaultFieldSelector);
        return this._options.defaultFieldSelector[keys2[0]] ? options : _objectSpread(_objectSpread({}, options), {}, {
          fields: _objectSpread(_objectSpread({}, options.fields), this._options.defaultFieldSelector)
        });
      }

      /**
       * @summary Get the current user record, or `null` if no user is logged in. A reactive data source. In the server this fuction returns a promise.
       * @locus Anywhere
       * @param {Object} [options]
       * @param {MongoFieldSpecifier} options.fields Dictionary of fields to return or exclude.
       */
      user(options) {
        if (Meteor.isServer) {
          console.warn(["`Meteor.user()` is deprecated on the server side.", "    To fetch the current user record on the server,", "    use `Meteor.userAsync()` instead."].join("\n"));
        }
        const self = this;
        const userId = self.userId();
        const findOne = function () {
          return Meteor.isClient ? self.users.findOne(...arguments) : self.users.findOneAsync(...arguments);
        };
        return userId ? findOne(userId, this._addDefaultFieldSelector(options)) : null;
      }

      /**
       * @summary Get the current user record, or `null` if no user is logged in.
       * @locus Anywhere
       * @param {Object} [options]
       * @param {MongoFieldSpecifier} options.fields Dictionary of fields to return or exclude.
       */
      async userAsync(options) {
        const userId = this.userId();
        return userId ? this.users.findOneAsync(userId, this._addDefaultFieldSelector(options)) : null;
      }

      /**
       * @summary Set global accounts options. You can also set these in `Meteor.settings.packages.accounts` without the need to call this function.
       * @locus Anywhere
       * @param {Object} options
       * @param {Boolean} options.sendVerificationEmail New users with an email address will receive an address verification email.
       * @param {Boolean} options.forbidClientAccountCreation Calls to [`createUser`](#accounts_createuser) from the client will be rejected. In addition, if you are using [accounts-ui](#accountsui), the "Create account" link will not be available.
       * @param {String | Function} options.restrictCreationByEmailDomain If set to a string, only allows new users if the domain part of their email address matches the string. If set to a function, only allows new users if the function returns true.  The function is passed the full email address of the proposed new user.  Works with password-based sign-in and external services that expose email addresses (Google, Facebook, GitHub). All existing users still can log in after enabling this option. Example: `Accounts.config({ restrictCreationByEmailDomain: 'school.edu' })`.
       * @param {Number} options.loginExpiration The number of milliseconds from when a user logs in until their token expires and they are logged out, for a more granular control. If `loginExpirationInDays` is set, it takes precedent.
       * @param {Number} options.loginExpirationInDays The number of days from when a user logs in until their token expires and they are logged out. Defaults to 90. Set to `null` to disable login expiration.
       * @param {String} options.oauthSecretKey When using the `oauth-encryption` package, the 16 byte key using to encrypt sensitive account credentials in the database, encoded in base64.  This option may only be specified on the server.  See packages/oauth-encryption/README.md for details.
       * @param {Number} options.passwordResetTokenExpirationInDays The number of days from when a link to reset password is sent until token expires and user can't reset password with the link anymore. Defaults to 3.
       * @param {Number} options.passwordResetTokenExpiration The number of milliseconds from when a link to reset password is sent until token expires and user can't reset password with the link anymore. If `passwordResetTokenExpirationInDays` is set, it takes precedent.
       * @param {Number} options.passwordEnrollTokenExpirationInDays The number of days from when a link to set initial password is sent until token expires and user can't set password with the link anymore. Defaults to 30.
       * @param {Number} options.passwordEnrollTokenExpiration The number of milliseconds from when a link to set initial password is sent until token expires and user can't set password with the link anymore. If `passwordEnrollTokenExpirationInDays` is set, it takes precedent.
       * @param {Boolean} options.ambiguousErrorMessages Return ambiguous error messages from login failures to prevent user enumeration. Defaults to `true`.
       * @param {Number} options.bcryptRounds Allows override of number of bcrypt rounds (aka work factor) used to store passwords. The default is 10.
       * @param {Boolean} options.argon2Enabled Enable argon2 algorithm usage in replacement for bcrypt. The default is `false`.
       * @param {'argon2id' | 'argon2i' | 'argon2d'} options.argon2Type Allows override of the argon2 algorithm type. The default is `argon2id`.
       * @param {Number} options.argon2TimeCost Allows override of number of argon2 iterations (aka time cost) used to store passwords. The default is 2.
       * @param {Number} options.argon2MemoryCost Allows override of the amount of memory (in KiB) used by the argon2 algorithm. The default is 19456 (19MB).
       * @param {Number} options.argon2Parallelism Allows override of the number of threads used by the argon2 algorithm. The default is 1.
       * @param {MongoFieldSpecifier} options.defaultFieldSelector To exclude by default large custom fields from `Meteor.user()` and `Meteor.findUserBy...()` functions when called without a field selector, and all `onLogin`, `onLoginFailure` and `onLogout` callbacks.  Example: `Accounts.config({ defaultFieldSelector: { myBigArray: 0 }})`. Beware when using this. If, for instance, you do not include `email` when excluding the fields, you can have problems with functions like `forgotPassword` that will break because they won't have the required data available. It's recommend that you always keep the fields `_id`, `username`, and `email`.
       * @param {String|Mongo.Collection} options.collection A collection name or a Mongo.Collection object to hold the users.
       * @param {Number} options.loginTokenExpirationHours When using the package `accounts-2fa`, use this to set the amount of time a token sent is valid. As it's just a number, you can use, for example, 0.5 to make the token valid for just half hour. The default is 1 hour.
       * @param {Number} options.tokenSequenceLength When using the package `accounts-2fa`, use this to the size of the token sequence generated. The default is 6.
       * @param {'session' | 'local'} options.clientStorage By default login credentials are stored in local storage, setting this to true will switch to using session storage.
       */
      config(options) {
        // We don't want users to accidentally only call Accounts.config on the
        // client, where some of the options will have partial effects (eg removing
        // the "create account" button from accounts-ui if forbidClientAccountCreation
        // is set, or redirecting Google login to a specific-domain page) without
        // having their full effects.
        if (Meteor.isServer) {
          __meteor_runtime_config__.accountsConfigCalled = true;
        } else if (!__meteor_runtime_config__.accountsConfigCalled) {
          // XXX would be nice to "crash" the client and replace the UI with an error
          // message, but there's no trivial way to do this.
          Meteor._debug('Accounts.config was called on the client but not on the ' + 'server; some configuration options may not take effect.');
        }

        // We need to validate the oauthSecretKey option at the time
        // Accounts.config is called. We also deliberately don't store the
        // oauthSecretKey in Accounts._options.
        if (Object.prototype.hasOwnProperty.call(options, 'oauthSecretKey')) {
          if (Meteor.isClient) {
            throw new Error('The oauthSecretKey option may only be specified on the server');
          }
          if (!Package['oauth-encryption']) {
            throw new Error('The oauth-encryption package must be loaded to set oauthSecretKey');
          }
          Package['oauth-encryption'].OAuthEncryption.loadKey(options.oauthSecretKey);
          options = _objectSpread({}, options);
          delete options.oauthSecretKey;
        }

        // Validate config options keys
        for (const key of Object.keys(options)) {
          if (!VALID_CONFIG_KEYS.includes(key)) {
            console.error("Accounts.config: Invalid key: ".concat(key));
          }
        }

        // set values in Accounts._options
        for (const key of VALID_CONFIG_KEYS) {
          if (key in options) {
            if (key in this._options) {
              if (key !== 'collection' && Meteor.isTest && key !== 'clientStorage') {
                throw new Meteor.Error("Can't set `".concat(key, "` more than once"));
              }
            }
            this._options[key] = options[key];
          }
        }
        if (options.collection && options.collection !== this.users._name && options.collection !== this.users) {
          this.users = this._initializeCollection(options);
        }
      }

      /**
       * @summary Register a callback to be called after a login attempt succeeds.
       * @locus Anywhere
       * @param {Function} func The callback to be called when login is successful.
       *                        The callback receives a single object that
       *                        holds login details. This object contains the login
       *                        result type (password, resume, etc.) on both the
       *                        client and server. `onLogin` callbacks registered
       *                        on the server also receive extra data, such
       *                        as user details, connection information, etc.
       */
      onLogin(func) {
        let ret = this._onLoginHook.register(func);
        // call the just registered callback if already logged in
        this._startupCallback(ret.callback);
        return ret;
      }

      /**
       * @summary Register a callback to be called after a login attempt fails.
       * @locus Anywhere
       * @param {Function} func The callback to be called after the login has failed.
       */
      onLoginFailure(func) {
        return this._onLoginFailureHook.register(func);
      }

      /**
       * @summary Register a callback to be called after a logout attempt succeeds.
       * @locus Anywhere
       * @param {Function} func The callback to be called when logout is successful.
       */
      onLogout(func) {
        return this._onLogoutHook.register(func);
      }
      _initConnection(options) {
        if (!Meteor.isClient) {
          return;
        }

        // The connection used by the Accounts system. This is the connection
        // that will get logged in by Meteor.login(), and this is the
        // connection whose login state will be reflected by Meteor.userId().
        //
        // It would be much preferable for this to be in accounts_client.js,
        // but it has to be here because it's needed to create the
        // Meteor.users collection.
        if (options.connection) {
          this.connection = options.connection;
        } else if (options.ddpUrl) {
          this.connection = DDP.connect(options.ddpUrl);
        } else if (typeof __meteor_runtime_config__ !== 'undefined' && __meteor_runtime_config__.ACCOUNTS_CONNECTION_URL) {
          // Temporary, internal hook to allow the server to point the client
          // to a different authentication server. This is for a very
          // particular use case that comes up when implementing a oauth
          // server. Unsupported and may go away at any point in time.
          //
          // We will eventually provide a general way to use account-base
          // against any DDP connection, not just one special one.
          this.connection = DDP.connect(__meteor_runtime_config__.ACCOUNTS_CONNECTION_URL);
        } else {
          this.connection = Meteor.connection;
        }
      }
      _getTokenLifetimeMs() {
        // When loginExpirationInDays is set to null, we'll use a really high
        // number of days (LOGIN_UNEXPIRABLE_TOKEN_DAYS) to simulate an
        // unexpiring token.
        const loginExpirationInDays = this._options.loginExpirationInDays === null ? LOGIN_UNEXPIRING_TOKEN_DAYS : this._options.loginExpirationInDays;
        return this._options.loginExpiration || (loginExpirationInDays || DEFAULT_LOGIN_EXPIRATION_DAYS) * 86400000;
      }
      _getPasswordResetTokenLifetimeMs() {
        return this._options.passwordResetTokenExpiration || (this._options.passwordResetTokenExpirationInDays || DEFAULT_PASSWORD_RESET_TOKEN_EXPIRATION_DAYS) * 86400000;
      }
      _getPasswordEnrollTokenLifetimeMs() {
        return this._options.passwordEnrollTokenExpiration || (this._options.passwordEnrollTokenExpirationInDays || DEFAULT_PASSWORD_ENROLL_TOKEN_EXPIRATION_DAYS) * 86400000;
      }
      _tokenExpiration(when) {
        // We pass when through the Date constructor for backwards compatibility;
        // `when` used to be a number.
        return new Date(new Date(when).getTime() + this._getTokenLifetimeMs());
      }
      _tokenExpiresSoon(when) {
        let minLifetimeMs = 0.1 * this._getTokenLifetimeMs();
        const minLifetimeCapMs = MIN_TOKEN_LIFETIME_CAP_SECS * 1000;
        if (minLifetimeMs > minLifetimeCapMs) {
          minLifetimeMs = minLifetimeCapMs;
        }
        return new Date() > new Date(when) - minLifetimeMs;
      }

      // No-op on the server, overridden on the client.
      _startupCallback(callback) {}
    }
    // Note that Accounts is defined separately in accounts_client.js and
    // accounts_server.js.

    /**
     * @summary Get the current user id, or `null` if no user is logged in. A reactive data source.
     * @locus Anywhere
     * @importFromPackage meteor
     */
    Meteor.userId = () => Accounts.userId();

    /**
     * @summary Get the current user record, or `null` if no user is logged in. A reactive data source.
     * @locus Anywhere
     * @importFromPackage meteor
     * @param {Object} [options]
     * @param {MongoFieldSpecifier} options.fields Dictionary of fields to return or exclude.
     */
    Meteor.user = options => Accounts.user(options);

    /**
     * @summary Get the current user record, or `null` if no user is logged in. A reactive data source.
     * @locus Anywhere
     * @importFromPackage meteor
     * @param {Object} [options]
     * @param {MongoFieldSpecifier} options.fields Dictionary of fields to return or exclude.
     */
    Meteor.userAsync = options => Accounts.userAsync(options);

    // how long (in days) until a login token expires
    const DEFAULT_LOGIN_EXPIRATION_DAYS = 90;
    // how long (in days) until reset password token expires
    const DEFAULT_PASSWORD_RESET_TOKEN_EXPIRATION_DAYS = 3;
    // how long (in days) until enrol password token expires
    const DEFAULT_PASSWORD_ENROLL_TOKEN_EXPIRATION_DAYS = 30;
    // Clients don't try to auto-login with a token that is going to expire within
    // .1 * DEFAULT_LOGIN_EXPIRATION_DAYS, capped at MIN_TOKEN_LIFETIME_CAP_SECS.
    // Tries to avoid abrupt disconnects from expiring tokens.
    const MIN_TOKEN_LIFETIME_CAP_SECS = 3600; // one hour
    // how often (in milliseconds) we check for expired tokens
    const EXPIRE_TOKENS_INTERVAL_MS = 600 * 1000;
    // 10 minutes
    // A large number of expiration days (approximately 100 years worth) that is
    // used when creating unexpiring tokens.
    const LOGIN_UNEXPIRING_TOKEN_DAYS = 365 * 100;
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"accounts_server.js":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// packages/accounts-base/accounts_server.js                                                                           //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectWithoutProperties;
    module.link("@babel/runtime/helpers/objectWithoutProperties", {
      default(v) {
        _objectWithoutProperties = v;
      }
    }, 0);
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 1);
    let _asyncIterator;
    module.link("@babel/runtime/helpers/asyncIterator", {
      default(v) {
        _asyncIterator = v;
      }
    }, 2);
    var _Package$oauthEncryp;
    const _excluded = ["token"];
    module.export({
      AccountsServer: () => AccountsServer
    });
    let crypto;
    module.link("crypto", {
      default(v) {
        crypto = v;
      }
    }, 0);
    let Meteor;
    module.link("meteor/meteor", {
      Meteor(v) {
        Meteor = v;
      }
    }, 1);
    let AccountsCommon, EXPIRE_TOKENS_INTERVAL_MS;
    module.link("./accounts_common.js", {
      AccountsCommon(v) {
        AccountsCommon = v;
      },
      EXPIRE_TOKENS_INTERVAL_MS(v) {
        EXPIRE_TOKENS_INTERVAL_MS = v;
      }
    }, 2);
    let URL;
    module.link("meteor/url", {
      URL(v) {
        URL = v;
      }
    }, 3);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const hasOwn = Object.prototype.hasOwnProperty;

    // XXX maybe this belongs in the check package
    const NonEmptyString = Match.Where(x => {
      check(x, String);
      return x.length > 0;
    });

    /**
     * @summary Constructor for the `Accounts` namespace on the server.
     * @locus Server
     * @class AccountsServer
     * @extends AccountsCommon
     * @instancename accountsServer
     * @param {Object} server A server object such as `Meteor.server`.
     */
    class AccountsServer extends AccountsCommon {
      // Note that this constructor is less likely to be instantiated multiple
      // times than the `AccountsClient` constructor, because a single server
      // can provide only one set of methods.
      constructor(server, _options) {
        var _this;
        super(_options || {});
        _this = this;
        ///
        /// CREATE USER HOOKS
        ///
        /**
         * @summary Customize login token creation.
         * @locus Server
         * @param {Function} func Called whenever a new token is created.
         * Return the sequence and the user object. Return true to keep sending the default email, or false to override the behavior.
         */
        this.onCreateLoginToken = function (func) {
          if (this._onCreateLoginTokenHook) {
            throw new Error('Can only call onCreateLoginToken once');
          }
          this._onCreateLoginTokenHook = func;
        };
        // Generates a MongoDB selector that can be used to perform a fast case
        // insensitive lookup for the given fieldName and string. Since MongoDB does
        // not support case insensitive indexes, and case insensitive regex queries
        // are slow, we construct a set of prefix selectors for all permutations of
        // the first 4 characters ourselves. We first attempt to matching against
        // these, and because 'prefix expression' regex queries do use indexes (see
        // http://docs.mongodb.org/v2.6/reference/operator/query/regex/#index-use),
        // this has been found to greatly improve performance (from 1200ms to 5ms in a
        // test with 1.000.000 users).
        this._selectorForFastCaseInsensitiveLookup = (fieldName, string) => {
          // Performance seems to improve up to 4 prefix characters
          const prefix = string.substring(0, Math.min(string.length, 4));
          const orClause = generateCasePermutationsForString(prefix).map(prefixPermutation => {
            const selector = {};
            selector[fieldName] = new RegExp("^".concat(Meteor._escapeRegExp(prefixPermutation)));
            return selector;
          });
          const caseInsensitiveClause = {};
          caseInsensitiveClause[fieldName] = new RegExp("^".concat(Meteor._escapeRegExp(string), "$"), 'i');
          return {
            $and: [{
              $or: orClause
            }, caseInsensitiveClause]
          };
        };
        this._findUserByQuery = async (query, options) => {
          let user = null;
          if (query.id) {
            // default field selector is added within getUserById()
            user = await Meteor.users.findOneAsync(query.id, this._addDefaultFieldSelector(options));
          } else {
            options = this._addDefaultFieldSelector(options);
            let fieldName;
            let fieldValue;
            if (query.username) {
              fieldName = 'username';
              fieldValue = query.username;
            } else if (query.email) {
              fieldName = 'emails.address';
              fieldValue = query.email;
            } else {
              throw new Error("shouldn't happen (validation missed something)");
            }
            let selector = {};
            selector[fieldName] = fieldValue;
            user = await Meteor.users.findOneAsync(selector, options);
            // If user is not found, try a case insensitive lookup
            if (!user) {
              selector = this._selectorForFastCaseInsensitiveLookup(fieldName, fieldValue);
              const candidateUsers = await Meteor.users.find(selector, _objectSpread(_objectSpread({}, options), {}, {
                limit: 2
              })).fetchAsync();
              // No match if multiple candidates are found
              if (candidateUsers.length === 1) {
                user = candidateUsers[0];
              }
            }
          }
          return user;
        };
        /**
         * @summary Find a user by one of their email addresses.
         * @locus Server
         * @param {String} email The email address to look for
         * @param {Object} [options]
         * @param {Object} options.fields Limit the fields to return from the user document
         * @returns {Promise<Object>} A user if found, else null
         * @memberof Accounts
         * @importFromPackage accounts-base
         */
        this.findUserByEmail = async (email, options) => await this._findUserByQuery({
          email
        }, options);
        /**
         * @summary Find a user by their username.
         * @locus Server
         * @param {String} username The username to look for
         * @param {Object} [options]
         * @param {Object} options.fields Limit the fields to return from the user document
         * @returns {Promise<Object>} A user if found, else null
         * @memberof Accounts
         * @importFromPackage accounts-base
         */
        this.findUserByUsername = async (username, options) => await this._findUserByQuery({
          username
        }, options);
        this._handleError = function (msg) {
          var _this$_options$ambigu;
          let throwError = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
          let errorCode = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 403;
          const isErrorAmbiguous = (_this$_options$ambigu = _this._options.ambiguousErrorMessages) !== null && _this$_options$ambigu !== void 0 ? _this$_options$ambigu : true;
          const error = new Meteor.Error(errorCode, isErrorAmbiguous ? 'Something went wrong. Please check your credentials.' : msg);
          if (throwError) {
            throw error;
          }
          return error;
        };
        this._userQueryValidator = Match.Where(user => {
          check(user, {
            id: Match.Optional(NonEmptyString),
            username: Match.Optional(NonEmptyString),
            email: Match.Optional(NonEmptyString)
          });
          if (Object.keys(user).length !== 1) throw new Match.Error("User property must have exactly one field");
          return true;
        });
        this._server = server || Meteor.server;
        // Set up the server's methods, as if by calling Meteor.methods.
        this._initServerMethods();
        this._initAccountDataHooks();

        // If autopublish is on, publish these user fields. Login service
        // packages (eg accounts-google) add to these by calling
        // addAutopublishFields.  Notably, this isn't implemented with multiple
        // publishes since DDP only merges only across top-level fields, not
        // subfields (such as 'services.facebook.accessToken')
        this._autopublishFields = {
          loggedInUser: ['profile', 'username', 'emails'],
          otherUsers: ['profile', 'username']
        };

        // use object to keep the reference when used in functions
        // where _defaultPublishFields is destructured into lexical scope
        // for publish callbacks that need `this`
        this._defaultPublishFields = {
          projection: {
            profile: 1,
            username: 1,
            emails: 1
          }
        };
        this._initServerPublications();

        // connectionId -> {connection, loginToken}
        this._accountData = {};

        // connection id -> observe handle for the login token that this connection is
        // currently associated with, or a number. The number indicates that we are in
        // the process of setting up the observe (using a number instead of a single
        // sentinel allows multiple attempts to set up the observe to identify which
        // one was theirs).
        this._userObservesForConnections = {};
        this._nextUserObserveNumber = 1; // for the number described above.

        // list of all registered handlers.
        this._loginHandlers = [];
        setupDefaultLoginHandlers(this);
        setExpireTokensInterval(this);
        this._validateLoginHook = new Hook({
          bindEnvironment: false
        });
        this._validateNewUserHooks = [defaultValidateNewUserHook.bind(this)];
        this._deleteSavedTokensForAllUsersOnStartup();
        this._skipCaseInsensitiveChecksForTest = {};

        // Helper function to resolve promises if needed
        this._resolvePromise = async value => {
          return Meteor._isPromise(value) ? await value : value;
        };
        this.urls = {
          resetPassword: (token, extraParams) => this.buildEmailUrl("#/reset-password/".concat(token), extraParams),
          verifyEmail: (token, extraParams) => this.buildEmailUrl("#/verify-email/".concat(token), extraParams),
          loginToken: (selector, token, extraParams) => this.buildEmailUrl("/?loginToken=".concat(token, "&selector=").concat(selector), extraParams),
          enrollAccount: (token, extraParams) => this.buildEmailUrl("#/enroll-account/".concat(token), extraParams)
        };
        this.addDefaultRateLimit();
        this.buildEmailUrl = function (path) {
          let extraParams = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
          const url = new URL(Meteor.absoluteUrl(path));
          const params = Object.entries(extraParams);
          if (params.length > 0) {
            // Add additional parameters to the url
            for (const [key, value] of params) {
              url.searchParams.append(key, value);
            }
          }
          return url.toString();
        };
      }

      ///
      /// CURRENT USER
      ///

      // @override of "abstract" non-implementation in accounts_common.js
      userId() {
        // This function only works if called inside a method or a pubication.
        // Using any of the information from Meteor.user() in a method or
        // publish function will always use the value from when the function first
        // runs. This is likely not what the user expects. The way to make this work
        // in a method or publish function is to do Meteor.find(this.userId).observe
        // and recompute when the user record changes.
        const currentInvocation = DDP._CurrentMethodInvocation.get() || DDP._CurrentPublicationInvocation.get();
        if (!currentInvocation) throw new Error("Meteor.userId can only be invoked in method calls or publications.");
        return currentInvocation.userId;
      }
      async init() {
        await setupUsersCollection(this.users);
      }

      ///
      /// LOGIN HOOKS
      ///

      /**
       * @summary Validate login attempts.
       * @locus Server
       * @param {Function} func Called whenever a login is attempted (either successful or unsuccessful).  A login can be aborted by returning a falsy value or throwing an exception.
       */
      validateLoginAttempt(func) {
        // Exceptions inside the hook callback are passed up to us.
        return this._validateLoginHook.register(func);
      }

      /**
       * @summary Set restrictions on new user creation.
       * @locus Server
       * @param {Function} func Called whenever a new user is created. Takes the new user object, and returns true to allow the creation or false to abort.
       */
      validateNewUser(func) {
        this._validateNewUserHooks.push(func);
      }

      /**
       * @summary Validate login from external service
       * @locus Server
       * @param {Function} func Called whenever login/user creation from external service is attempted. Login or user creation based on this login can be aborted by passing a falsy value or throwing an exception.
       */
      beforeExternalLogin(func) {
        if (this._beforeExternalLoginHook) {
          throw new Error("Can only call beforeExternalLogin once");
        }
        this._beforeExternalLoginHook = func;
      }
      /**
       * @summary Customize new user creation.
       * @locus Server
       * @param {Function} func Called whenever a new user is created. Return the new user object, or throw an `Error` to abort the creation.
       */
      onCreateUser(func) {
        if (this._onCreateUserHook) {
          throw new Error("Can only call onCreateUser once");
        }
        this._onCreateUserHook = Meteor.wrapFn(func);
      }

      /**
       * @summary Customize oauth user profile updates
       * @locus Server
       * @param {Function} func Called whenever a user is logged in via oauth. Return the profile object to be merged, or throw an `Error` to abort the creation.
       */
      onExternalLogin(func) {
        if (this._onExternalLoginHook) {
          throw new Error("Can only call onExternalLogin once");
        }
        this._onExternalLoginHook = func;
      }

      /**
       * @summary Customize user selection on external logins
       * @locus Server
       * @param {Function} func Called whenever a user is logged in via oauth and a
       * user is not found with the service id. Return the user or undefined.
       */
      setAdditionalFindUserOnExternalLogin(func) {
        if (this._additionalFindUserOnExternalLogin) {
          throw new Error("Can only call setAdditionalFindUserOnExternalLogin once");
        }
        this._additionalFindUserOnExternalLogin = func;
      }
      async _validateLogin(connection, attempt) {
        await this._validateLoginHook.forEachAsync(async callback => {
          let ret;
          try {
            ret = await callback(cloneAttemptWithConnection(connection, attempt));
          } catch (e) {
            attempt.allowed = false;
            // XXX this means the last thrown error overrides previous error
            // messages. Maybe this is surprising to users and we should make
            // overriding errors more explicit. (see
            // https://github.com/meteor/meteor/issues/1960)
            attempt.error = e;
            return true;
          }
          if (!ret) {
            attempt.allowed = false;
            // don't override a specific error provided by a previous
            // validator or the initial attempt (eg "incorrect password").
            if (!attempt.error) attempt.error = new Meteor.Error(403, "Login forbidden");
          }
          return true;
        });
      }
      async _successfulLogin(connection, attempt) {
        await this._onLoginHook.forEachAsync(async callback => {
          await callback(cloneAttemptWithConnection(connection, attempt));
          return true;
        });
      }
      async _failedLogin(connection, attempt) {
        await this._onLoginFailureHook.forEachAsync(async callback => {
          await callback(cloneAttemptWithConnection(connection, attempt));
          return true;
        });
      }
      async _successfulLogout(connection, userId) {
        // don't fetch the user object unless there are some callbacks registered
        let user;
        await this._onLogoutHook.forEachAsync(async callback => {
          if (!user && userId) user = await this.users.findOneAsync(userId, {
            fields: this._options.defaultFieldSelector
          });
          callback({
            user,
            connection
          });
          return true;
        });
      }
      ///
      /// LOGIN METHODS
      ///

      // Login methods return to the client an object containing these
      // fields when the user was logged in successfully:
      //
      //   id: userId
      //   token: *
      //   tokenExpires: *
      //
      // tokenExpires is optional and intends to provide a hint to the
      // client as to when the token will expire. If not provided, the
      // client will call Accounts._tokenExpiration, passing it the date
      // that it received the token.
      //
      // The login method will throw an error back to the client if the user
      // failed to log in.
      //
      //
      // Login handlers and service specific login methods such as
      // `createUser` internally return a `result` object containing these
      // fields:
      //
      //   type:
      //     optional string; the service name, overrides the handler
      //     default if present.
      //
      //   error:
      //     exception; if the user is not allowed to login, the reason why.
      //
      //   userId:
      //     string; the user id of the user attempting to login (if
      //     known), required for an allowed login.
      //
      //   options:
      //     optional object merged into the result returned by the login
      //     method; used by HAMK from SRP.
      //
      //   stampedLoginToken:
      //     optional object with `token` and `when` indicating the login
      //     token is already present in the database, returned by the
      //     "resume" login handler.
      //
      // For convenience, login methods can also throw an exception, which
      // is converted into an {error} result.  However, if the id of the
      // user attempting the login is known, a {userId, error} result should
      // be returned instead since the user id is not captured when an
      // exception is thrown.
      //
      // This internal `result` object is automatically converted into the
      // public {id, token, tokenExpires} object returned to the client.

      // Try a login method, converting thrown exceptions into an {error}
      // result.  The `type` argument is a default, inserted into the result
      // object if not explicitly returned.
      //
      // Log in a user on a connection.
      //
      // We use the method invocation to set the user id on the connection,
      // not the connection object directly. setUserId is tied to methods to
      // enforce clear ordering of method application (using wait methods on
      // the client, and a no setUserId after unblock restriction on the
      // server)
      //
      // The `stampedLoginToken` parameter is optional.  When present, it
      // indicates that the login token has already been inserted into the
      // database and doesn't need to be inserted again.  (It's used by the
      // "resume" login handler).
      async _loginUser(methodInvocation, userId, stampedLoginToken) {
        if (!stampedLoginToken) {
          stampedLoginToken = this._generateStampedLoginToken();
          await this._insertLoginToken(userId, stampedLoginToken);
        }

        // This order (and the avoidance of yields) is important to make
        // sure that when publish functions are rerun, they see a
        // consistent view of the world: the userId is set and matches
        // the login token on the connection (not that there is
        // currently a public API for reading the login token on a
        // connection).
        Meteor._noYieldsAllowed(() => this._setLoginToken(userId, methodInvocation.connection, this._hashLoginToken(stampedLoginToken.token)));
        await methodInvocation.setUserId(userId);
        return {
          id: userId,
          token: stampedLoginToken.token,
          tokenExpires: this._tokenExpiration(stampedLoginToken.when)
        };
      }
      // After a login method has completed, call the login hooks.  Note
      // that `attemptLogin` is called for *all* login attempts, even ones
      // which aren't successful (such as an invalid password, etc).
      //
      // If the login is allowed and isn't aborted by a validate login hook
      // callback, log in the user.
      //
      async _attemptLogin(methodInvocation, methodName, methodArgs, result) {
        if (!result) throw new Error("result is required");

        // XXX A programming error in a login handler can lead to this occurring, and
        // then we don't call onLogin or onLoginFailure callbacks. Should
        // tryLoginMethod catch this case and turn it into an error?
        if (!result.userId && !result.error) throw new Error("A login method must specify a userId or an error");
        let user;
        if (result.userId) user = await this.users.findOneAsync(result.userId, {
          fields: this._options.defaultFieldSelector
        });
        const attempt = {
          type: result.type || "unknown",
          allowed: !!(result.userId && !result.error),
          methodName: methodName,
          methodArguments: Array.from(methodArgs)
        };
        if (result.error) {
          attempt.error = result.error;
        }
        if (user) {
          attempt.user = user;
        }

        // _validateLogin may mutate `attempt` by adding an error and changing allowed
        // to false, but that's the only change it can make (and the user's callbacks
        // only get a clone of `attempt`).
        await this._validateLogin(methodInvocation.connection, attempt);
        if (attempt.allowed) {
          const o = await this._loginUser(methodInvocation, result.userId, result.stampedLoginToken);
          const ret = _objectSpread(_objectSpread({}, o), result.options);
          ret.type = attempt.type;
          await this._successfulLogin(methodInvocation.connection, attempt);
          return ret;
        } else {
          await this._failedLogin(methodInvocation.connection, attempt);
          throw attempt.error;
        }
      }
      // All service specific login methods should go through this function.
      // Ensure that thrown exceptions are caught and that login hook
      // callbacks are still called.
      //
      async _loginMethod(methodInvocation, methodName, methodArgs, type, fn) {
        return await this._attemptLogin(methodInvocation, methodName, methodArgs, await tryLoginMethod(type, fn));
      }
      // Report a login attempt failed outside the context of a normal login
      // method. This is for use in the case where there is a multi-step login
      // procedure (eg SRP based password login). If a method early in the
      // chain fails, it should call this function to report a failure. There
      // is no corresponding method for a successful login; methods that can
      // succeed at logging a user in should always be actual login methods
      // (using either Accounts._loginMethod or Accounts.registerLoginHandler).
      async _reportLoginFailure(methodInvocation, methodName, methodArgs, result) {
        const attempt = {
          type: result.type || "unknown",
          allowed: false,
          error: result.error,
          methodName: methodName,
          methodArguments: Array.from(methodArgs)
        };
        if (result.userId) {
          attempt.user = this.users.findOneAsync(result.userId, {
            fields: this._options.defaultFieldSelector
          });
        }
        await this._validateLogin(methodInvocation.connection, attempt);
        await this._failedLogin(methodInvocation.connection, attempt);

        // _validateLogin may mutate attempt to set a new error message. Return
        // the modified version.
        return attempt;
      }
      ///
      /// LOGIN HANDLERS
      ///

      /**
       * @summary Registers a new login handler.
       * @locus Server
       * @param {String} [name] The type of login method like oauth, password, etc.
       * @param {Function} handler A function that receives an options object
       * (as passed as an argument to the `login` method) and returns one of
       * `undefined`, meaning don't handle or a login method result object.
       */
      registerLoginHandler(name, handler) {
        if (!handler) {
          handler = name;
          name = null;
        }
        this._loginHandlers.push({
          name: name,
          handler: Meteor.wrapFn(handler)
        });
      }
      // Checks a user's credentials against all the registered login
      // handlers, and returns a login token if the credentials are valid. It
      // is like the login method, except that it doesn't set the logged-in
      // user on the connection. Throws a Meteor.Error if logging in fails,
      // including the case where none of the login handlers handled the login
      // request. Otherwise, returns {id: userId, token: *, tokenExpires: *}.
      //
      // For example, if you want to login with a plaintext password, `options` could be
      //   { user: { username: <username> }, password: <password> }, or
      //   { user: { email: <email> }, password: <password> }.

      // Try all of the registered login handlers until one of them doesn't
      // return `undefined`, meaning it handled this call to `login`. Return
      // that return value.
      async _runLoginHandlers(methodInvocation, options) {
        for (let handler of this._loginHandlers) {
          const result = await tryLoginMethod(handler.name, async () => await handler.handler.call(methodInvocation, options));
          if (result) {
            return result;
          }
          if (result !== undefined) {
            throw new Meteor.Error(400, 'A login handler should return a result or undefined');
          }
        }
        return {
          type: null,
          error: new Meteor.Error(400, "Unrecognized options for login request")
        };
      }
      // Deletes the given loginToken from the database.
      //
      // For new-style hashed token, this will cause all connections
      // associated with the token to be closed.
      //
      // Any connections associated with old-style unhashed tokens will be
      // in the process of becoming associated with hashed tokens and then
      // they'll get closed.
      async destroyToken(userId, loginToken) {
        await this.users.updateAsync(userId, {
          $pull: {
            "services.resume.loginTokens": {
              $or: [{
                hashedToken: loginToken
              }, {
                token: loginToken
              }]
            }
          }
        });
      }
      _initServerMethods() {
        // The methods created in this function need to be created here so that
        // this variable is available in their scope.
        const accounts = this;

        // This object will be populated with methods and then passed to
        // accounts._server.methods further below.
        const methods = {};

        // @returns {Object|null}
        //   If successful, returns {token: reconnectToken, id: userId}
        //   If unsuccessful (for example, if the user closed the oauth login popup),
        //     throws an error describing the reason
        methods.login = async function (options) {
          // Login handlers should really also check whatever field they look at in
          // options, but we don't enforce it.
          check(options, Object);
          const result = await accounts._runLoginHandlers(this, options);
          //console.log({result});

          return await accounts._attemptLogin(this, "login", arguments, result);
        };
        methods.logout = async function () {
          const token = accounts._getLoginToken(this.connection.id);
          accounts._setLoginToken(this.userId, this.connection, null);
          if (token && this.userId) {
            await accounts.destroyToken(this.userId, token);
          }
          await accounts._successfulLogout(this.connection, this.userId);
          await this.setUserId(null);
        };

        // Generates a new login token with the same expiration as the
        // connection's current token and saves it to the database. Associates
        // the connection with this new token and returns it. Throws an error
        // if called on a connection that isn't logged in.
        //
        // @returns Object
        //   If successful, returns { token: <new token>, id: <user id>,
        //   tokenExpires: <expiration date> }.
        methods.getNewToken = async function () {
          const user = await accounts.users.findOneAsync(this.userId, {
            fields: {
              "services.resume.loginTokens": 1
            }
          });
          if (!this.userId || !user) {
            throw new Meteor.Error("You are not logged in.");
          }
          // Be careful not to generate a new token that has a later
          // expiration than the curren token. Otherwise, a bad guy with a
          // stolen token could use this method to stop his stolen token from
          // ever expiring.
          const currentHashedToken = accounts._getLoginToken(this.connection.id);
          const currentStampedToken = user.services.resume.loginTokens.find(stampedToken => stampedToken.hashedToken === currentHashedToken);
          if (!currentStampedToken) {
            // safety belt: this should never happen
            throw new Meteor.Error("Invalid login token");
          }
          const newStampedToken = accounts._generateStampedLoginToken();
          newStampedToken.when = currentStampedToken.when;
          await accounts._insertLoginToken(this.userId, newStampedToken);
          return await accounts._loginUser(this, this.userId, newStampedToken);
        };

        // Removes all tokens except the token associated with the current
        // connection. Throws an error if the connection is not logged
        // in. Returns nothing on success.
        methods.removeOtherTokens = async function () {
          if (!this.userId) {
            throw new Meteor.Error("You are not logged in.");
          }
          const currentToken = accounts._getLoginToken(this.connection.id);
          await accounts.users.updateAsync(this.userId, {
            $pull: {
              "services.resume.loginTokens": {
                hashedToken: {
                  $ne: currentToken
                }
              }
            }
          });
        };

        // Allow a one-time configuration for a login service. Modifications
        // to this collection are also allowed in insecure mode.
        methods.configureLoginService = async options => {
          check(options, Match.ObjectIncluding({
            service: String
          }));
          // Don't let random users configure a service we haven't added yet (so
          // that when we do later add it, it's set up with their configuration
          // instead of ours).
          // XXX if service configuration is oauth-specific then this code should
          //     be in accounts-oauth; if it's not then the registry should be
          //     in this package
          if (!(accounts.oauth && accounts.oauth.serviceNames().includes(options.service))) {
            throw new Meteor.Error(403, "Service unknown");
          }
          if (Package['service-configuration']) {
            const {
              ServiceConfiguration
            } = Package['service-configuration'];
            const service = await ServiceConfiguration.configurations.findOneAsync({
              service: options.service
            });
            if (service) throw new Meteor.Error(403, "Service ".concat(options.service, " already configured"));
            if (Package["oauth-encryption"]) {
              const {
                OAuthEncryption
              } = Package["oauth-encryption"];
              if (hasOwn.call(options, 'secret') && OAuthEncryption.keyIsLoaded()) options.secret = OAuthEncryption.seal(options.secret);
            }
            await ServiceConfiguration.configurations.insertAsync(options);
          }
        };
        accounts._server.methods(methods);
      }
      _initAccountDataHooks() {
        this._server.onConnection(connection => {
          this._accountData[connection.id] = {
            connection: connection
          };
          connection.onClose(() => {
            this._removeTokenFromConnection(connection.id);
            delete this._accountData[connection.id];
          });
        });
      }
      _initServerPublications() {
        // Bring into lexical scope for publish callbacks that need `this`
        const {
          users,
          _autopublishFields,
          _defaultPublishFields
        } = this;

        // Publish all login service configuration fields other than secret.
        this._server.publish("meteor.loginServiceConfiguration", function () {
          if (Package['service-configuration']) {
            const {
              ServiceConfiguration
            } = Package['service-configuration'];
            return ServiceConfiguration.configurations.find({}, {
              fields: {
                secret: 0
              }
            });
          }
          this.ready();
        }, {
          is_auto: true
        }); // not technically autopublish, but stops the warning.

        // Use Meteor.startup to give other packages a chance to call
        // setDefaultPublishFields.
        Meteor.startup(() => {
          // Merge custom fields selector and default publish fields so that the client
          // gets all the necessary fields to run properly
          const customFields = this._addDefaultFieldSelector().fields || {};
          const keys = Object.keys(customFields);
          // If the custom fields are negative, then ignore them and only send the necessary fields
          const fields = keys.length > 0 && customFields[keys[0]] ? _objectSpread(_objectSpread({}, this._addDefaultFieldSelector().fields), _defaultPublishFields.projection) : _defaultPublishFields.projection;
          // Publish the current user's record to the client.
          this._server.publish(null, function () {
            if (this.userId) {
              return users.find({
                _id: this.userId
              }, {
                fields
              });
            } else {
              return null;
            }
          }, /*suppress autopublish warning*/{
            is_auto: true
          });
        });

        // Use Meteor.startup to give other packages a chance to call
        // addAutopublishFields.
        Package.autopublish && Meteor.startup(() => {
          // ['profile', 'username'] -> {profile: 1, username: 1}
          const toFieldSelector = fields => fields.reduce((prev, field) => _objectSpread(_objectSpread({}, prev), {}, {
            [field]: 1
          }), {});
          this._server.publish(null, function () {
            if (this.userId) {
              return users.find({
                _id: this.userId
              }, {
                fields: toFieldSelector(_autopublishFields.loggedInUser)
              });
            } else {
              return null;
            }
          }, /*suppress autopublish warning*/{
            is_auto: true
          });

          // XXX this publish is neither dedup-able nor is it optimized by our special
          // treatment of queries on a specific _id. Therefore this will have O(n^2)
          // run-time performance every time a user document is changed (eg someone
          // logging in). If this is a problem, we can instead write a manual publish
          // function which filters out fields based on 'this.userId'.
          this._server.publish(null, function () {
            const selector = this.userId ? {
              _id: {
                $ne: this.userId
              }
            } : {};
            return users.find(selector, {
              fields: toFieldSelector(_autopublishFields.otherUsers)
            });
          }, /*suppress autopublish warning*/{
            is_auto: true
          });
        });
      }
      // Add to the list of fields or subfields to be automatically
      // published if autopublish is on. Must be called from top-level
      // code (ie, before Meteor.startup hooks run).
      //
      // @param opts {Object} with:
      //   - forLoggedInUser {Array} Array of fields published to the logged-in user
      //   - forOtherUsers {Array} Array of fields published to users that aren't logged in
      addAutopublishFields(opts) {
        this._autopublishFields.loggedInUser.push.apply(this._autopublishFields.loggedInUser, opts.forLoggedInUser);
        this._autopublishFields.otherUsers.push.apply(this._autopublishFields.otherUsers, opts.forOtherUsers);
      }
      // Replaces the fields to be automatically
      // published when the user logs in
      //
      // @param {MongoFieldSpecifier} fields Dictionary of fields to return or exclude.
      setDefaultPublishFields(fields) {
        this._defaultPublishFields.projection = fields;
      }
      ///
      /// ACCOUNT DATA
      ///

      // HACK: This is used by 'meteor-accounts' to get the loginToken for a
      // connection. Maybe there should be a public way to do that.
      _getAccountData(connectionId, field) {
        const data = this._accountData[connectionId];
        return data && data[field];
      }
      _setAccountData(connectionId, field, value) {
        const data = this._accountData[connectionId];

        // safety belt. shouldn't happen. accountData is set in onConnection,
        // we don't have a connectionId until it is set.
        if (!data) return;
        if (value === undefined) delete data[field];else data[field] = value;
      }
      ///
      /// RECONNECT TOKENS
      ///
      /// support reconnecting using a meteor login token

      _hashLoginToken(loginToken) {
        const hash = crypto.createHash('sha256');
        hash.update(loginToken);
        return hash.digest('base64');
      }
      // {token, when} => {hashedToken, when}
      _hashStampedToken(stampedToken) {
        const {
            token
          } = stampedToken,
          hashedStampedToken = _objectWithoutProperties(stampedToken, _excluded);
        return _objectSpread(_objectSpread({}, hashedStampedToken), {}, {
          hashedToken: this._hashLoginToken(token)
        });
      }
      // Using $addToSet avoids getting an index error if another client
      // logging in simultaneously has already inserted the new hashed
      // token.
      async _insertHashedLoginToken(userId, hashedToken, query) {
        query = query ? _objectSpread({}, query) : {};
        query._id = userId;
        await this.users.updateAsync(query, {
          $addToSet: {
            "services.resume.loginTokens": hashedToken
          }
        });
      }
      // Exported for tests.
      async _insertLoginToken(userId, stampedToken, query) {
        await this._insertHashedLoginToken(userId, this._hashStampedToken(stampedToken), query);
      }
      /**
       *
       * @param userId
       * @private
       * @returns {Promise<void>}
       */
      _clearAllLoginTokens(userId) {
        this.users.updateAsync(userId, {
          $set: {
            'services.resume.loginTokens': []
          }
        });
      }
      // test hook
      _getUserObserve(connectionId) {
        return this._userObservesForConnections[connectionId];
      }
      // Clean up this connection's association with the token: that is, stop
      // the observe that we started when we associated the connection with
      // this token.
      _removeTokenFromConnection(connectionId) {
        if (hasOwn.call(this._userObservesForConnections, connectionId)) {
          const observe = this._userObservesForConnections[connectionId];
          if (typeof observe === 'number') {
            // We're in the process of setting up an observe for this connection. We
            // can't clean up that observe yet, but if we delete the placeholder for
            // this connection, then the observe will get cleaned up as soon as it has
            // been set up.
            delete this._userObservesForConnections[connectionId];
          } else {
            delete this._userObservesForConnections[connectionId];
            observe.stop();
          }
        }
      }
      _getLoginToken(connectionId) {
        return this._getAccountData(connectionId, 'loginToken');
      }
      // newToken is a hashed token.
      _setLoginToken(userId, connection, newToken) {
        this._removeTokenFromConnection(connection.id);
        this._setAccountData(connection.id, 'loginToken', newToken);
        if (newToken) {
          // Set up an observe for this token. If the token goes away, we need
          // to close the connection.  We defer the observe because there's
          // no need for it to be on the critical path for login; we just need
          // to ensure that the connection will get closed at some point if
          // the token gets deleted.
          //
          // Initially, we set the observe for this connection to a number; this
          // signifies to other code (which might run while we yield) that we are in
          // the process of setting up an observe for this connection. Once the
          // observe is ready to go, we replace the number with the real observe
          // handle (unless the placeholder has been deleted or replaced by a
          // different placehold number, signifying that the connection was closed
          // already -- in this case we just clean up the observe that we started).
          const myObserveNumber = ++this._nextUserObserveNumber;
          this._userObservesForConnections[connection.id] = myObserveNumber;
          Meteor.defer(async () => {
            // If something else happened on this connection in the meantime (it got
            // closed, or another call to _setLoginToken happened), just do
            // nothing. We don't need to start an observe for an old connection or old
            // token.
            if (this._userObservesForConnections[connection.id] !== myObserveNumber) {
              return;
            }
            let foundMatchingUser;
            // Because we upgrade unhashed login tokens to hashed tokens at
            // login time, sessions will only be logged in with a hashed
            // token. Thus we only need to observe hashed tokens here.
            const observe = await this.users.find({
              _id: userId,
              'services.resume.loginTokens.hashedToken': newToken
            }, {
              fields: {
                _id: 1
              }
            }).observeChanges({
              added: () => {
                foundMatchingUser = true;
              },
              removed: connection.close
              // The onClose callback for the connection takes care of
              // cleaning up the observe handle and any other state we have
              // lying around.
            }, {
              nonMutatingCallbacks: true
            });

            // If the user ran another login or logout command we were waiting for the
            // defer or added to fire (ie, another call to _setLoginToken occurred),
            // then we let the later one win (start an observe, etc) and just stop our
            // observe now.
            //
            // Similarly, if the connection was already closed, then the onClose
            // callback would have called _removeTokenFromConnection and there won't
            // be an entry in _userObservesForConnections. We can stop the observe.
            if (this._userObservesForConnections[connection.id] !== myObserveNumber) {
              observe.stop();
              return;
            }
            this._userObservesForConnections[connection.id] = observe;
            if (!foundMatchingUser) {
              // We've set up an observe on the user associated with `newToken`,
              // so if the new token is removed from the database, we'll close
              // the connection. But the token might have already been deleted
              // before we set up the observe, which wouldn't have closed the
              // connection because the observe wasn't running yet.
              connection.close();
            }
          });
        }
      }
      // (Also used by Meteor Accounts server and tests).
      //
      _generateStampedLoginToken() {
        return {
          token: Random.secret(),
          when: new Date()
        };
      }
      ///
      /// TOKEN EXPIRATION
      ///

      // Deletes expired password reset tokens from the database.
      //
      // Exported for tests. Also, the arguments are only used by
      // tests. oldestValidDate is simulate expiring tokens without waiting
      // for them to actually expire. userId is used by tests to only expire
      // tokens for the test user.
      async _expirePasswordResetTokens(oldestValidDate, userId) {
        const tokenLifetimeMs = this._getPasswordResetTokenLifetimeMs();

        // when calling from a test with extra arguments, you must specify both!
        if (oldestValidDate && !userId || !oldestValidDate && userId) {
          throw new Error("Bad test. Must specify both oldestValidDate and userId.");
        }
        oldestValidDate = oldestValidDate || new Date(new Date() - tokenLifetimeMs);
        const tokenFilter = {
          $or: [{
            "services.password.reset.reason": "reset"
          }, {
            "services.password.reset.reason": {
              $exists: false
            }
          }]
        };
        await expirePasswordToken(this, oldestValidDate, tokenFilter, userId);
      }

      // Deletes expired password enroll tokens from the database.
      //
      // Exported for tests. Also, the arguments are only used by
      // tests. oldestValidDate is simulate expiring tokens without waiting
      // for them to actually expire. userId is used by tests to only expire
      // tokens for the test user.
      async _expirePasswordEnrollTokens(oldestValidDate, userId) {
        const tokenLifetimeMs = this._getPasswordEnrollTokenLifetimeMs();

        // when calling from a test with extra arguments, you must specify both!
        if (oldestValidDate && !userId || !oldestValidDate && userId) {
          throw new Error("Bad test. Must specify both oldestValidDate and userId.");
        }
        oldestValidDate = oldestValidDate || new Date(new Date() - tokenLifetimeMs);
        const tokenFilter = {
          "services.password.enroll.reason": "enroll"
        };
        await expirePasswordToken(this, oldestValidDate, tokenFilter, userId);
      }

      // Deletes expired tokens from the database and closes all open connections
      // associated with these tokens.
      //
      // Exported for tests. Also, the arguments are only used by
      // tests. oldestValidDate is simulate expiring tokens without waiting
      // for them to actually expire. userId is used by tests to only expire
      // tokens for the test user.
      /**
       *
       * @param oldestValidDate
       * @param userId
       * @private
       * @return {Promise<void>}
       */
      async _expireTokens(oldestValidDate, userId) {
        const tokenLifetimeMs = this._getTokenLifetimeMs();

        // when calling from a test with extra arguments, you must specify both!
        if (oldestValidDate && !userId || !oldestValidDate && userId) {
          throw new Error("Bad test. Must specify both oldestValidDate and userId.");
        }
        oldestValidDate = oldestValidDate || new Date(new Date() - tokenLifetimeMs);
        const userFilter = userId ? {
          _id: userId
        } : {};

        // Backwards compatible with older versions of meteor that stored login token
        // timestamps as numbers.
        await this.users.updateAsync(_objectSpread(_objectSpread({}, userFilter), {}, {
          $or: [{
            "services.resume.loginTokens.when": {
              $lt: oldestValidDate
            }
          }, {
            "services.resume.loginTokens.when": {
              $lt: +oldestValidDate
            }
          }]
        }), {
          $pull: {
            "services.resume.loginTokens": {
              $or: [{
                when: {
                  $lt: oldestValidDate
                }
              }, {
                when: {
                  $lt: +oldestValidDate
                }
              }]
            }
          }
        }, {
          multi: true
        });
        // The observe on Meteor.users will take care of closing connections for
        // expired tokens.
      }
      // @override from accounts_common.js
      config(options) {
        // Call the overridden implementation of the method.
        const superResult = AccountsCommon.prototype.config.apply(this, arguments);

        // If the user set loginExpirationInDays to null, then we need to clear the
        // timer that periodically expires tokens.
        if (hasOwn.call(this._options, 'loginExpirationInDays') && this._options.loginExpirationInDays === null && this.expireTokenInterval) {
          Meteor.clearInterval(this.expireTokenInterval);
          this.expireTokenInterval = null;
        }
        return superResult;
      }
      // Called by accounts-password
      async insertUserDoc(options, user) {
        // - clone user document, to protect from modification
        // - add createdAt timestamp
        // - prepare an _id, so that you can modify other collections (eg
        // create a first task for every new user)
        //
        // XXX If the onCreateUser or validateNewUser hooks fail, we might
        // end up having modified some other collection
        // inappropriately. The solution is probably to have onCreateUser
        // accept two callbacks - one that gets called before inserting
        // the user document (in which you can modify its contents), and
        // one that gets called after (in which you should change other
        // collections)
        user = _objectSpread({
          createdAt: new Date(),
          _id: Random.id()
        }, user);
        if (user.services) {
          Object.keys(user.services).forEach(service => pinEncryptedFieldsToUser(user.services[service], user._id));
        }
        let fullUser;
        if (this._onCreateUserHook) {
          // Allows _onCreateUserHook to be a promise returning func
          fullUser = await this._onCreateUserHook(options, user);

          // This is *not* part of the API. We need this because we can't isolate
          // the global server environment between tests, meaning we can't test
          // both having a create user hook set and not having one set.
          if (fullUser === 'TEST DEFAULT HOOK') fullUser = defaultCreateUserHook(options, user);
        } else {
          fullUser = defaultCreateUserHook(options, user);
        }
        var _iteratorAbruptCompletion = false;
        var _didIteratorError = false;
        var _iteratorError;
        try {
          for (var _iterator = _asyncIterator(this._validateNewUserHooks), _step; _iteratorAbruptCompletion = !(_step = await _iterator.next()).done; _iteratorAbruptCompletion = false) {
            const hook = _step.value;
            {
              if (!(await hook(fullUser))) throw new Meteor.Error(403, "User validation failed");
            }
          }
        } catch (err) {
          _didIteratorError = true;
          _iteratorError = err;
        } finally {
          try {
            if (_iteratorAbruptCompletion && _iterator.return != null) {
              await _iterator.return();
            }
          } finally {
            if (_didIteratorError) {
              throw _iteratorError;
            }
          }
        }
        let userId;
        try {
          userId = await this.users.insertAsync(fullUser);
        } catch (e) {
          // XXX string parsing sucks, maybe
          // https://jira.mongodb.org/browse/SERVER-3069 will get fixed one day
          // https://jira.mongodb.org/browse/SERVER-4637
          if (!e.errmsg) throw e;
          if (e.errmsg.includes('emails.address')) throw new Meteor.Error(403, "Email already exists.");
          if (e.errmsg.includes('username')) throw new Meteor.Error(403, "Username already exists.");
          throw e;
        }
        return userId;
      }
      // Helper function: returns false if email does not match company domain from
      // the configuration.
      _testEmailDomain(email) {
        const domain = this._options.restrictCreationByEmailDomain;
        return !domain || typeof domain === 'function' && domain(email) || typeof domain === 'string' && new RegExp("@".concat(Meteor._escapeRegExp(domain), "$"), 'i').test(email);
      }
      ///
      /// CLEAN UP FOR `logoutOtherClients`
      ///

      async _deleteSavedTokensForUser(userId, tokensToDelete) {
        if (tokensToDelete) {
          await this.users.updateAsync(userId, {
            $unset: {
              "services.resume.haveLoginTokensToDelete": 1,
              "services.resume.loginTokensToDelete": 1
            },
            $pullAll: {
              "services.resume.loginTokens": tokensToDelete
            }
          });
        }
      }
      _deleteSavedTokensForAllUsersOnStartup() {
        // If we find users who have saved tokens to delete on startup, delete
        // them now. It's possible that the server could have crashed and come
        // back up before new tokens are found in localStorage, but this
        // shouldn't happen very often. We shouldn't put a delay here because
        // that would give a lot of power to an attacker with a stolen login
        // token and the ability to crash the server.
        Meteor.startup(async () => {
          const users = await this.users.find({
            "services.resume.haveLoginTokensToDelete": true
          }, {
            fields: {
              "services.resume.loginTokensToDelete": 1
            }
          });
          users.forEach(user => {
            this._deleteSavedTokensForUser(user._id, user.services.resume.loginTokensToDelete)
            // We don't need to wait for this to complete.
            .then(_ => _).catch(err => {
              console.log(err);
            });
          });
        });
      }
      ///
      /// MANAGING USER OBJECTS
      ///

      // Updates or creates a user after we authenticate with a 3rd party.
      //
      // @param serviceName {String} Service name (eg, twitter).
      // @param serviceData {Object} Data to store in the user's record
      //        under services[serviceName]. Must include an "id" field
      //        which is a unique identifier for the user in the service.
      // @param options {Object, optional} Other options to pass to insertUserDoc
      //        (eg, profile)
      // @returns {Object} Object with token and id keys, like the result
      //        of the "login" method.
      //
      async updateOrCreateUserFromExternalService(serviceName, serviceData, options) {
        options = _objectSpread({}, options);
        if (serviceName === "password" || serviceName === "resume") {
          throw new Error("Can't use updateOrCreateUserFromExternalService with internal service " + serviceName);
        }
        if (!hasOwn.call(serviceData, 'id')) {
          throw new Error("Service data for service ".concat(serviceName, " must include id"));
        }

        // Look for a user with the appropriate service user id.
        const selector = {};
        const serviceIdKey = "services.".concat(serviceName, ".id");

        // XXX Temporary special case for Twitter. (Issue #629)
        //   The serviceData.id will be a string representation of an integer.
        //   We want it to match either a stored string or int representation.
        //   This is to cater to earlier versions of Meteor storing twitter
        //   user IDs in number form, and recent versions storing them as strings.
        //   This can be removed once migration technology is in place, and twitter
        //   users stored with integer IDs have been migrated to string IDs.
        if (serviceName === "twitter" && !isNaN(serviceData.id)) {
          selector["$or"] = [{}, {}];
          selector["$or"][0][serviceIdKey] = serviceData.id;
          selector["$or"][1][serviceIdKey] = parseInt(serviceData.id, 10);
        } else {
          selector[serviceIdKey] = serviceData.id;
        }
        let user = await this.users.findOneAsync(selector, {
          fields: this._options.defaultFieldSelector
        });
        // Check to see if the developer has a custom way to find the user outside
        // of the general selectors above.
        if (!user && this._additionalFindUserOnExternalLogin) {
          user = await this._additionalFindUserOnExternalLogin({
            serviceName,
            serviceData,
            options
          });
        }

        // Before continuing, run user hook to see if we should continue
        if (this._beforeExternalLoginHook && !(await this._beforeExternalLoginHook(serviceName, serviceData, user))) {
          throw new Meteor.Error(403, "Login forbidden");
        }

        // When creating a new user we pass through all options. When updating an
        // existing user, by default we only process/pass through the serviceData
        // (eg, so that we keep an unexpired access token and don't cache old email
        // addresses in serviceData.email). The onExternalLogin hook can be used when
        // creating or updating a user, to modify or pass through more options as
        // needed.
        let opts = user ? {} : options;
        if (this._onExternalLoginHook) {
          opts = await this._onExternalLoginHook(options, user);
        }
        if (user) {
          await pinEncryptedFieldsToUser(serviceData, user._id);
          let setAttrs = {};
          Object.keys(serviceData).forEach(key => setAttrs["services.".concat(serviceName, ".").concat(key)] = serviceData[key]);

          // XXX Maybe we should re-use the selector above and notice if the update
          //     touches nothing?
          setAttrs = _objectSpread(_objectSpread({}, setAttrs), opts);
          await this.users.updateAsync(user._id, {
            $set: setAttrs
          });
          return {
            type: serviceName,
            userId: user._id
          };
        } else {
          // Create a new user with the service data.
          user = {
            services: {}
          };
          user.services[serviceName] = serviceData;
          const userId = await this.insertUserDoc(opts, user);
          return {
            type: serviceName,
            userId
          };
        }
      }
      /**
       * @summary Removes default rate limiting rule
       * @locus Server
       * @importFromPackage accounts-base
       */
      removeDefaultRateLimit() {
        const resp = DDPRateLimiter.removeRule(this.defaultRateLimiterRuleId);
        this.defaultRateLimiterRuleId = null;
        return resp;
      }
      /**
       * @summary Add a default rule of limiting logins, creating new users and password reset
       * to 5 times every 10 seconds per connection.
       * @locus Server
       * @importFromPackage accounts-base
       */
      addDefaultRateLimit() {
        if (!this.defaultRateLimiterRuleId) {
          this.defaultRateLimiterRuleId = DDPRateLimiter.addRule({
            userId: null,
            clientAddress: null,
            type: 'method',
            name: name => ['login', 'createUser', 'resetPassword', 'forgotPassword'].includes(name),
            connectionId: connectionId => true
          }, 5, 10000);
        }
      }
      /**
       * @summary Creates options for email sending for reset password and enroll account emails.
       * You can use this function when customizing a reset password or enroll account email sending.
       * @locus Server
       * @param {Object} email Which address of the user's to send the email to.
       * @param {Object} user The user object to generate options for.
       * @param {String} url URL to which user is directed to confirm the email.
       * @param {String} reason `resetPassword` or `enrollAccount`.
       * @returns {Object} Options which can be passed to `Email.send`.
       * @importFromPackage accounts-base
       */
      async generateOptionsForEmail(email, user, url, reason) {
        let extra = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : {};
        const options = {
          to: email,
          from: this.emailTemplates[reason].from ? await this.emailTemplates[reason].from(user) : this.emailTemplates.from,
          subject: await this.emailTemplates[reason].subject(user, url, extra)
        };
        if (typeof this.emailTemplates[reason].text === 'function') {
          options.text = await this.emailTemplates[reason].text(user, url, extra);
        }
        if (typeof this.emailTemplates[reason].html === 'function') {
          options.html = await this.emailTemplates[reason].html(user, url, extra);
        }
        if (typeof this.emailTemplates.headers === 'object') {
          options.headers = this.emailTemplates.headers;
        }
        return options;
      }
      async _checkForCaseInsensitiveDuplicates(fieldName, displayName, fieldValue, ownUserId) {
        // Some tests need the ability to add users with the same case insensitive
        // value, hence the _skipCaseInsensitiveChecksForTest check
        const skipCheck = Object.prototype.hasOwnProperty.call(this._skipCaseInsensitiveChecksForTest, fieldValue);
        if (fieldValue && !skipCheck) {
          const matchedUsers = await Meteor.users.find(this._selectorForFastCaseInsensitiveLookup(fieldName, fieldValue), {
            fields: {
              _id: 1
            },
            // we only need a maximum of 2 users for the logic below to work
            limit: 2
          }).fetchAsync();
          if (matchedUsers.length > 0 && (
          // If we don't have a userId yet, any match we find is a duplicate
          !ownUserId ||
          // Otherwise, check to see if there are multiple matches or a match
          // that is not us
          matchedUsers.length > 1 || matchedUsers[0]._id !== ownUserId)) {
            this._handleError("".concat(displayName, " already exists."));
          }
        }
      }
      async _createUserCheckingDuplicates(_ref) {
        let {
          user,
          email,
          username,
          options
        } = _ref;
        const newUser = _objectSpread(_objectSpread(_objectSpread({}, user), username ? {
          username
        } : {}), email ? {
          emails: [{
            address: email,
            verified: false
          }]
        } : {});

        // Perform a case insensitive check before insert
        await this._checkForCaseInsensitiveDuplicates('username', 'Username', username);
        await this._checkForCaseInsensitiveDuplicates('emails.address', 'Email', email);
        const userId = await this.insertUserDoc(options, newUser);
        // Perform another check after insert, in case a matching user has been
        // inserted in the meantime
        try {
          await this._checkForCaseInsensitiveDuplicates('username', 'Username', username, userId);
          await this._checkForCaseInsensitiveDuplicates('emails.address', 'Email', email, userId);
        } catch (ex) {
          // Remove inserted user if the check fails
          await Meteor.users.removeAsync(userId);
          throw ex;
        }
        return userId;
      }
    }
    // Give each login hook callback a fresh cloned copy of the attempt
    // object, but don't clone the connection.
    //
    const cloneAttemptWithConnection = (connection, attempt) => {
      const clonedAttempt = EJSON.clone(attempt);
      clonedAttempt.connection = connection;
      return clonedAttempt;
    };
    const tryLoginMethod = async (type, fn) => {
      let result;
      try {
        result = await fn();
      } catch (e) {
        result = {
          error: e
        };
      }
      if (result && !result.type && type) result.type = type;
      return result;
    };
    const setupDefaultLoginHandlers = accounts => {
      accounts.registerLoginHandler("resume", function (options) {
        return defaultResumeLoginHandler.call(this, accounts, options);
      });
    };

    // Login handler for resume tokens.
    const defaultResumeLoginHandler = async (accounts, options) => {
      if (!options.resume) return undefined;
      check(options.resume, String);
      const hashedToken = accounts._hashLoginToken(options.resume);

      // First look for just the new-style hashed login token, to avoid
      // sending the unhashed token to the database in a query if we don't
      // need to.
      let user = await accounts.users.findOneAsync({
        "services.resume.loginTokens.hashedToken": hashedToken
      }, {
        fields: {
          "services.resume.loginTokens.$": 1
        }
      });
      if (!user) {
        // If we didn't find the hashed login token, try also looking for
        // the old-style unhashed token.  But we need to look for either
        // the old-style token OR the new-style token, because another
        // client connection logging in simultaneously might have already
        // converted the token.
        user = await accounts.users.findOneAsync({
          $or: [{
            "services.resume.loginTokens.hashedToken": hashedToken
          }, {
            "services.resume.loginTokens.token": options.resume
          }]
        },
        // Note: Cannot use ...loginTokens.$ positional operator with $or query.
        {
          fields: {
            "services.resume.loginTokens": 1
          }
        });
      }
      if (!user) return {
        error: new Meteor.Error(403, "You've been logged out by the server. Please log in again.")
      };

      // Find the token, which will either be an object with fields
      // {hashedToken, when} for a hashed token or {token, when} for an
      // unhashed token.
      let oldUnhashedStyleToken;
      let token = await user.services.resume.loginTokens.find(token => token.hashedToken === hashedToken);
      if (token) {
        oldUnhashedStyleToken = false;
      } else {
        token = await user.services.resume.loginTokens.find(token => token.token === options.resume);
        oldUnhashedStyleToken = true;
      }
      const tokenExpires = accounts._tokenExpiration(token.when);
      if (new Date() >= tokenExpires) return {
        userId: user._id,
        error: new Meteor.Error(403, "Your session has expired. Please log in again.")
      };

      // Update to a hashed token when an unhashed token is encountered.
      if (oldUnhashedStyleToken) {
        // Only add the new hashed token if the old unhashed token still
        // exists (this avoids resurrecting the token if it was deleted
        // after we read it).  Using $addToSet avoids getting an index
        // error if another client logging in simultaneously has already
        // inserted the new hashed token.
        await accounts.users.updateAsync({
          _id: user._id,
          "services.resume.loginTokens.token": options.resume
        }, {
          $addToSet: {
            "services.resume.loginTokens": {
              "hashedToken": hashedToken,
              "when": token.when
            }
          }
        });

        // Remove the old token *after* adding the new, since otherwise
        // another client trying to login between our removing the old and
        // adding the new wouldn't find a token to login with.
        await accounts.users.updateAsync(user._id, {
          $pull: {
            "services.resume.loginTokens": {
              "token": options.resume
            }
          }
        });
      }
      return {
        userId: user._id,
        stampedLoginToken: {
          token: options.resume,
          when: token.when
        }
      };
    };
    const expirePasswordToken = async (accounts, oldestValidDate, tokenFilter, userId) => {
      // boolean value used to determine if this method was called from enroll account workflow
      let isEnroll = false;
      const userFilter = userId ? {
        _id: userId
      } : {};
      // check if this method was called from enroll account workflow
      if (tokenFilter['services.password.enroll.reason']) {
        isEnroll = true;
      }
      let resetRangeOr = {
        $or: [{
          "services.password.reset.when": {
            $lt: oldestValidDate
          }
        }, {
          "services.password.reset.when": {
            $lt: +oldestValidDate
          }
        }]
      };
      if (isEnroll) {
        resetRangeOr = {
          $or: [{
            "services.password.enroll.when": {
              $lt: oldestValidDate
            }
          }, {
            "services.password.enroll.when": {
              $lt: +oldestValidDate
            }
          }]
        };
      }
      const expireFilter = {
        $and: [tokenFilter, resetRangeOr]
      };
      if (isEnroll) {
        await accounts.users.updateAsync(_objectSpread(_objectSpread({}, userFilter), expireFilter), {
          $unset: {
            "services.password.enroll": ""
          }
        }, {
          multi: true
        });
      } else {
        await accounts.users.updateAsync(_objectSpread(_objectSpread({}, userFilter), expireFilter), {
          $unset: {
            "services.password.reset": ""
          }
        }, {
          multi: true
        });
      }
    };
    const setExpireTokensInterval = accounts => {
      accounts.expireTokenInterval = Meteor.setInterval(async () => {
        await accounts._expireTokens();
        await accounts._expirePasswordResetTokens();
        await accounts._expirePasswordEnrollTokens();
      }, EXPIRE_TOKENS_INTERVAL_MS);
    };
    const OAuthEncryption = (_Package$oauthEncryp = Package["oauth-encryption"]) === null || _Package$oauthEncryp === void 0 ? void 0 : _Package$oauthEncryp.OAuthEncryption;

    // OAuth service data is temporarily stored in the pending credentials
    // collection during the oauth authentication process.  Sensitive data
    // such as access tokens are encrypted without the user id because
    // we don't know the user id yet.  We re-encrypt these fields with the
    // user id included when storing the service data permanently in
    // the users collection.
    //
    const pinEncryptedFieldsToUser = (serviceData, userId) => {
      Object.keys(serviceData).forEach(key => {
        let value = serviceData[key];
        if (OAuthEncryption !== null && OAuthEncryption !== void 0 && OAuthEncryption.isSealed(value)) value = OAuthEncryption.seal(OAuthEncryption.open(value), userId);
        serviceData[key] = value;
      });
    };

    // XXX see comment on Accounts.createUser in passwords_server about adding a
    // second "server options" argument.
    const defaultCreateUserHook = (options, user) => {
      if (options.profile) user.profile = options.profile;
      return user;
    };

    // Validate new user's email or Google/Facebook/GitHub account's email
    function defaultValidateNewUserHook(user) {
      const domain = this._options.restrictCreationByEmailDomain;
      if (!domain) {
        return true;
      }
      let emailIsGood = false;
      if (user.emails && user.emails.length > 0) {
        emailIsGood = user.emails.reduce((prev, email) => prev || this._testEmailDomain(email.address), false);
      } else if (user.services && Object.values(user.services).length > 0) {
        // Find any email of any service and check it
        emailIsGood = Object.values(user.services).reduce((prev, service) => service.email && this._testEmailDomain(service.email), false);
      }
      if (emailIsGood) {
        return true;
      }
      if (typeof domain === 'string') {
        throw new Meteor.Error(403, "@".concat(domain, " email required"));
      } else {
        throw new Meteor.Error(403, "Email doesn't match the criteria.");
      }
    }
    const setupUsersCollection = async users => {
      ///
      /// RESTRICTING WRITES TO USER OBJECTS
      ///
      users.allow({
        // clients can modify the profile field of their own document, and
        // nothing else.
        update: (userId, user, fields, modifier) => {
          // make sure it is our record
          if (user._id !== userId) {
            return false;
          }

          // user can only modify the 'profile' field. sets to multiple
          // sub-keys (eg profile.foo and profile.bar) are merged into entry
          // in the fields list.
          if (fields.length !== 1 || fields[0] !== 'profile') {
            return false;
          }
          return true;
        },
        fetch: ['_id'] // we only look at _id.
      });

      /// DEFAULT INDEXES ON USERS
      await users.createIndexAsync('username', {
        unique: true,
        sparse: true
      });
      await users.createIndexAsync('emails.address', {
        unique: true,
        sparse: true
      });
      await users.createIndexAsync('services.resume.loginTokens.hashedToken', {
        unique: true,
        sparse: true
      });
      await users.createIndexAsync('services.resume.loginTokens.token', {
        unique: true,
        sparse: true
      });
      // For taking care of logoutOtherClients calls that crashed before the
      // tokens were deleted.
      await users.createIndexAsync('services.resume.haveLoginTokensToDelete', {
        sparse: true
      });
      // For expiring login tokens
      await users.createIndexAsync("services.resume.loginTokens.when", {
        sparse: true
      });
      // For expiring password tokens
      await users.createIndexAsync('services.password.reset.when', {
        sparse: true
      });
      await users.createIndexAsync('services.password.enroll.when', {
        sparse: true
      });
    };

    // Generates permutations of all case variations of a given string.
    const generateCasePermutationsForString = string => {
      let permutations = [''];
      for (let i = 0; i < string.length; i++) {
        const ch = string.charAt(i);
        permutations = [].concat(...permutations.map(prefix => {
          const lowerCaseChar = ch.toLowerCase();
          const upperCaseChar = ch.toUpperCase();
          // Don't add unnecessary permutations when ch is not a letter
          if (lowerCaseChar === upperCaseChar) {
            return [prefix + ch];
          } else {
            return [prefix + lowerCaseChar, prefix + upperCaseChar];
          }
        }));
      }
      return permutations;
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}}}}},{
  "extensions": [
    ".js",
    ".json"
  ]
});


/* Exports */
return {
  export: function () { return {
      Accounts: Accounts
    };},
  require: require,
  eagerModulePaths: [
    "/node_modules/meteor/accounts-base/server_main.js"
  ],
  mainModulePath: "/node_modules/meteor/accounts-base/server_main.js"
}});

//# sourceURL=meteor://💻app/packages/accounts-base.js
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
