var qrcode = require('../index');
var assert = require('assert');

describe('QRCode', function() {
    it('should return dataurl string of generated qrcode', function() {
        // Test from https://github.com/zenozeng/node-yaqrcode/issues/2

        var code = 'data:image/gif;base64,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';

        assert.equal(qrcode('bitcoin:55162b4f35dc8fe637372ac1?amount=0.55169320&label=Order#18'), code);
    });
});
