"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LlmParametersTransformer = void 0;
const typescript_1 = __importDefault(require("typescript"));
const LiteralFactory_1 = require("../../../factories/LiteralFactory");
const MetadataCollection_1 = require("../../../factories/MetadataCollection");
const MetadataFactory_1 = require("../../../factories/MetadataFactory");
const LlmModelPredicator_1 = require("../../../programmers/llm/LlmModelPredicator");
const LlmParametersProgrammer_1 = require("../../../programmers/llm/LlmParametersProgrammer");
const TransformerError_1 = require("../../TransformerError");
var LlmParametersTransformer;
(function (LlmParametersTransformer) {
    LlmParametersTransformer.transform = (props) => {
        var _a;
        // GET GENERIC ARGUMENT
        if (!((_a = props.expression.typeArguments) === null || _a === void 0 ? void 0 : _a.length))
            throw new TransformerError_1.TransformerError({
                code: "typia.llm.parameters",
                message: "no generic argument.",
            });
        const top = props.expression.typeArguments[0];
        if (typescript_1.default.isTypeNode(top) === false)
            return props.expression;
        // GET TYPE
        const model = LlmModelPredicator_1.LlmModelPredicator.getModel({
            checker: props.context.checker,
            method: "parameters",
            node: props.expression.typeArguments[1],
        });
        const config = LlmModelPredicator_1.LlmModelPredicator.getConfig({
            context: props.context,
            method: "parameters",
            model,
            node: props.expression.typeArguments[2],
        });
        const type = props.context.checker.getTypeFromTypeNode(top);
        // VALIDATE TYPE
        const analyze = (validate) => {
            const result = MetadataFactory_1.MetadataFactory.analyze({
                checker: props.context.checker,
                transformer: props.context.transformer,
                options: {
                    absorb: validate,
                    escape: true,
                    constant: true,
                    validate: validate === true
                        ? LlmParametersProgrammer_1.LlmParametersProgrammer.validate({
                            model,
                            config,
                        })
                        : undefined,
                },
                collection: new MetadataCollection_1.MetadataCollection({
                    replace: MetadataCollection_1.MetadataCollection.replace,
                }),
                type,
            });
            if (result.success === false)
                throw TransformerError_1.TransformerError.from({
                    code: "typia.llm.parameters",
                    errors: result.errors,
                });
            return result.data;
        };
        analyze(true);
        // GENERATE LLM SCHEMA
        const out = LlmParametersProgrammer_1.LlmParametersProgrammer.write({
            model,
            metadata: analyze(false),
            config,
        });
        return typescript_1.default.factory.createAsExpression(LiteralFactory_1.LiteralFactory.write(out), props.context.importer.type({
            file: "@samchon/openapi",
            name: typescript_1.default.factory.createQualifiedName(typescript_1.default.factory.createIdentifier("ILlmSchema"), typescript_1.default.factory.createIdentifier("IParameters")),
            arguments: [
                typescript_1.default.factory.createLiteralTypeNode(typescript_1.default.factory.createStringLiteral(model)),
            ],
        }));
    };
})(LlmParametersTransformer || (exports.LlmParametersTransformer = LlmParametersTransformer = {}));
//# sourceMappingURL=LlmParametersTransformer.js.map