class MetadataObjectType {
    name;
    properties;
    description;
    jsDocTags;
    index;
    validated;
    recursive;
    nullables = [];
    /** @internal */
    tagged_ = false;
    /** @internal */
    literal_;
    /* -----------------------------------------------------------
          CONSTRUCTORS
      ----------------------------------------------------------- */
    /** @ignore */
    constructor(props) {
        this.name = props.name;
        this.properties = props.properties;
        this.description = props.description;
        this.jsDocTags = props.jsDocTags;
        this.index = props.index;
        this.validated = props.validated;
        this.recursive = props.recursive;
        this.nullables = props.nullables.slice();
        this.tagged_ = false;
    }
    /** @internal */
    static create(props) {
        return new MetadataObjectType(props);
    }
    /** @internal */
    static _From_without_properties(obj) {
        return MetadataObjectType.create({
            name: obj.name,
            properties: [],
            description: obj.description,
            jsDocTags: obj.jsDocTags,
            index: obj.index,
            validated: false,
            recursive: obj.recursive,
            nullables: obj.nullables.slice(),
        });
    }
    isPlain(level = 0) {
        return (this.recursive === false &&
            this.properties.length < 10 &&
            this.properties.every((property) => property.key.isSoleLiteral() &&
                property.value.size() === 1 &&
                property.value.isRequired() === true &&
                property.value.nullable === false &&
                (property.value.atomics.length === 1 ||
                    (level < 1 &&
                        property.value.objects.length === 1 &&
                        property.value.objects[0].type.isPlain(level + 1)))));
    }
    isLiteral() {
        return (this.literal_ ??= (() => {
            if (this.recursive === true)
                return false;
            return (this.name === "__type" ||
                this.name === "__object" ||
                this.name.startsWith("__type.") ||
                this.name.startsWith("__object.") ||
                this.name.includes("readonly ["));
        })());
    }
    toJSON() {
        return {
            name: this.name,
            properties: this.properties.map((property) => property.toJSON()),
            description: this.description,
            jsDocTags: this.jsDocTags,
            index: this.index,
            recursive: this.recursive,
            nullables: this.nullables.slice(),
        };
    }
}
/** @internal */
(function (MetadataObjectType) {
    MetadataObjectType.intersects = (x, y) => x.properties.some((prop) => y.properties.find((oppo) => prop.key.getName() === oppo.key.getName()) !== undefined);
    MetadataObjectType.covers = (x, y) => x.properties.length >= y.properties.length &&
        x.properties.every((prop) => y.properties.find((oppo) => prop.key.getName() === oppo.key.getName()) !== undefined);
})(MetadataObjectType || (MetadataObjectType = {}));

export { MetadataObjectType };
//# sourceMappingURL=MetadataObjectType.mjs.map
