import { Metadata } from './Metadata.mjs';
import { MetadataParameter } from './MetadataParameter.mjs';

class MetadataFunction {
    parameters;
    output;
    async;
    /** @ignore */
    constructor(props) {
        this.parameters = props.parameters;
        this.output = props.output;
        this.async = props.async;
    }
    /** @internal */
    static create(props) {
        return new MetadataFunction(props);
    }
    static from(json, dict) {
        return MetadataFunction.create({
            parameters: json.parameters.map((p) => MetadataParameter.from(p, dict)),
            output: Metadata.from(json.output, dict),
            async: json.async,
        });
    }
    toJSON() {
        return {
            parameters: this.parameters.map((p) => p.toJSON()),
            output: this.output.toJSON(),
            async: this.async,
        };
    }
}

export { MetadataFunction };
//# sourceMappingURL=MetadataFunction.mjs.map
