import { Metadata } from './Metadata.mjs';

class MetadataEscaped {
    original;
    returns;
    /** @ignore */
    constructor(props) {
        this.original = props.original;
        this.returns = props.returns;
    }
    /** @internal */
    static from(props, dict) {
        return MetadataEscaped.create({
            original: Metadata.from(props.original, dict),
            returns: Metadata.from(props.returns, dict),
        });
    }
    /** @internal */
    static create(props) {
        return new MetadataEscaped(props);
    }
    getName() {
        return this.returns.getName();
    }
    toJSON() {
        return {
            original: this.original.toJSON(),
            returns: this.returns.toJSON(),
        };
    }
}

export { MetadataEscaped };
//# sourceMappingURL=MetadataEscaped.mjs.map
