"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetadataEscaped = void 0;
const Metadata_1 = require("./Metadata");
class MetadataEscaped {
    /** @ignore */
    constructor(props) {
        this.original = props.original;
        this.returns = props.returns;
    }
    /** @internal */
    static from(props, dict) {
        return MetadataEscaped.create({
            original: Metadata_1.Metadata.from(props.original, dict),
            returns: Metadata_1.Metadata.from(props.returns, dict),
        });
    }
    /** @internal */
    static create(props) {
        return new MetadataEscaped(props);
    }
    getName() {
        return this.returns.getName();
    }
    toJSON() {
        return {
            original: this.original.toJSON(),
            returns: this.returns.toJSON(),
        };
    }
}
exports.MetadataEscaped = MetadataEscaped;
//# sourceMappingURL=MetadataEscaped.js.map