import { Metadata } from './Metadata.mjs';
import { MetadataComponents } from './MetadataComponents.mjs';

class MetadataApplication {
    metadatas;
    components;
    /** @ignore */
    constructor(props) {
        this.metadatas = props.metadatas;
        this.components = props.components;
    }
    /** @internal */
    static create(props) {
        return new MetadataApplication(props);
    }
    static from(app) {
        const components = MetadataComponents.from(app.components);
        const metadatas = app.metadatas.map((metadata) => Metadata.from(metadata, components.dictionary));
        return MetadataApplication.create({ metadatas, components });
    }
    toJSON() {
        return {
            metadatas: this.metadatas.map((metadata) => metadata.toJSON()),
            components: this.components.toJSON(),
        };
    }
}

export { MetadataApplication };
//# sourceMappingURL=MetadataApplication.mjs.map
