"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetadataApplication = void 0;
const Metadata_1 = require("./Metadata");
const MetadataComponents_1 = require("./MetadataComponents");
class MetadataApplication {
    /** @ignore */
    constructor(props) {
        this.metadatas = props.metadatas;
        this.components = props.components;
    }
    /** @internal */
    static create(props) {
        return new MetadataApplication(props);
    }
    static from(app) {
        const components = MetadataComponents_1.MetadataComponents.from(app.components);
        const metadatas = app.metadatas.map((metadata) => Metadata_1.Metadata.from(metadata, components.dictionary));
        return MetadataApplication.create({ metadatas, components });
    }
    toJSON() {
        return {
            metadatas: this.metadatas.map((metadata) => metadata.toJSON()),
            components: this.components.toJSON(),
        };
    }
}
exports.MetadataApplication = MetadataApplication;
//# sourceMappingURL=MetadataApplication.js.map