import ts from 'typescript';
import { IdentifierFactory } from '../../factories/IdentifierFactory.mjs';
import { StatementFactory } from '../../factories/StatementFactory.mjs';
import { TypeFactory } from '../../factories/TypeFactory.mjs';
import { FeatureProgrammer } from '../FeatureProgrammer.mjs';
import { ValidateProgrammer } from '../ValidateProgrammer.mjs';
import { FunctionProgrammer } from '../helpers/FunctionProgrammer.mjs';
import { ProtobufEncodeProgrammer } from './ProtobufEncodeProgrammer.mjs';

var ProtobufValidateEncodeProgrammer;
(function (ProtobufValidateEncodeProgrammer) {
    ProtobufValidateEncodeProgrammer.decompose = (props) => {
        const validate = ValidateProgrammer.decompose({
            ...props,
            context: {
                ...props.context,
                options: {
                    ...props.context.options,
                    functional: false,
                    numeric: true,
                },
            },
            config: {
                equals: false,
            },
        });
        const encode = ProtobufEncodeProgrammer.decompose(props);
        return {
            functions: {
                ...validate.functions,
                ...encode.functions,
            },
            statements: [
                ...validate.statements,
                ...encode.statements,
                StatementFactory.constant({
                    name: "__validate",
                    value: validate.arrow,
                }),
                StatementFactory.constant({
                    name: "__encode",
                    value: encode.arrow,
                }),
            ],
            arrow: ts.factory.createArrowFunction(undefined, undefined, [IdentifierFactory.parameter("input", TypeFactory.keyword("any"))], props.context.importer.type({
                file: "typia",
                name: "IValidation",
                arguments: [
                    encode.arrow.type ??
                        ts.factory.createTypeReferenceNode("Uint8Array"),
                ],
            }), undefined, ts.factory.createBlock([
                StatementFactory.constant({
                    name: "result",
                    value: ts.factory.createAsExpression(ts.factory.createCallExpression(ts.factory.createIdentifier("__validate"), undefined, [ts.factory.createIdentifier("input")]), TypeFactory.keyword("any")),
                }),
                ts.factory.createIfStatement(ts.factory.createIdentifier("result.success"), ts.factory.createExpressionStatement(ts.factory.createBinaryExpression(ts.factory.createIdentifier("result.data"), ts.SyntaxKind.EqualsToken, ts.factory.createCallExpression(ts.factory.createIdentifier("__encode"), undefined, [ts.factory.createIdentifier("input")])))),
                ts.factory.createReturnStatement(ts.factory.createIdentifier("result")),
            ], true)),
        };
    };
    ProtobufValidateEncodeProgrammer.write = (props) => {
        const functor = new FunctionProgrammer(props.modulo.getText());
        const result = ProtobufValidateEncodeProgrammer.decompose({
            ...props,
            functor,
        });
        return FeatureProgrammer.writeDecomposed({
            modulo: props.modulo,
            functor,
            result,
        });
    };
})(ProtobufValidateEncodeProgrammer || (ProtobufValidateEncodeProgrammer = {}));

export { ProtobufValidateEncodeProgrammer };
//# sourceMappingURL=ProtobufValidateEncodeProgrammer.mjs.map
