"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsonAssertStringifyProgrammer = void 0;
const typescript_1 = __importDefault(require("typescript"));
const IdentifierFactory_1 = require("../../factories/IdentifierFactory");
const StatementFactory_1 = require("../../factories/StatementFactory");
const TypeFactory_1 = require("../../factories/TypeFactory");
const AssertProgrammer_1 = require("../AssertProgrammer");
const FeatureProgrammer_1 = require("../FeatureProgrammer");
const FunctionProgrammer_1 = require("../helpers/FunctionProgrammer");
const JsonStringifyProgrammer_1 = require("./JsonStringifyProgrammer");
var JsonAssertStringifyProgrammer;
(function (JsonAssertStringifyProgrammer) {
    JsonAssertStringifyProgrammer.decompose = (props) => {
        const assert = AssertProgrammer_1.AssertProgrammer.decompose(Object.assign(Object.assign({}, props), { context: Object.assign(Object.assign({}, props.context), { options: Object.assign(Object.assign({}, props.context.options), { functional: false, numeric: true }) }), config: {
                equals: false,
                guard: false,
            } }));
        const stringify = JsonStringifyProgrammer_1.JsonStringifyProgrammer.decompose(Object.assign(Object.assign({}, props), { validated: true }));
        return {
            functions: Object.assign(Object.assign({}, assert.functions), stringify.functions),
            statements: [
                ...assert.statements,
                ...stringify.statements,
                StatementFactory_1.StatementFactory.constant({
                    name: "__assert",
                    value: assert.arrow,
                }),
                StatementFactory_1.StatementFactory.constant({
                    name: "__stringify",
                    value: stringify.arrow,
                }),
            ],
            arrow: typescript_1.default.factory.createArrowFunction(undefined, undefined, [
                IdentifierFactory_1.IdentifierFactory.parameter("input", TypeFactory_1.TypeFactory.keyword("any")),
                AssertProgrammer_1.AssertProgrammer.Guardian.parameter({
                    context: props.context,
                    init: props.init,
                }),
            ], stringify.arrow.type, undefined, typescript_1.default.factory.createBlock([
                typescript_1.default.factory.createExpressionStatement(typescript_1.default.factory.createCallExpression(typescript_1.default.factory.createIdentifier("__assert"), undefined, [
                    typescript_1.default.factory.createIdentifier("input"),
                    AssertProgrammer_1.AssertProgrammer.Guardian.identifier(),
                ])),
                typescript_1.default.factory.createReturnStatement(typescript_1.default.factory.createCallExpression(typescript_1.default.factory.createIdentifier("__stringify"), undefined, [typescript_1.default.factory.createIdentifier("input")])),
            ], true)),
        };
    };
    JsonAssertStringifyProgrammer.write = (props) => {
        const functor = new FunctionProgrammer_1.FunctionProgrammer(props.modulo.getText());
        const result = JsonAssertStringifyProgrammer.decompose({
            context: props.context,
            functor,
            type: props.type,
            name: props.name,
            init: props.init,
        });
        return FeatureProgrammer_1.FeatureProgrammer.writeDecomposed({
            modulo: props.modulo,
            functor,
            result,
        });
    };
})(JsonAssertStringifyProgrammer || (exports.JsonAssertStringifyProgrammer = JsonAssertStringifyProgrammer = {}));
//# sourceMappingURL=JsonAssertStringifyProgrammer.js.map