import { MetadataFactory } from "../../factories/MetadataFactory";
import { __IJsonApplication } from "../../schemas/json/__IJsonApplication";
import { IJsDocTagInfo } from "../../schemas/metadata/IJsDocTagInfo";
import { Metadata } from "../../schemas/metadata/Metadata";
import { MetadataProperty } from "../../schemas/metadata/MetadataProperty";
export declare namespace JsonApplicationProgrammer {
    const validate: (metadata: Metadata, explore: MetadataFactory.IExplore) => string[];
    const write: <Version extends "3.0" | "3.1">(props: {
        version: Version;
        metadata: Metadata;
        filter?: (prop: MetadataProperty) => boolean;
    }) => __IJsonApplication<Version>;
    const writeDescription: <Kind extends "summary" | "title">(props: {
        description: string | null;
        jsDocTags: IJsDocTagInfo[];
        kind: Kind;
    }) => Kind extends "summary" ? {
        summary?: string;
        description?: string;
    } : {
        title?: string;
        description?: string;
    };
}
