import ts from 'typescript';
import { metadata_to_pattern } from './metadata_to_pattern.mjs';

/** @internal */
const prune_object_properties = (object) => {
    const input = ts.factory.createIdentifier("input");
    const key = ts.factory.createIdentifier("key");
    const condition = object.properties.map((prop) => {
        const name = prop.key.getSoleLiteral();
        if (name !== null)
            return ts.factory.createStrictEquality(ts.factory.createStringLiteral(name), ts.factory.createIdentifier("key"));
        return ts.factory.createCallExpression(ts.factory.createIdentifier(`RegExp(/${metadata_to_pattern({
            top: true,
            metadata: prop.key,
        })}/).test`), undefined, [key]);
    });
    const statements = [];
    if (condition.length)
        statements.push(ts.factory.createIfStatement(condition.reduce((a, b) => ts.factory.createLogicalOr(a, b)), ts.factory.createContinueStatement()));
    statements.push(ts.factory.createExpressionStatement(ts.factory.createDeleteExpression(ts.factory.createElementAccessExpression(input, key))));
    return ts.factory.createForOfStatement(undefined, ts.factory.createVariableDeclarationList([
        ts.factory.createVariableDeclaration(ts.factory.createIdentifier("key"), undefined, undefined, undefined),
    ], ts.NodeFlags.Const), ts.factory.createCallExpression(ts.factory.createIdentifier("Object.keys"), undefined, [input]), statements.length === 1
        ? statements[0]
        : ts.factory.createBlock(statements, true));
};

export { prune_object_properties };
//# sourceMappingURL=prune_object_properties.mjs.map
