"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.decode_union_object = void 0;
const typescript_1 = __importDefault(require("typescript"));
/** @internal */
const decode_union_object = (props) => typescript_1.default.factory.createCallExpression(typescript_1.default.factory.createArrowFunction(undefined, undefined, [], undefined, undefined, iterate({
    escaper: props.escaper,
    input: props.input,
    unions: props.objects.map((object) => ({
        type: "object",
        is: () => props.success(props.checker({
            input: props.input,
            explore: props.explore,
            object,
        })),
        value: () => props.decoder({
            input: props.input,
            explore: props.explore,
            object,
        }),
    })),
    expected: `(${props.objects.map((t) => t.name).join(" | ")})`,
})), undefined, undefined);
exports.decode_union_object = decode_union_object;
/** @internal */
const iterate = (props) => {
    const branches = [];
    for (const u of props.unions) {
        const condition = u.is();
        if (condition.kind === typescript_1.default.SyntaxKind.TrueKeyword) {
            branches.push({
                condition: null,
                value: u.value(),
            });
            break;
        }
        branches.push({
            condition,
            value: u.value(),
        });
    }
    if (branches.length === 0)
        return typescript_1.default.factory.createBlock([props.escaper(props)], true);
    else if (branches.length === 1 && branches[0].condition === null)
        return branches[0].value;
    const statements = branches.map((b) => b.condition !== null
        ? typescript_1.default.factory.createIfStatement(b.condition, typescript_1.default.factory.createReturnStatement(b.value), undefined)
        : typescript_1.default.factory.createReturnStatement(b.value));
    if (branches.at(-1).condition !== null)
        statements.push(props.escaper(props));
    return typescript_1.default.factory.createBlock(statements, true);
};
//# sourceMappingURL=decode_union_object.js.map