"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.check_union_array_like = void 0;
const typescript_1 = __importDefault(require("typescript"));
const ExpressionFactory_1 = require("../../factories/ExpressionFactory");
const IdentifierFactory_1 = require("../../factories/IdentifierFactory");
const StatementFactory_1 = require("../../factories/StatementFactory");
const TypeFactory_1 = require("../../factories/TypeFactory");
const MetadataArray_1 = require("../../schemas/metadata/MetadataArray");
const MetadataArrayType_1 = require("../../schemas/metadata/MetadataArrayType");
const MetadataTuple_1 = require("../../schemas/metadata/MetadataTuple");
/** @internal */
const check_union_array_like = (props) => {
    // ONLY ONE TYPE
    const targets = props.definitions.map(props.accessor.transform);
    if (targets.length === 1)
        return typescript_1.default.factory.createArrowFunction(undefined, undefined, props.parameters, undefined, undefined, props.config.decoder({
            input: props.accessor.array(props.input),
            definition: targets[0],
            explore: props.explore,
        }));
    const array = typescript_1.default.factory.createIdentifier("array");
    const top = typescript_1.default.factory.createIdentifier("top");
    const statements = [];
    const tupleList = targets.filter((t) => t instanceof MetadataTuple_1.MetadataTuple);
    const arrayList = targets.filter((t) => t instanceof MetadataArray_1.MetadataArray);
    const predicate = (meta) => typescript_1.default.factory.createAsExpression(typescript_1.default.factory.createArrayLiteralExpression([
        typescript_1.default.factory.createArrowFunction(undefined, undefined, [
            IdentifierFactory_1.IdentifierFactory.parameter("top", meta instanceof MetadataArrayType_1.MetadataArrayType
                ? TypeFactory_1.TypeFactory.keyword("any")
                : typescript_1.default.factory.createTypeReferenceNode("any[]")),
        ], TypeFactory_1.TypeFactory.keyword("any"), undefined, props.config.checker({
            input: typescript_1.default.factory.createIdentifier("top"),
            definition: props.accessor.element(meta),
            explore: Object.assign(Object.assign({}, props.explore), { tracable: false, postfix: meta instanceof MetadataArrayType_1.MetadataArrayType ? `"[0]"` : "" }),
            container: array,
        })),
        typescript_1.default.factory.createArrowFunction(undefined, undefined, [
            IdentifierFactory_1.IdentifierFactory.parameter("entire", typescript_1.default.factory.createTypeReferenceNode("any[]")),
        ], TypeFactory_1.TypeFactory.keyword("any"), undefined, props.config.decoder({
            input: typescript_1.default.factory.createIdentifier("entire"),
            definition: meta,
            explore: Object.assign(Object.assign({}, props.explore), { tracable: true }),
        })),
    ], true), typescript_1.default.factory.createTypeReferenceNode("const"));
    const iterate = (props) => typescript_1.default.factory.createForOfStatement(undefined, typescript_1.default.factory.createVariableDeclarationList([typescript_1.default.factory.createVariableDeclaration(props.init)], typescript_1.default.NodeFlags.Const), props.from, props.if);
    if (tupleList.length)
        statements.push(StatementFactory_1.StatementFactory.constant({
            name: "array",
            value: props.accessor.array(props.input),
        }), StatementFactory_1.StatementFactory.constant({
            name: "tuplePredicators",
            value: typescript_1.default.factory.createArrayLiteralExpression(tupleList.map((x) => predicate(x)), true),
        }), iterate({
            init: "pred",
            from: typescript_1.default.factory.createIdentifier("tuplePredicators"),
            if: typescript_1.default.factory.createIfStatement(typescript_1.default.factory.createCallExpression(typescript_1.default.factory.createIdentifier("pred[0]"), undefined, [array]), typescript_1.default.factory.createReturnStatement(typescript_1.default.factory.createCallExpression(typescript_1.default.factory.createIdentifier(`pred[1]`), undefined, [array]))),
        }));
    if (arrayList.length) {
        if (tupleList.length === 0)
            statements.push(StatementFactory_1.StatementFactory.constant({
                name: "array",
                value: props.accessor.array(props.input),
            }));
        statements.push(StatementFactory_1.StatementFactory.constant({
            name: "top",
            value: props.accessor.front(props.input),
        }), typescript_1.default.factory.createIfStatement(typescript_1.default.factory.createStrictEquality(ExpressionFactory_1.ExpressionFactory.number(0), props.accessor.size(props.input)), typescript_1.default.isReturnStatement(props.config.empty)
            ? props.config.empty
            : typescript_1.default.factory.createReturnStatement(props.config.empty)), StatementFactory_1.StatementFactory.constant({
            name: "arrayPredicators",
            value: typescript_1.default.factory.createArrayLiteralExpression(arrayList.map((x) => predicate(x)), true),
        }), StatementFactory_1.StatementFactory.constant({
            name: "passed",
            value: typescript_1.default.factory.createCallExpression(IdentifierFactory_1.IdentifierFactory.access(typescript_1.default.factory.createIdentifier("arrayPredicators"), "filter"), undefined, [
                typescript_1.default.factory.createArrowFunction(undefined, undefined, [IdentifierFactory_1.IdentifierFactory.parameter("pred")], undefined, undefined, typescript_1.default.factory.createCallExpression(typescript_1.default.factory.createIdentifier("pred[0]"), undefined, [top])),
            ]),
        }), typescript_1.default.factory.createIfStatement(typescript_1.default.factory.createStrictEquality(ExpressionFactory_1.ExpressionFactory.number(1), typescript_1.default.factory.createIdentifier("passed.length")), typescript_1.default.factory.createReturnStatement(typescript_1.default.factory.createCallExpression(typescript_1.default.factory.createElementAccessExpression(typescript_1.default.factory.createNonNullExpression(typescript_1.default.factory.createIdentifier("passed[0]")), 1), undefined, [array])), typescript_1.default.factory.createIfStatement(typescript_1.default.factory.createLessThan(ExpressionFactory_1.ExpressionFactory.number(1), typescript_1.default.factory.createIdentifier("passed.length")), iterate({
            init: "pred",
            from: typescript_1.default.factory.createIdentifier("passed"),
            if: typescript_1.default.factory.createIfStatement(typescript_1.default.factory.createCallExpression(IdentifierFactory_1.IdentifierFactory.access(array, "every"), undefined, [
                typescript_1.default.factory.createArrowFunction(undefined, undefined, [
                    IdentifierFactory_1.IdentifierFactory.parameter("value", TypeFactory_1.TypeFactory.keyword("any")),
                ], undefined, undefined, typescript_1.default.factory.createStrictEquality(props.config.success, typescript_1.default.factory.createCallExpression(typescript_1.default.factory.createIdentifier("pred[0]"), undefined, [typescript_1.default.factory.createIdentifier("value")]))),
            ]), typescript_1.default.factory.createReturnStatement(typescript_1.default.factory.createCallExpression(typescript_1.default.factory.createIdentifier(`pred[1]`), undefined, [typescript_1.default.factory.createIdentifier("array")]))),
        }))));
    }
    statements.push(props.config.failure({
        input: props.input,
        expected: `(${targets
            .map((t) => props.accessor.name(t, props.accessor.element(t)))
            .join(" | ")})`,
        explore: props.explore,
    }));
    return typescript_1.default.factory.createArrowFunction(undefined, undefined, props.parameters, undefined, undefined, typescript_1.default.factory.createBlock(statements, true));
};
exports.check_union_array_like = check_union_array_like;
//# sourceMappingURL=check_union_array_like.js.map