"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.check_number = void 0;
const typescript_1 = __importDefault(require("typescript"));
const ExpressionFactory_1 = require("../../factories/ExpressionFactory");
const OptionPredicator_1 = require("../helpers/OptionPredicator");
/** @internal */
const check_number = (props) => {
    const base = typescript_1.default.factory.createStrictEquality(typescript_1.default.factory.createStringLiteral("number"), typescript_1.default.factory.createTypeOfExpression(props.input));
    const addition = props.numeric === true
        ? OptionPredicator_1.OptionPredicator.finite(props.context.options)
            ? typescript_1.default.factory.createCallExpression(typescript_1.default.factory.createIdentifier("Number.isFinite"), undefined, [props.input])
            : OptionPredicator_1.OptionPredicator.numeric(props.context.options)
                ? typescript_1.default.factory.createLogicalNot(typescript_1.default.factory.createCallExpression(typescript_1.default.factory.createIdentifier("Number.isNaN"), undefined, [props.input]))
                : null
        : null;
    const conditions = check_numeric_type_tags({
        context: props.context,
        atomic: props.atomic,
        input: props.input,
        addition,
    });
    return {
        expected: props.atomic.getName(),
        expression: addition !== null && conditions.length === 0
            ? typescript_1.default.factory.createLogicalAnd(base, addition)
            : base,
        conditions,
    };
};
exports.check_number = check_number;
/** @internal */
const check_numeric_type_tags = (props) => props.atomic.tags
    .map((row) => row.filter((tag) => !!tag.validate))
    .filter((row) => !!row.length)
    .map((row) => [
    ...(props.addition === null
        ? []
        : row.some((tag) => tag.kind === "type" &&
            (tag.value === "int32" ||
                tag.value === "uint32" ||
                tag.value === "int64" ||
                tag.value === "uint64" ||
                tag.value === "float")) ||
            row.some((tag) => tag.kind === "multipleOf" && typeof tag.value === "number") ||
            (row.some((tag) => (tag.kind === "minimum" || tag.kind === "exclusiveMinimum") &&
                typeof tag.value === "number") &&
                row.some((tag) => (tag.kind === "maximum" || tag.kind === "exclusiveMaximum") &&
                    typeof tag.value === "number"))
            ? []
            : [
                {
                    expected: "number",
                    expression: props.addition,
                },
            ]),
    ...row.map((tag) => ({
        expected: `number & ${tag.name}`,
        expression: ExpressionFactory_1.ExpressionFactory.transpile({
            transformer: props.context.transformer,
            importer: props.context.importer,
            script: tag.validate,
        })(props.input),
    })),
]);
//# sourceMappingURL=check_number.js.map