import { ExpressionFactory } from '../../factories/ExpressionFactory.mjs';

/** @internal */
const check_array_length = (props) => {
    const conditions = check_array_type_tags(props);
    return {
        expected: props.array.getName(),
        expression: null,
        conditions,
    };
};
/** @internal */
const check_array_type_tags = (props) => props.array.tags
    .map((row) => row.filter((tag) => !!tag.validate))
    .filter((row) => !!row.length)
    .map((row) => row.map((tag) => ({
    expected: `Array<> & ${tag.name}`,
    expression: ExpressionFactory.transpile({
        transformer: props.context.transformer,
        importer: props.context.importer,
        script: tag.validate,
    })(props.input),
})));

export { check_array_length };
//# sourceMappingURL=check_array_length.mjs.map
