"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImportProgrammer = void 0;
const typescript_1 = __importDefault(require("typescript"));
const MapUtil_1 = require("../utils/MapUtil");
class ImportProgrammer {
    constructor(options) {
        var _a;
        this.assets_ = new Map();
        this.options_ = {
            internalPrefix: (_a = options === null || options === void 0 ? void 0 : options.internalPrefix) !== null && _a !== void 0 ? _a : "",
        };
    }
    /* -----------------------------------------------------------
      ENROLLMENTS
    ----------------------------------------------------------- */
    default(props) {
        var _a;
        var _b;
        const asset = this.take(props.file);
        (_a = asset.default) !== null && _a !== void 0 ? _a : (asset.default = props);
        (_b = asset.default).type || (_b.type = props.type);
        return typescript_1.default.factory.createIdentifier(asset.default.name);
    }
    instance(props) {
        var _a;
        const alias = (_a = props.alias) !== null && _a !== void 0 ? _a : props.name;
        const asset = this.take(props.file);
        MapUtil_1.MapUtil.take(asset.instances, alias, () => props);
        return typescript_1.default.factory.createIdentifier(alias);
    }
    namespace(props) {
        var _a;
        const asset = this.take(props.file);
        (_a = asset.namespace) !== null && _a !== void 0 ? _a : (asset.namespace = props);
        return typescript_1.default.factory.createIdentifier(asset.namespace.name);
    }
    type(props) {
        return typescript_1.default.factory.createImportTypeNode(typescript_1.default.factory.createLiteralTypeNode(typescript_1.default.factory.createStringLiteral(props.file)), undefined, typeof props.name === "string"
            ? typescript_1.default.factory.createIdentifier(props.name)
            : props.name, props.arguments);
    }
    /** @internal */
    internal(name) {
        if (name.startsWith("_") === false)
            name = `_${name}`;
        return typescript_1.default.factory.createPropertyAccessExpression(this.namespace({
            file: `typia/lib/internal/${name}.js`,
            name: this.alias(name),
        }), name);
    }
    /** @internal */
    getInternalText(name) {
        if (name.startsWith("_") === false)
            name = `_${name}`;
        const asset = this.take(`typia/lib/internal/${name}.js`);
        if (!(asset === null || asset === void 0 ? void 0 : asset.namespace))
            throw new Error(`Internal asset not found: ${name}`);
        return `${asset.namespace.name}.${name}`;
    }
    /** @internal */
    take(file) {
        return MapUtil_1.MapUtil.take(this.assets_, file, () => ({
            file,
            default: null,
            namespace: null,
            instances: new Map(),
        }));
    }
    alias(name) {
        return `__${this.options_.internalPrefix}${name}`;
    }
    /* -----------------------------------------------------------
      PROGRAM STATEMENTS
    ----------------------------------------------------------- */
    toStatements() {
        const statements = [];
        for (const asset of this.assets_.values()) {
            if (asset.namespace !== null)
                statements.push(typescript_1.default.factory.createImportDeclaration(undefined, typescript_1.default.factory.createImportClause(false, undefined, typescript_1.default.factory.createNamespaceImport(typescript_1.default.factory.createIdentifier(asset.namespace.name))), typescript_1.default.factory.createStringLiteral(asset.file)));
            if (asset.default !== null)
                statements.push(typescript_1.default.factory.createImportDeclaration(undefined, typescript_1.default.factory.createImportClause(asset.default.type, typescript_1.default.factory.createIdentifier(asset.default.name), undefined), typescript_1.default.factory.createStringLiteral(asset.file)));
            if (asset.instances.size > 0)
                statements.push(typescript_1.default.factory.createImportDeclaration(undefined, typescript_1.default.factory.createImportClause(false, undefined, asset.instances.size > 0
                    ? typescript_1.default.factory.createNamedImports([...asset.instances.values()].map((ins) => {
                        var _a;
                        return typescript_1.default.factory.createImportSpecifier(false, ins.alias || ins.alias === ins.name
                            ? typescript_1.default.factory.createIdentifier(ins.name)
                            : undefined, typescript_1.default.factory.createIdentifier((_a = ins.alias) !== null && _a !== void 0 ? _a : ins.name));
                    }))
                    : undefined), typescript_1.default.factory.createStringLiteral(asset.file), undefined));
        }
        return statements;
    }
}
exports.ImportProgrammer = ImportProgrammer;
//# sourceMappingURL=ImportProgrammer.js.map