"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Flex
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PluginVersionsPage = exports.PluginVersionsListInstance = exports.PluginVersionsInstance = exports.PluginVersionsContextImpl = void 0;
const util_1 = require("util");
const Page_1 = __importDefault(require("../../../../base/Page"));
const deserialize = require("../../../../base/deserialize");
const serialize = require("../../../../base/serialize");
const utility_1 = require("../../../../base/utility");
class PluginVersionsContextImpl {
    constructor(_version, pluginSid, sid) {
        this._version = _version;
        if (!(0, utility_1.isValidPathParam)(pluginSid)) {
            throw new Error("Parameter 'pluginSid' is not valid.");
        }
        if (!(0, utility_1.isValidPathParam)(sid)) {
            throw new Error("Parameter 'sid' is not valid.");
        }
        this._solution = { pluginSid, sid };
        this._uri = `/PluginService/Plugins/${pluginSid}/Versions/${sid}`;
    }
    fetch(params, callback) {
        if (params instanceof Function) {
            callback = params;
            params = {};
        }
        else {
            params = params || {};
        }
        let data = {};
        const headers = {};
        headers["Accept"] = "application/json";
        if (params["flexMetadata"] !== undefined)
            headers["Flex-Metadata"] = params["flexMetadata"];
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.fetch({
            uri: instance._uri,
            method: "get",
            params: data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new PluginVersionsInstance(operationVersion, payload, instance._solution.pluginSid, instance._solution.sid));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return this._solution;
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.PluginVersionsContextImpl = PluginVersionsContextImpl;
class PluginVersionsInstance {
    constructor(_version, payload, pluginSid, sid) {
        this._version = _version;
        this.sid = payload.sid;
        this.pluginSid = payload.plugin_sid;
        this.accountSid = payload.account_sid;
        this.version = payload.version;
        this.pluginUrl = payload.plugin_url;
        this.changelog = payload.changelog;
        this._private = payload.private;
        this.archived = payload.archived;
        this.validated = payload.validated;
        this.dateCreated = deserialize.iso8601DateTime(payload.date_created);
        this.url = payload.url;
        this._solution = { pluginSid, sid: sid || this.sid };
    }
    get _proxy() {
        this._context =
            this._context ||
                new PluginVersionsContextImpl(this._version, this._solution.pluginSid, this._solution.sid);
        return this._context;
    }
    fetch(params, callback) {
        return this._proxy.fetch(params, callback);
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            sid: this.sid,
            pluginSid: this.pluginSid,
            accountSid: this.accountSid,
            version: this.version,
            pluginUrl: this.pluginUrl,
            changelog: this.changelog,
            _private: this._private,
            archived: this.archived,
            validated: this.validated,
            dateCreated: this.dateCreated,
            url: this.url,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.PluginVersionsInstance = PluginVersionsInstance;
function PluginVersionsListInstance(version, pluginSid) {
    if (!(0, utility_1.isValidPathParam)(pluginSid)) {
        throw new Error("Parameter 'pluginSid' is not valid.");
    }
    const instance = ((sid) => instance.get(sid));
    instance.get = function get(sid) {
        return new PluginVersionsContextImpl(version, pluginSid, sid);
    };
    instance._version = version;
    instance._solution = { pluginSid };
    instance._uri = `/PluginService/Plugins/${pluginSid}/Versions`;
    instance.create = function create(params, callback) {
        if (params === null || params === undefined) {
            throw new Error('Required parameter "params" missing.');
        }
        if (params["version"] === null || params["version"] === undefined) {
            throw new Error("Required parameter \"params['version']\" missing.");
        }
        if (params["pluginUrl"] === null || params["pluginUrl"] === undefined) {
            throw new Error("Required parameter \"params['pluginUrl']\" missing.");
        }
        let data = {};
        data["Version"] = params["version"];
        data["PluginUrl"] = params["pluginUrl"];
        if (params["changelog"] !== undefined)
            data["Changelog"] = params["changelog"];
        if (params["private"] !== undefined)
            data["Private"] = serialize.bool(params["private"]);
        if (params["cliVersion"] !== undefined)
            data["CliVersion"] = params["cliVersion"];
        if (params["validateStatus"] !== undefined)
            data["ValidateStatus"] = params["validateStatus"];
        const headers = {};
        headers["Content-Type"] = "application/x-www-form-urlencoded";
        headers["Accept"] = "application/json";
        if (params["flexMetadata"] !== undefined)
            headers["Flex-Metadata"] = params["flexMetadata"];
        let operationVersion = version, operationPromise = operationVersion.create({
            uri: instance._uri,
            method: "post",
            data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new PluginVersionsInstance(operationVersion, payload, instance._solution.pluginSid));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    };
    instance.page = function page(params, callback) {
        if (params instanceof Function) {
            callback = params;
            params = {};
        }
        else {
            params = params || {};
        }
        let data = {};
        if (params["pageSize"] !== undefined)
            data["PageSize"] = params["pageSize"];
        if (params.pageNumber !== undefined)
            data["Page"] = params.pageNumber;
        if (params.pageToken !== undefined)
            data["PageToken"] = params.pageToken;
        const headers = {};
        headers["Accept"] = "application/json";
        if (params["flexMetadata"] !== undefined)
            headers["Flex-Metadata"] = params["flexMetadata"];
        let operationVersion = version, operationPromise = operationVersion.page({
            uri: instance._uri,
            method: "get",
            params: data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new PluginVersionsPage(operationVersion, payload, instance._solution));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    };
    instance.each = instance._version.each;
    instance.list = instance._version.list;
    instance.getPage = function getPage(targetUrl, callback) {
        const operationPromise = instance._version._domain.twilio.request({
            method: "get",
            uri: targetUrl,
        });
        let pagePromise = operationPromise.then((payload) => new PluginVersionsPage(instance._version, payload, instance._solution));
        pagePromise = instance._version.setPromiseCallback(pagePromise, callback);
        return pagePromise;
    };
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
exports.PluginVersionsListInstance = PluginVersionsListInstance;
class PluginVersionsPage extends Page_1.default {
    /**
     * Initialize the PluginVersionsPage
     *
     * @param version - Version of the resource
     * @param response - Response from the API
     * @param solution - Path solution
     */
    constructor(version, response, solution) {
        super(version, response, solution);
    }
    /**
     * Build an instance of PluginVersionsInstance
     *
     * @param payload - Payload response from the API
     */
    getInstance(payload) {
        return new PluginVersionsInstance(this._version, payload, this._solution.pluginSid);
    }
    [util_1.inspect.custom](depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.PluginVersionsPage = PluginVersionsPage;
