(function (root, factory) {
  if (typeof define === "function" && define.amd) {
    // AMD. Register as an anonymous module.
    define([], factory);
  } else if (typeof module === "object" && module.exports) {
    // Node. Does not work with strict CommonJS, but
    // only CommonJS-like environments that support module.exports,
    // like Node.
    module.exports = factory();
  } else {
    // Browser globals (root is window)
    root.hyphenationPatternsBg = factory();
  }
})(this, function () {
  var patterns = [],
    hyphenation = [];

  // copyright: Copyright (C) 2000, 2004, 2017 Anton Zinoviev
  // title: Hyphenation patterns for Bulgarian
  // version: 21 October 2017
  // language:
  //     name: Bulgarian
  //     tag: bg
  // notice: >
  //     This file is part of the hyph-utf8 package.
  //     See http://www.hyphenation.org/tex for more information.
  // authors:
  //     -
  //         name: Anton Zinoviev
  //         contact: anton:lml.bas.bg
  // licence:
  //     text: >
  //         This software may be used, modified, copied, distributed, and sold,
  //         both in source and binary form provided that the above copyright
  //         notice and these terms are retained. The name of the author may not
  //         be used to endorse or promote products derived from this software
  //         without prior permission.  THIS SOFTWARE IS PROVIDES "AS IS" AND
  //         ANY EXPRESS OR IMPLIED WARRANTIES ARE DISCLAIMED.  IN NO EVENT
  //         SHALL THE AUTHOR BE LIABLE FOR ANY DAMAGES ARISING IN ANY WAY OUT
  //         OF THE USE OF THIS SOFTWARE.
  // hyphenmins:
  //     typesetting:
  //         left: 2
  //         right: 2
  // changes: See below
  // ==========================================
  // Copyright (C) 2000,2004,2017 by Anton Zinoviev <anton@lml.bas.bg>
  //
  // This software may be used, modified, copied, distributed, and sold,
  // both in source and binary form provided that the above copyright
  // notice and these terms are retained. The name of the author may not
  // be used to endorse or promote products derived from this software
  // without prior permission.  THIS SOFTWARE IS PROVIDES "AS IS" AND
  // ANY EXPRESS OR IMPLIED WARRANTIES ARE DISCLAIMED.  IN NO EVENT
  // SHALL THE AUTHOR BE LIABLE FOR ANY DAMAGES ARISING IN ANY WAY OUT
  // OF THE USE OF THIS SOFTWARE.
  //
  // Bulgarian hyphenation patterns
  //
  // Generated by ./hyph-bg.sh --safe-morphology --standalone-tex
  //
  // Both left and right hyphenmins should be set to 2.
  //
  // // Automated Bulgarian Hyphenation
  // // Anton Zinoviev
  // // 21 October 2017
  //
  // Principles of the Bulgarian hyphenation
  // =======================================
  //
  // One specificity of the Bulgarian language is that the average length
  // of the words is greater than in English.  When typesetting a Bulgarian
  // text, hyphenation is more important than when typesetting an English
  // text.  Knuth's algorithm for line-breaking is such that in most
  // English paragraphs no hyphenation will be used.  With a Bulgarian
  // text, however, even the Knuth's algorithm will use hyphenation in most
  // paragraphs.  Hyphenation becomes an absolute necessity if we want to
  // obtain nice, justified paragraphs when using a software with dumb
  // line-breaking algorithm, such as LibreOffice.
  //
  // According to Decree 936 of the Council of Ministers promulgated on 27
  // November 1950, the Institute for Bulgarian Language at the Bulgarian
  // Academy of Sciences is authorised to publish the rules of the
  // orthography of the Bulgarian language (within certain limits).
  //
  // Hyphenation rules between 1945 and 1983
  // ---------------------------------------
  //
  // Between 1945 and 1983 Bulgarian used syllable hyphenation with two
  // morphological exceptions: hyphenation is preferred between a prefix
  // and a stem and at the boundary of compound words.  The following were
  // the rules governing the hyphenation:
  //
  // 1. One letter does not stay alone.  Words of one syllable can not be
  //    hyphenated.
  // 2. No hyphenation before or after ь.
  // 3. In a sequence of vowels at least one vowel stays before the
  //    hyphen.
  // 4. A single consonant between two vowels links with the second vowel.
  //    For example по-ле /po-le/, ра-бо-та /ra-bo-ta/.
  // 5. In a sequence of consonants between two vowels, at least one
  //    consonant stays with the second vowel.  For example те-сто /te-sto/
  //    or тес-то /tes-to/.[^b]
  // 6. In a sequence of consonants between two vowels, if the first
  //    consonant is sonorant (й /y/, л /l/, м /m/, н /n/, р /r/), then it
  //    stays with the first vowel.  For example гер-дан /ger-dan/, сен-ки
  //    /sen-ki/.
  // 7. The hyphenation separates two successive equal consonants. For
  //    example времен-но /vremen-no/, пролет-та /prolet-ta/.
  // 8. When the letters дж /dzh/ and дз /dz/ denote a single consonant,
  //    then they are not separated.  For example боя-джия /boya-dzhiya/
  //    but not бояд-жия /boyad-zhiya/.  When these letters denote two
  //    consonants, then the normal rules apply: над-живявам
  //    /nad-zhivyavam/.
  // 9. Word prefixes may not be broken.  Compound words are hyphenated
  //    either at the boundary of the components or the hyphenation rules
  //    are applied to each of the components separately.  For example:
  //    пред-упреждавам /pred-uprezhdavam/ (not пре-дупреждавам
  //    /pre-duprezhdavam/), пред-известие /pred-izvestie/ (not
  //    пре-дизвестие /pre-dizvestie/), за-движвам /za-dvizhvam/ (not
  //    зад-вижвам /zad-vizhvam/), авто-клуб /avto-klub/ (not авток-луб
  //    /avtok-lub/), вакуум-апарат /vakuum-aparat/ (not вакуу-мапарат
  //    /vakuu-maparat/).
  //
  // In some rare cases the proper application of rule 9 depends on the
  // semantics of the word.  For example пре-дреша /pre-dresha/ 'change
  // clothes' but пред-реша /pred-resha/ 'predetermine' or прес-пите
  // /pres-pite/ 'the snow-drifts' but пре-спите /pre-spite/ 'sleep for a
  // while/overnight'.
  //
  // [^b]: In several publications this rule is formulated with the
  //     additional restriction that the sequence of consonants begins with
  //     an obstruent.  I believe this restriction is unintentional.  It
  //     makes no sense to forbid a hyphenation of the form AB-A but to
  //     permit ABB-A (A denotes a vowel and B – a consonant).
  //
  // Hyphenation rules between 1983 and 2012
  // ---------------------------------------
  //
  // The Orthographic dictionary published by the Institute for Bulgarian
  // language in 1983 introduced new hyphenation rules.  The complexity of
  // the previous rules was the main reason for the change.  The new rules
  // aimed at two objectives: simplicity and unambiguity.
  //
  // The new rules are:
  //
  // 1. A consonant between two vowels links with the second vowel.  For
  //    example ви-со-чи-на /vi-so-chi-na/.
  // 2. In a sequence of two or more consonants between two vowels, at
  //    least one consonant stays with first vowel and at least one with
  //    the second vowel.  For example сес-тра /ses-tra/ and сест-ра
  //    /sest-ra/.
  // 3. Two equal consonants are separated.  For example плен-ник
  //    /plen-nik/.
  // 4. In a sequence of two or more vowels, the first vowel stays before
  //    the hyphen.  For example пре-одолея /pre-odoleya/ and прео-долея
  //    /preo-doleya/.
  // 5. In a sequence of three or more vowels, the last vowel stays after
  //    the hyphen.  For example мао-изъм /mao-izam/ but not маои-зъм
  //    /maoi-zam/.
  // 6. The letter й /y/ between a vowel and a consonant stays with the
  //    vowel.  For example май-ка /may-ka/.
  // 7. When a sequence of two or more consonants follows й /y/ then at
  //    least one consonant links with й /y/.  For example айс-берг
  //    /ays-berg/ (not ай-сберг /ay-sberg/).
  // 8. The letter й /y/ between two vowels links with the second vowel.
  //    For example ма-йор /ma-yor/.
  // 9. No hyphenation before or after ь.
  // 10. When the letters дж /dzh/ denote a single consonant, then they are
  //     not separated.  For example су-джук /su-dzhuk/ (not суд-жук
  //     /sud-zhuk/) but над-живея /nad-zhiveya/.
  // 11. There must be at least one vowel before and after the hyphen.
  // 12. One letter does not stay alone.
  //
  // The total disregard of the morphology by these rules leads to some
  // strange results.  For example пре-дизвестие /pre-dizvestie/ is
  // permitted and пред-известие /pred-izvestie/ is forbidden, зад-вижвам
  // /zad-vizhvam/ is permitted and за-движвам /za-dvizhvam/ is forbidden,
  // авток-луб /avtok-lub/ is permitted and авто-клуб /avto-klub/ is
  // forbidden, вакуу-мапарат /vakuu-maparat/ is permitted and
  // вакуум-апарат /vakuum-aparat/ is forbidden.  Because of this, the new
  // rules were not universally accepted.  The old rules are still
  // mentioned in various places in Internet, they are included even in
  // some grammar books published by the publishing houses of the Ministry
  // of Education and of Sofia University.  The software developers,
  // however, soon came into love with the new hyphenation rules.
  //
  // Hyphenation rules after 2012
  // ----------------------------
  //
  // In 2012 new rules came into force.  There are two differences with
  // respect to the previous rules:
  //
  // 1. Rule 5 of the previous rules is revoked.  For example маои-зъм
  //    /maoi-zam/ becomes a valid hyphenation.
  // 2. The new rules permit morphologically based hyphenation (however it
  //    is not obligatory).  For example пред-известие /pred-izvestie/,
  //    за-движвам /za-dvizhvam/, авто-клуб /avto-klub/, вакуум-апарат
  //    /vakuum-aparat/ are valid hyphenations.
  //
  // Good hyphenation is a complex matter and it seems the linguists at the
  // Institute for Bulgarian Language have recognised this.  They no longer
  // attempt to provide universal rules about everything.  Instead, they
  // provide some very permissible rules while the good application of
  // these rules is leaved to the discretion and the experience of the
  // printers and the developers of hyphenation software.
  //
  // It makes sense to use at least two different sets of hyphenation rules
  // for Bulgarian.  In most cases a more restrictive version should be
  // used, one which attempts to eliminate the controversial cases of
  // hyphenation.  When typesetting a Bulgarian text in a narrow newspaper
  // column, however, it will be appropriate to use more liberal
  // hyphenation rules.  It should be noted that one of the reasons for the
  // hyphenation reform in 1983 was the desire to fix the chaotic
  // hyphenation in the Bulgarian newspapers at that time.
  //
  // Computer implementations
  // ========================
  //
  // Mathematical analysis of the Bulgarian hyphenation
  // --------------------------------------------------
  //
  // The earliest mathematical analysis of the Bulgarian hyphenation rules
  // belongs to Veska Noncheva.[^1] In 1988 she proposed a mathematical
  // formalisation of the hyphenation rules in a table with 22 rows.[^2]
  //
  // [^1]: <http://www.researchgate.net/profile/Veska_Noncheva>
  //
  // [^2]: Нончева В. Алгоритъм за автоматично пренасяне на думи в
  //     българския език. Математика и математическо
  //     образование. Сб. доклади на 17. ПК на СМБ. С., БАН, 1988, 479-482.
  //
  // In the same year Eugene Belogay[^3] proposed an alternative
  // formalisation with only 9 rules.[^4] Belogay proved that his rules are
  // consistent and that they form a minimal set.  The rules of Belogay
  // have negative character – every hyphenation which is not forbidden by
  // a rule is possible hyphenation.
  //
  // [^3]: <http://www.linkedin.com/in/belogay>
  //
  // [^4]: Белогай Е. Алгоритъм за автоматично пренасяне на думи. Компютър
  //     за вас (1988) 3, 12-14.
  //
  // The following are the first 7 rules, as formulated by Belogay:
  //
  // 1. Б-А
  // 2. А-ББ
  // 3. Б-ТТ, ТТ-Б
  // 4. ААА-Б
  // 5. й-ББ
  // 6. Б-ь
  // 7. д-ж
  //
  // Here А denotes an arbitrary vowel letter, Б denotes an arbitrary
  // consonant letter (including ь and й), ТТ denotes a sequence of two
  // equal consonant letters and the letters й, ь, д and ж denote
  // themselves.  For example the rule "Б-А" says that we are not permitted
  // to separate a consonant letter from immediately following vowel
  // letter.
  //
  // The eighth rule of Belogay says that hyphenation is forbidden before
  // the first and after the last vowel letter.  The ninth rule of Belogay
  // says that hyphenation is forbidden immediately after the first or
  // immediately before the last letter of the word.
  //
  // Notice that is is very easy to translate the rules of Belogay in the
  // form, required for the hyphenation algorithm of Knuth and Liang used
  // in TeX.[^a] Let us remind that this algorithm matches the word with a
  // set of string patterns in which the odd numbers say hyphenation is
  // permitted in this position and even numbers say the hyphenation is
  // forbidden.  When two patterns give conflicting numbers for the same
  // position, then the greater number wins.
  //
  // First, since the rules of Belogay are negative (they say where
  // hyphenation is forbidden, not where it is permitted), we have to
  // permit the hyphenation everywhere:
  //
  // 1. А1
  // 2. Б1
  //
  // Then, the first seven rules of Belogay obtain the form:
  //
  // 1. Б2А
  // 2. А2ББ
  // 3. Б2ТТ ТТ2Б
  // 4. ААА2Б
  // 5. й2ББ
  // 6. Б2ь
  // 7. д2ж
  //
  // Since no Bulgarian word starts with more that four consonants and no
  // Bulgarian word ends with more than three consonants, the eighth rule
  // of Belogay can be translated in the following way:
  //
  // 1. .Б2
  // 2. .ББ2
  // 3. .БББ2
  // 4. 2Б.
  // 5. 2ББ.
  //
  // The ninth rule of Belogay means that left and right hyphen mins should
  // be set to 2.
  //
  // The work of Eugene Belogay was not limited to merely a mathematical
  // analysis of the Bulgarian hyphenation rules.  In his paper he
  // published a short algorithm in Pascal which implements these rules.
  // It didn't take long for this algorithm to be used in various text
  // processing software.  The algorithm of Belogay was famous for many
  // years.  Even as late as 1997 in one book about TeX, the author didn't
  // care to give any explanations but simply wrote about "the algorithm of
  // Belogay" as something well known to the reader.[^5]
  //
  // [^a]: Liang, Franklin Mark. Word Hy-phen-a-tion by
  //     Com-put-er (Doctoral Dissertation). Stanford University, 1983
  //
  // [^5]: Василев В. Ултимативният ТеХ.  Удоволствието да правим
  //     предпечатна подготовка сами. София, Интела, 1997, 36
  //
  // Bulgarian hyphenation in TeX
  // ----------------------------
  //
  // One unfortunate design decision of Knuth was that the hyphenation
  // algorithm of TeX applied the hyphenation patterns not to the input
  // character codes but to the internal codes of the glyphs in the font.
  // This created a problem for the Cyrillic languages because in TeX the
  // Cyrillic fonts did not have standardised encoding.  Perhaps this is
  // one of the reasons why the earliest implementations of the Bulgarian
  // hyphenation in TeX did not rely on the internal hyphenation algorithm
  // of TeX.  Instead, external tools were used to insert soft hyphens in
  // all Bulgarian words.  For example such a tool would replace the word
  // сричкопренасяне /srichkoprenasyane/ with
  // срич\\-коп\\-ре\\-на\\-ся\\-не /srich\\-kop\\-re\\-na\\-sya\\-ne/.
  // The saying "To every disadvantage there is a corresponding advantage"
  // is true – since Cyrillic and Latin letters use different character
  // codes, an external tool could easily insert soft hyphens in all
  // Bulgarian words while leaving the TeX commands intact.
  //
  // The earliest known attempt to use the hyphenation algorithm of TeX for
  // Bulgarian was made by Ognyan Tonev in 1990.[^6] He described his work
  // as "a not very good translation of the rules.  I work in this
  // direction.  But I don't have a 100// working complect of patterns.  So,
  // the copy I send to you[^7] is only a beta-version."  The hyphenation
  // patterns of Tonev don't work correctly and it seems he never completed
  // his work.
  //
  // [^6]: The author of this text was unable to find current information
  //     about Ognyan Tonev in Internet.  Apparently in 1990 he worked in
  //     the Center of Informatics and Computer Technology of the Bulgarian
  //     Academy of Sciences.
  //
  // [^7]: To Yannis Haralambous,
  //     <http://perso.telecom-bretagne.eu/yannisharalambous>
  //
  // The first usable Bulgarian hyphenation patterns for TeX were developed
  // by Georgi Boshnakov[^8] in 1994.  In order to solve the encoding
  // problem, Boshnakov had developed TeX fonts supporting the MIK encoding
  // (the prevalent encoding at that time in Bulgaria).  This allowed him
  // to introduce a fully working implementation only a few months after
  // LaTeX2e became the official LaTeX version.  Later Boshnakov modified
  // his work with the Babel system.  The hyphenation patterns of Boshnakov
  // did their job well enough, so that for almost quarter a century after
  // their initial creation, they remained the only Bulgarian hyphenation
  // patterns in the standard distributions of TeX and CTAN.
  //
  // [^8]: <http://www.maths.manchester.ac.uk/~gb/>
  //
  // There are some similarities between the patterns of Boshnakov and the
  // patterns of Belogay.  The following are the main differences.
  //
  // First, Boshnakov used an ingenious and more compact implementation of
  // the second and the third rule.  Instead of {А2ББ, Б2ТТ, ТТ2Б}, or
  // 8×22×22+22×22+22×22=4840 patterns in total, Boshnakov has patterns of
  // the form 2Б3Б2 and 4Т3Т4, or only 22×22=484 in total, with the same
  // effect.
  //
  // The second main difference between the patterns of Boshnakov and the
  // patterns of Belogay concerns the letter combination дж /dzh/.  In
  // Bulgarian this letter combination can denote either a single
  // consonant, or a sequence of two consonants and the hyphenation rules
  // change respectively.  Unfortunately, it is impossible to know the
  // meaning of дж /dzh/ without a vocabulary.  The solution of Belogay was
  // a cautious one – his rules do the hyphenation in a way which will be
  // correct regardless of whether дж /dzh/ is a single consonant or a
  // sequence of two consonant.  On the other hand, the approach of
  // Boshnakov is a bold one – since дж /dzh/ is more often a single
  // consonant, his rules assume that it is always a single consonant.  The
  // number of the cases when this decision leads to bad hyphenations is
  // insignificant in comparison with the cases in which we obtain improved
  // hyphenation.
  //
  // The third main difference between the patterns of Boshnakov and the
  // patterns of Belogay concerns the eighth rule – its implementation in
  // the rules of Boshnakov is rather limited which leads to wrong
  // hyphenations like бри-дж /bri-dzh/.  A full implementation of this
  // rule would require 11660 patterns in total and this would be too much
  // for the computers in 1994.
  //
  // Later developments
  // ------------------
  //
  // In 1995 Atanas Topalov defended a Masters thesis in the Faculty of
  // Mathematics and Informatics at Sofia University titled "Algorithms and
  // software about text processing".[^9] One of the main topics in his
  // thesis was the Bulgarian hyphenation.  Topalov criticised vehemently
  // the official hyphenation rules and their total disregard of the
  // morphology.  He wrote:
  //
  // > If we look at the history of the problems of the hyphenation, we
  // > will discover something very strange.  Instead of the expected
  // > involvement with the depths and aspiration for more admissible and
  // > satisfactory style, we can find a growing tendency for
  // > simplification.  One unpleasant discovery is that the development of
  // > the hyphenation software stays firmly on the principle "let us do
  // > the easiest thing".  The earliest works which have been studied are
  // > from 1978.  It turned out that they present the best approach
  // > concerning the automated hyphenation.  The authors have chosen the
  // > most difficult but the most correct (from literary point of view)
  // > method for hyphenation, namely the morphological approach.
  //
  // Topalov proposed his own hyphenation algorithm.  The hyphenation it
  // generated was smooth and easy to read.  One obvious defect of the
  // algorithm of Topalov was that it contradicted the official hyphenation
  // rules at that time.  One can argue, however, that his algorithm is
  // compatible with the current hyphenation rules.
  //
  // [^9]: The thesis of Atanas Topalov can be accessed at the author's
  //     website <http://www.mind-print.com>
  //
  // In 1999 Svetla Koeva[^10] wrote a paper about the automated Bulgarian
  // hyphenation.[^11] At that time she was a junior member of the
  // Department of Computational Linguistics at the Institute for Bulgarian
  // Language but now she is a director of the whole institute.  The paper
  // of Koeva contains a list of hyphenation patterns which can be used as
  // a basis of automated hyphenation.  In 2004 with the help of Stoyan
  // Mihov[^12] the rules of Koeva were formalised with regular relations
  // and rewriting rules.  They were implemented in a software product
  // named ItaEst which provided Bulgarian hyphenation and grammar checking
  // for various software products of Microsoft and Apple.
  //
  // [^10]: <http://dcl.bas.bg/svetla_koeva/>
  //
  // [^11]: Коева, Светла. Правила за пренасяне на части от думите на нов
  //     ред. Български език. 1999/2000, 1, 84-86
  //
  // [^12]: <http://lml.bas.bg/~stoyan/>
  //
  // The main differences between the hyphenation of Koeva and the official
  // hyphenation rules effective after 2012 is that the separation of a
  // long sequence of consonants between two vowels is done according to
  // the rules valid before 1983.  For example се-стра /se-stra/ and
  // ай-сберг /ay-sberg/ are permitted.  The main difference between the
  // hyphenation of Koeva and the official hyphenation rules effective
  // before 1983 is that the rules of Koeva disregard the morphology of the
  // words.  The following rule of Koeva is specific: in a sequence of two
  // sonorant consonants between two vowels, we are permitted to separate
  // the first vowel from the first consonant, for example материа-лна
  // /materia-lna/.
  //
  // In 2000 Anton Zinoviev[^13] created new hyphenation patterns for TeX.
  // He didn't know about the previous work of Boshnakov and he didn't
  // bother to make his work available in the various TeX distributions and
  // CTAN.  His work was used mostly by the local Linux enthusiasts and the
  // colleagues of Zinoviev.  In 2001 Radostin Radnev[^14] created a free
  // grammar dictionary of Bulgarian[^15] where he used the hyphenation
  // patterns of Zinoviev.  From there the work of Zinoviev propagated to
  // OpenOffice, LibreOffice and various online dictionaries, including
  // <http://bg.wiktionary.org> and <http://rechnik.chitanka.info>.
  //
  // [^13]: The author of this text.
  //
  // [^14]: <http://bg.linkedin.com/in/radostinradnev>
  //
  // [^15]: <http://bgoffice.sourceforge.net/>
  //
  // The following are the main differences between the hyphenation of
  // Zinoviev and the hyphenation of Boshnakov.
  //
  // First, the eighth rule of Belogay is fully implemented.
  //
  // Second, the rules of Zinoviev try to detect when the letters дж /dzh/
  // (and дз /dz/) denote a single consonant and when they denote a
  // sequence of two consonants.  By default, however, Zinoviev (like
  // Boshnakov) assumes that дж /dzh/ is a single consonant and hyphenates
  // accordingly.
  //
  // Third, the rules of Zinoviev disable some cases of unpleasant
  // hyphenations:
  //
  // 1. In a consonant sequence like тст /tst/, the two equal consonants т
  //    /t/ are separated.  For example братст-во /bratst-vo/ is forbidden
  //    while братс-тво /brats-tvo/ and брат-ство /brat-stvo/ are
  //    permitted.
  // 2. The hyphenation is forbidden after a sonorant consonant following
  //    an obstruent consonant.  For example отм-ра /otm-ra/ is forbidden
  //    and от-мра /ot-mra/ is permitted.
  // 3. The hyphenation separates two consecutive kindred voiced/voiceless
  //    consonants.  For example субп-родукт /subp-roduct/ is forbidden and
  //    суб-продукт /sub-product/ is permitted.
  //
  // At the start of his work on the Bulgarian hyphenation, Zinoviev had
  // the opportunity to discuss the hyphenation with Svetla Koeva.  He
  // remembers that some cases of unpleasant hyphenation were suggested to
  // him by Koeva.  Unfortunately, he hasn't taken notes so now he doesn't
  // know which cases of unpleasant hyphenation have been suggested to him
  // by Koeva and which are his own findings.
  //
  // The present work
  // ================
  //
  // Motivation
  // ----------
  //
  // The present work was carried out on the initiative of the leader of
  // the Bulgarian localisation team of Mozilla, who contacted Zinoviev,
  // Boshnakov and the maintainers of the TeX hyphenation patterns.[^17]
  // This work pursues the following main objectives:
  //
  // 1. to update the hyphenation patterns in accordance with the current
  //    hyphenation rules;
  // 2. to generate the hyphenation patterns by a publicly available
  //    script;
  // 3. to make the hyphenation patterns customisable;
  // 4. to provide documentation for the future developers.
  //
  // [^16]: <http://mozillians.org/en-US/u/stoyan/>
  //
  // [^17]: <http://hyphenation.org>
  //
  // The current official hyphenating rules for Bulgarian are rather
  // liberal.  Very often, in a long sequence of consonants we are
  // permitted to split the word at any position, for example аген-т-с-т-во
  // /agen-t-s-t-vo/.  This is prone to many unusual and unexpected results
  // that interrupt the attention of the reader or deceive his expectations
  // during the movement of his eyes to the next line.  On the other hand,
  // in order to produce nice justified paragraphs there is no need for so
  // many hyphenation possibilities.  It would be sufficient even if only
  // one possible separation between any two syllables was permitted.
  //
  // Therefore, it makes sense to use a more restrictive version of the
  // Bulgarian hyphenation, one which eliminates the controversial cases of
  // hyphenation.  Only when typesetting a Bulgarian text in a very narrow
  // newspaper column it will be appropriate to use a more liberal version.
  // It should be noted that some specialised English dictionaries also
  // separate the word-division positions into two categories – preferred
  // positions and less recommended positions.
  //
  // There are two methods to determine the optimal division within a
  // sequence of consonants between two vowels:
  //
  // * we can hyphenate according to the syllables in the word or
  // * we can hyphenate morphologically.
  //
  // Hyphenation according to the syllables in the word
  // --------------------------------------------------
  //
  // Let us look at the properties of the Bulgarian syllables.  All
  // syllables have the following structure:
  //
  // > onset - nucleus - code
  //
  // The nucleus in Bulgarian is always a vowel.  Both the onset and the
  // code are (possibly empty) sequences of consonants.
  //
  // The Bulgarian syllables adhere to the Sonority Sequencing Principle.
  // According to this principle, the consonants within the onset have
  // raising sonority and the consonants within the code have decreasing
  // sonority.
  //
  // Several grammar books agree that the following sonority scale is valid
  // for Bulgarian:
  //
  // > voiceless obtrusive < voiced obtrusive < sonorant consonant < vowel
  //
  // According to the investigations of the author, the only exception to
  // this law is due to the letter в /v/ which is a voiced obtrusive but it
  // can be used also as a voiceless obtrusive.  This exception is due to a
  // spelling particularity of the Bulgarian language.  Whenever the letter
  // в /v/ seemingly violates the Sonority Sequencing Principle, in the
  // spoken language this letter is read as ф /f/, that is as a voiceless
  // obtrusive (for example the word отвсякъде /otvsyakade/ is read as
  // отфсякъде /otfsyakade/).[^18]
  //
  // [^18]: No Primitive Slavonic word contains the phoneme ф /f/.
  // Therefore, we can safely assume that in the Primitive Slavonic
  // language the consonant ф /f/ was a positional variant of the consonant
  // в /v/.
  //
  // The author has found that the sonorant consonants in Bulgarian have
  // their own sonority scale:
  //
  // > м /m/ < н /n/ < л /l/ < р /r/ < й /y/
  //
  // Only a few words such as жанр /zhanr/ and химн /himn/ violate this
  // scale.  Such words are always loan-words and their pronunciation is
  // somewhat problematic for the native Bulgarian speakers.
  //
  // In addition to the Sonority Sequencing Principle, the consonant
  // clusters within the Bulgarian syllable adhere to the following
  // additional principles:
  //
  // 1. Both in the onset and in the code, the labial and dorsal plosives
  //    precede the coronal plosives and affricates.
  // 2. If the onset or the code contains two plosives or affricates, then
  //    there are no fricatives between them.  Few words with the Latin
  //    root 'text' are exceptions: контекст /kontekst/.
  // 3. If the onset or the code contains two fricatives other than в /v/,
  //    then there are no plosives or affricates between them.
  // 4. If the onset or the code contains two plosives or affricates, then
  //    they both have equal sonority (both are voiced, or both are
  //    voiceless).
  // 5. If the onset or the code contains two fricatives other than в /v/,
  //    then they both have equal sonority (both are voiced, or both are
  //    voiceless).
  // 6. Neither the onset, nor the code may contain two labial plosives, or
  //    two coronal plosives or affricates or two dorsal plosives.
  // 7. Neither the onset, nor the code may contain two equal consonants
  //    with the exception of в /v/ (for example втвърди /vtvardi/).[^19]
  //
  // [^19]: Actually, the letter в /v/ is not a real exception because in
  // all such cases this letter denotes two different consonants – в /v/
  // and ф /f/.  Only in the Russian loan-word взвод /vzvod/ the two
  // letters в /v/ denote a repeating consonant в /v/.
  //
  // From all these properties of the Bulgarian syllable we can deduce the
  // following hyphenation rules:
  //
  // 1. In a sequence МК where М is a consonant with higher sonority than
  //    K, we are not permitted to hyphenate before М.  Exception: when М
  //    is в /v/ and К is a voiceless consonant.
  // 2. In a sequence КМ where М is a consonant with higher sonority than
  //    K, we are not permitted to hyphenate after М.
  // 3. In a sequence KBT where K and T are plosives or affricates and B is
  //    fricative, we separate K from T.
  // 4. In a sequence CKB where K is a plosive or affricate and C and B are
  //    fricatives other than в /v/, we separate C from B.
  // 5. If in a consonant sequence a coronal plosive or affricate Т is
  //    followed by a labial or dorsal plosive К, then we separate Т from К.
  // 6. If a consonant sequence contains two plosives or affricates, one
  //    voiced and one voiceless, then we separate them.
  // 7. If a consonant sequence contains two fricatives other than в /v/,
  //    one voiced and one voiceless, then we separate them.
  // 8. If a consonant sequence contains two labial plosives or two coronal
  //    plosives or affricates or two dorsal plosives then they are
  //    separated.
  // 9. If a consonant sequence contains two equal consonants (not
  //    necessarily consecutive), then they are separated.
  //
  // With so many prohibitive rules, a question arises: if we apply all
  // these rules, aren't we going to eliminate too many hyphenation
  // possibilities?  The answer is no.  It can be demonstrated that between
  // any two consecutive syllables at least one separation point will be
  // permitted.
  //
  //
  // Hyphenation according to the morphology
  // ---------------------------------------
  //
  // Between 1983 and 2012 the official orthographic rules of the
  // Bulgarian language forbade morphologically based hyphenation.  After
  // 2012 such hyphenation is permitted (but not obligatory).
  //
  // The most important case when it is very desirable to use
  // morphologically based hyphenation is the case of the compound words.
  // Divisions such as авток-луб /avtok-lub/ and вакуу-мапарат
  // /vakuu-maparat/ are extremely irritating even if they are formally
  // correct.  Unfortunately, we do not have a vocabulary of the compound
  // Bulgarian words that would permit us to produce rules for automated
  // hyphenation.  Therefore, the current Bulgarian hyphenation patterns do
  // not attempt to apply morphological hyphenation to such words.
  //
  // Second in importance (but far more significant in terms of numbers) is
  // the case with the word prefixes.  While the eyes of the reader still
  // look at the start of the word, the word is still unknown to him.  At
  // this point, it is very important not to deceive his expectations.  For
  // example, when the reader sees над- /nad-/ at the end of the line, he
  // will expect that this is the prefix над- /nad-/ with semantics 'attain
  // more than'.  This expectation will be fooled if this wasn't really a
  // prefix, but a deceiving (while formally correct) hyphenation of the
  // word надремя /nadremya/ 'have dozed enough' where the real prefix is
  // not над- /nad-/ but на- /na-/ with semantics 'achieve a state after
  // accumulation'.  Such hyphenation distracts the reader and makes the
  // reading more difficult.
  //
  // Third in importance is the case with the word suffixes.  With respect
  // to the hyphenation rules we can divide the suffixes into three
  // categories:
  //
  // 1. Suffixes starting with a vowel, for example -ар /-ar/.  It is not
  //    appropriate to follow the morphology with such suffixes because
  //    this will contradict the whole hyphenation tradition of the
  //    Bulgarian language.  For example крав-ар /krav-ar/ is unwarranted.
  // 2. Suffixes starting with one consonant, for example -ка /-ka/.
  //    Usually with such suffixes the syllable boundary in the word
  //    coincides with morpheme boundary so no specific cares are
  //    necessary, for example кравар-ка /kravar-ka/.  The exceptions are
  //    rare, for example: обек-тната /obek-tnata/ instead of обект-ната
  //    /obekt-nata/.
  // 3. Suffixes starting with more than one consonant (-ски /-ski/, -ство
  //    /-stvo/).  It is possible to use morphological hyphenation rules
  //    with such suffixes.
  //
  // Even if it is possible to use morphological hyphenation with the
  // suffixes of the third category, it turns out, this is not as useful as
  // it is with the case of the prefixes.  When the eyes of the reader have
  // reached this part of the word, the word is already more or less known
  // to the reader.  Therefore, at this point the morphological hyphenation
  // does not provide any significant advantages in comparison to the
  // simpler hyphenation based only on the syllables in the word.  Consider
  // for example the word геройс-тво /geroys-tvo/ with suffix -ство
  // /-stvo/.  When the reader sees геройс- /geroys-/ at the end of the
  // line this will give him an early clue that the suffix of the word is
  // -ство /-stvo/.  Such non-morphological hyphenation does not deceive
  // the expectations of the reader.  On the contrary, it makes the reading
  // easier because it gives clues to the reader about what follows on the
  // next line.
  //
  // Because of these considerations, the current Bulgarian hyphenation
  // patterns do not attempt to use morphological hyphenation with respect
  // to the suffixes of the words.  Though it would be useful to implement
  // rules about the suffixes of the second cateogory.  Hopefully, some
  // future version will have such rules.
  //
  // Occasionally,[^20] a fourth morphological requirement is stated: that
  // hyphenation should conform with the boundary between the word and the
  // definitive articles -та /-ta/ and -те /-te/ (postfixed in Bulgarian).
  // There is no need to pay attention to this rule because it seems to be
  // satisfied by its own nature.  The author has searched in a dictionary
  // with over 860000 Bulgarian words for cases when the hyphenation rules
  // would hyphenate badly with respect to the definitive article.  He was
  // unable to find even one such case with the hyphenation rules valid
  // after 1983 and only about 10 cases with the rules valid before 1983
  // (one of them is живопи-ста /zhivopi-sta/ instead of живопис-та
  // /zhivopis-ta/).
  //
  // One unavoidable characteristic of any morphologically based automated
  // hyphenation is that it can create wrong hyphenations.  Because of
  // this, one useful option is to use the morphology in a safe way – to
  // use it in order to forbid bad hyphenations but to create no new
  // hyphenation possibilities solely on the basis of the morphology.
  //
  // Take for example the word дозрея /dozreya/ 'ripen fully'.  According
  // to the phonological rules, we should hyphenate it as доз-рея
  // /doz-reya/.  According to the morphology, however, we should hyphenate
  // as до-зрея /do-zreyq/ because this word is formed with the prefix до-
  // /do-/ with semantics 'complete or supplement' and this semantics would
  // be lost if the reader sees доз- /doz-/ at the end of the line.
  // Therefore, there are three methods to hyphenate this word:
  //
  // 1. доз-рея /doz-reya/ when morphology is not used;
  // 2. до-зрея /do-zreya/ when morphology is fully used;
  // 3. дозрея /dozreya/ (no hyphenation) when morphology is used in a safe
  //    way.
  //
  // The option to use the morphology in a safe way is very attractive when
  // the software uses a smart line-breaking algorithm which can produce
  // good results even with less hyphenation possibilities.  TeX is one
  // such software.  It should be noted that this option does not eliminate
  // too many hyphenation possibilities because the morpheme boundaries
  // most of the time are also syllable boundaries.
  //
  // [^20]: Правописен и правоговорен наръчник. Състав. Иван Хаджов,
  //     Цв. Минков; Ред. Ив. Хаджов и др. София, Бълг. кн., 1945
  //
  // The following are results of a statistics about the quality of the
  // morphological rules (the number after the sign ± is the expected
  // standard deviation of our estimations):
  //
  // With the option `--morphology`:
  //
  // * in 0.1// ±0.3// of the dictionary words the morphological patterns
  //   create very wrong hyphenation;
  // * in 89.8// ±0.1// of the dictionary words the morphological patterns
  //   hyphenate identically with the case when no morphology patterns are
  //   used;
  // * in 0.3// ±0.2// of the dictionary words the morphological patterns
  //   hyphenate differently in comparison to the case when no morphology
  //   patterns are used and the word is hyphenated in a way which
  //   contradicts the morphology;
  // * in 0.6// ±0.1// of the dictionary words the morphological patterns
  //   hyphenate differently in comparison to the case when no morphology
  //   patterns are used and there is a possible hyphenation which is
  //   compatible with the word morphology but which is nevertheless
  //   forbidden by the morphology patterns.
  //
  // With the option `--safe-morphology`:
  //
  // * in 0// of the dictionary words the morphological patterns create very
  //   wrong hyphenation;
  // * in 90.0// ±0.1// of the dictionary words the morphological patterns
  //   hyphenate identically with the case when no morphology patterns are
  //   used;
  // * in 0.3// ±0.2// of the dictionary words the morphological patterns
  //   hyphenate differently in comparison to the case when no morphology
  //   patterns are used and the word is hyphenated in a way which
  //   contradicts the morphology;
  // * in 0.6// ±0.1// of the dictionary words the morphological patterns
  //   hyphenate differently in comparison to the case when no morphology
  //   patterns are used and there is a possible hyphenation which is
  //   compatible both with the word morphology and with the syllable
  //   boundaries but which is nevertheless forbidden by the morphology
  //   patterns.
  //
  // Notice that the morphological patterns create a different hyphenation
  // only in about 10// of the words.  The following explanation can be
  // given for this surprising fact.  First, the natural evolution of the
  // human languages tends to simplify the complex sequences of consonants.
  // Therefore, no morpheme contains a complex sequence of consonants.  And
  // second, the Bulgarian orthography is morphological.  This means that
  // the morphemes are written according to their actual pronunciation,
  // however the simplifications in the spoken languages which take place
  // at the morpheme boundaries are not taken into account in the
  // orthography.  The independent operation of these two factors leads to
  // the result that most of the time the morpheme boundaries coincide with
  // the conventional syllable boundaries.  The main exception to this is
  // when a morpheme starts with a vowel, in this case its syllable will
  // include one or more consonants of the preceeding morpheme.  The second
  // exception is when a morpheme ends with a vowel and the next morpheme
  // starts with a sequence of two or more consonants.
  //
  // Usage of the script `hyph-bg.sh`
  // --------------------------------
  //
  // The `hyph-bg.sh` is all-in-one script which can generate both
  // documentation (this text) and Bulgarian hyphenation patterns.  When
  // given the option `--help` the script gives short usage instructions:
  //
  // ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  // hyph-bg.sh --help
  //           Show this info
  // hyph-bg.sh [--doc-html | --doc-latex | --doc-txt]
  //           Print documentation in various formats
  // hyph-bg.sh [other options]
  //           Generate Bulgarian hyphenation patterns
  //
  // Options when generating hyphenation patterns:
  //
  //  --standalone-tex
  //           Produce hyphenation patterns for TeX with \patterns{ ... }.
  //
  //  --no-hyphen-mins
  //           Hyphenation patterns which do not require hyphen mins.
  //           Otherwise: both left and right hyphen mins should be set to 2.
  //
  //  --safe-dz
  //           Do not try to guess whether DZ is a single consonant or not.
  //           Only use hyphenation which will be correct in both cases.
  //
  //  --permissible
  //           Permit any formally correct hyphenation, including unnatural
  //           divisions, such as studen-tstvo.  Useful for educational tools
  //           or when typesetting Bulgarian text in a very short column.
  //
  //  --morphology
  //           Apply morphology when hyphenating, for example: za-dvizhvam.
  //           May hyphenate incorrectly in some cases.
  //
  //  --safe-morphology
  //           Apply morphology when hyphenating.  Never hyphenates incorrectly
  //           but may prohibit some correct hyphenations.
  //
  //  --no-morphology
  //           Disregard the morphology.  Default.
  //
  //  --1945
  //           Hyphenate according to the rules effective between 1945 and 1982
  //
  //  --1983
  //           Hyphenate according to the rules effective between 1983 and 2011
  //
  //  --2012
  //           Hyphenate according to the rules effective after 2012.  Default.
  // ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  //
  // The following are the recommended ways to generate hyphenation
  // patterns by this script:
  //
  // `hyph-bg.sh --standalone-tex --safe-morphology`
  // :   For TeX.  Apply the morphology in a safe way when the software
  //     uses a smart line-breaking algorithm.
  //
  // `hyph-bg.sh`
  // :   For most other software.
  //
  // `hyph-bg.sh --no-hyphen-mins`
  // :   The current versions of Mozilla (as of 2017) seem to ignore the
  //     hyphen mins in words that contain a dash.
  //
  // `hyph-bg.sh --morphology`
  // :   For professional typography with human proof-reader.
  //
  // `hyph-bg.sh --permissible`
  // :   For educational tools and online dictionaries which can show only one
  //     kind of hyphenation.
  //
  // Notice that some specialised English dictionaries separate the
  // word-division positions into two categories – preferred positions and
  // less recommended positions.  It would be best if the Bulgarian online
  // dictionaries could do the same.  For example hyphen "-" can be used to
  // display the preferred positions and dot "." – the less recommended
  // positions.  If a word-division position is permitted only by the
  // patterns of `hyph-bg.sh --permissible`, then this position is less
  // recommended.
  //

  var message =
    "Bulgarian hyphenation patterns (options: --safe-morphology --standalone-tex, version 21 October 2017)";
  var patterns = [
    //
    ".антиа4",
    ".антиб4",
    ".антив4",
    ".антиг4",
    ".антид4",
    ".антие4",
    ".антиж4",
    ".антиз4",
    ".антии4",
    ".антий4",
    ".антик4",
    ".антил4",
    ".антим4",
    ".антин4",
    ".антио4",
    ".антип4",
    ".антир4",
    ".антис4",
    ".антит4",
    ".антиу4",
    ".антиф4",
    ".антих4",
    ".антиц4",
    ".антиш4",
    ".антищ4",
    ".антиъ4",
    ".антию4",
    ".антия4",
    ".бб8",
    ".бв8",
    ".бг8",
    ".бд8",
    ".бж8",
    ".бз8",
    ".бк8",
    ".бл8",
    ".бм8",
    ".бн8",
    ".бп8",
    ".бр8",
    ".бс8",
    ".бт8",
    ".бф8",
    ".бх8",
    ".бц8",
    ".бч8",
    ".бш8",
    ".бщ8",
    ".вб8",
    ".вбб8",
    ".вбв8",
    ".вбг8",
    ".вбд8",
    ".вбж8",
    ".вбз8",
    ".вбк8",
    ".вбл8",
    ".вбм8",
    ".вбн8",
    ".вбп8",
    ".вбр8",
    ".вбс8",
    ".вбт8",
    ".вбф8",
    ".вбх8",
    ".вбц8",
    ".вбч8",
    ".вбш8",
    ".вбщ8",
    ".вв8",
    ".ввб8",
    ".ввв8",
    ".ввг8",
    ".ввд8",
    ".ввж8",
    ".ввз8",
    ".ввк8",
    ".ввл8",
    ".ввм8",
    ".ввн8",
    ".ввп8",
    ".ввр8",
    ".ввс8",
    ".ввт8",
    ".ввф8",
    ".ввх8",
    ".ввц8",
    ".ввч8",
    ".ввш8",
    ".ввщ8",
    ".вг8",
    ".вгб8",
    ".вгв8",
    ".вгг8",
    ".вгд8",
    ".вгж8",
    ".вгз8",
    ".вгк8",
    ".вгл8",
    ".вгм8",
    ".вгн8",
    ".вгп8",
    ".вгр8",
    ".вгс8",
    ".вгт8",
    ".вгф8",
    ".вгх8",
    ".вгц8",
    ".вгч8",
    ".вгш8",
    ".вгщ8",
    ".вд8",
    ".вдб8",
    ".вдв8",
    ".вдг8",
    ".вдд8",
    ".вдж8",
    ".вдз8",
    ".вдк8",
    ".вдл8",
    ".вдм8",
    ".вдн8",
    ".вдп8",
    ".вдр8",
    ".вдс8",
    ".вдт8",
    ".вдф8",
    ".вдх8",
    ".вдц8",
    ".вдч8",
    ".вдш8",
    ".вдщ8",
    ".вж8",
    ".вжб8",
    ".вжв8",
    ".вжг8",
    ".вжд8",
    ".вжж8",
    ".вжз8",
    ".вжк8",
    ".вжл8",
    ".вжм8",
    ".вжн8",
    ".вжп8",
    ".вжр8",
    ".вжс8",
    ".вжт8",
    ".вжф8",
    ".вжх8",
    ".вжц8",
    ".вжч8",
    ".вжш8",
    ".вжщ8",
    ".вз8",
    ".взб8",
    ".взв8",
    ".взг8",
    ".взд8",
    ".взж8",
    ".взз8",
    ".взк8",
    ".взл8",
    ".взм8",
    ".взн8",
    ".взп8",
    ".взр8",
    ".взс8",
    ".взт8",
    ".взф8",
    ".взх8",
    ".взц8",
    ".взч8",
    ".взш8",
    ".взщ8",
    ".вк8",
    ".вкб8",
    ".вкв8",
    ".вкг8",
    ".вкд8",
    ".вкж8",
    ".вкз8",
    ".вкк8",
    ".вкл8",
    ".вкм8",
    ".вкн8",
    ".вкп8",
    ".вкр8",
    ".вкс8",
    ".вкт8",
    ".вкф8",
    ".вкх8",
    ".вкц8",
    ".вкч8",
    ".вкш8",
    ".вкщ8",
    ".вл8",
    ".влб8",
    ".влв8",
    ".влг8",
    ".влд8",
    ".влж8",
    ".влз8",
    ".влк8",
    ".влл8",
    ".влм8",
    ".влн8",
    ".влп8",
    ".влр8",
    ".влс8",
    ".влт8",
    ".влф8",
    ".влх8",
    ".влц8",
    ".влч8",
    ".влш8",
    ".влщ8",
    ".вм8",
    ".вмб8",
    ".вмв8",
    ".вмг8",
    ".вмд8",
    ".вмж8",
    ".вмз8",
    ".вмк8",
    ".вмл8",
    ".вмм8",
    ".вмн8",
    ".вмп8",
    ".вмр8",
    ".вмс8",
    ".вмт8",
    ".вмф8",
    ".вмх8",
    ".вмц8",
    ".вмч8",
    ".вмш8",
    ".вмщ8",
    ".вн8",
    ".внб8",
    ".внв8",
    ".внг8",
    ".внд8",
    ".внж8",
    ".внз8",
    ".внк8",
    ".внл8",
    ".внм8",
    ".внн8",
    ".внп8",
    ".внр8",
    ".внс8",
    ".внт8",
    ".внф8",
    ".внх8",
    ".внц8",
    ".внч8",
    ".внш8",
    ".внщ8",
    ".вп8",
    ".впб8",
    ".впв8",
    ".впг8",
    ".впд8",
    ".впж8",
    ".впз8",
    ".впк8",
    ".впл8",
    ".впм8",
    ".впн8",
    ".впп8",
    ".впр8",
    ".впс8",
    ".впт8",
    ".впф8",
    ".впх8",
    ".впц8",
    ".впч8",
    ".впш8",
    ".впщ8",
    ".вр8",
    ".врб8",
    ".врв8",
    ".врг8",
    ".врд8",
    ".врж8",
    ".врз8",
    ".врк8",
    ".врл8",
    ".врм8",
    ".врн8",
    ".врп8",
    ".врр8",
    ".врс8",
    ".врт8",
    ".врф8",
    ".врх8",
    ".врц8",
    ".врч8",
    ".врш8",
    ".врщ8",
    ".вс8",
    ".всб8",
    ".всв8",
    ".всг8",
    ".всд8",
    ".всж8",
    ".всз8",
    ".вск8",
    ".всл8",
    ".всм8",
    ".всн8",
    ".всп8",
    ".вср8",
    ".всс8",
    ".вст8",
    ".всф8",
    ".всх8",
    ".всц8",
    ".всч8",
    ".всш8",
    ".всщ8",
    ".вт8",
    ".втб8",
    ".втв8",
    ".втг8",
    ".втд8",
    ".втж8",
    ".втз8",
    ".втк8",
    ".втл8",
    ".втм8",
    ".втн8",
    ".втп8",
    ".втр8",
    ".втс8",
    ".втт8",
    ".втф8",
    ".втх8",
    ".втц8",
    ".втч8",
    ".втш8",
    ".втщ8",
    ".вф8",
    ".вфб8",
    ".вфв8",
    ".вфг8",
    ".вфд8",
    ".вфж8",
    ".вфз8",
    ".вфк8",
    ".вфл8",
    ".вфм8",
    ".вфн8",
    ".вфп8",
    ".вфр8",
    ".вфс8",
    ".вфт8",
    ".вфф8",
    ".вфх8",
    ".вфц8",
    ".вфч8",
    ".вфш8",
    ".вфщ8",
    ".вх8",
    ".вхб8",
    ".вхв8",
    ".вхг8",
    ".вхд8",
    ".вхж8",
    ".вхз8",
    ".вхк8",
    ".вхл8",
    ".вхм8",
    ".вхн8",
    ".вхп8",
    ".вхр8",
    ".вхс8",
    ".вхт8",
    ".вхф8",
    ".вхх8",
    ".вхц8",
    ".вхч8",
    ".вхш8",
    ".вхщ8",
    ".вц8",
    ".вцб8",
    ".вцв8",
    ".вцг8",
    ".вцд8",
    ".вцж8",
    ".вцз8",
    ".вцк8",
    ".вцл8",
    ".вцм8",
    ".вцн8",
    ".вцп8",
    ".вцр8",
    ".вцс8",
    ".вцт8",
    ".вцф8",
    ".вцх8",
    ".вцц8",
    ".вцч8",
    ".вцш8",
    ".вцщ8",
    ".вч8",
    ".вчб8",
    ".вчв8",
    ".вчг8",
    ".вчд8",
    ".вчж8",
    ".вчз8",
    ".вчк8",
    ".вчл8",
    ".вчм8",
    ".вчн8",
    ".вчп8",
    ".вчр8",
    ".вчс8",
    ".вчт8",
    ".вчф8",
    ".вчх8",
    ".вчц8",
    ".вчч8",
    ".вчш8",
    ".вчщ8",
    ".вш8",
    ".вшб8",
    ".вшв8",
    ".вшг8",
    ".вшд8",
    ".вшж8",
    ".вшз8",
    ".вшк8",
    ".вшл8",
    ".вшм8",
    ".вшн8",
    ".вшп8",
    ".вшр8",
    ".вшс8",
    ".вшт8",
    ".вшф8",
    ".вшх8",
    ".вшц8",
    ".вшч8",
    ".вшш8",
    ".вшщ8",
    ".вщ8",
    ".вщб8",
    ".вщв8",
    ".вщг8",
    ".вщд8",
    ".вщж8",
    ".вщз8",
    ".вщк8",
    ".вщл8",
    ".вщм8",
    ".вщн8",
    ".вщп8",
    ".вщр8",
    ".вщс8",
    ".вщт8",
    ".вщф8",
    ".вщх8",
    ".вщц8",
    ".вщч8",
    ".вщш8",
    ".вщщ8",
    ".въ2за4",
    ".въ2зб4",
    ".въ2зв4",
    ".въ2зг4",
    ".въ2зд4",
    ".въ2зе4",
    ".въ5з4ел",
    ".въ5з4е5ла",
    ".въ5з4е5лът",
    ".въ2зж4",
    ".въ2зз4",
    ".въ2зи4",
    ".въ2зй4",
    ".въ2зк4",
    ".въ2зл4",
    ".въ2зм4",
    ".въ2зн4",
    ".въ2зо4",
    ".въ2зп4",
    ".въ2зр4",
    ".въ2зс4",
    ".въ2зт4",
    ".въ2зу4",
    ".въ2зф4",
    ".въ2зх4",
    ".въ2зц4",
    ".въ2зч4",
    ".въ2зш4",
    ".въ2зщ4",
    ".въ2зъ4",
    ".въ2зю4",
    ".въ2зя4",
    ".гб8",
    ".гв8",
    ".гг8",
    ".гд8",
    ".гж8",
    ".гз8",
    ".гк8",
    ".гл8",
    ".гм8",
    ".гн8",
    ".гп8",
    ".гр8",
    ".гс8",
    ".гт8",
    ".гф8",
    ".гх8",
    ".гц8",
    ".гч8",
    ".гш8",
    ".гщ8",
    ".дб8",
    ".дв8",
    ".дг8",
    ".дд8",
    ".дж8",
    ".дз8",
    ".дк8",
    ".дл8",
    ".дм8",
    ".дн8",
    ".доа4",
    ".доб4",
    ".до4б5лест",
    ".до4б5р",
    ".до4б6ро",
    ".дов4",
    ".дог4",
    ".до4г5м",
    ".дод4",
    ".дое4",
    ".дож4",
    ".доз4",
    ".дои4",
    ".док4",
    ".до4к5л",
    ".до4к5т",
    ".дол4",
    ".до4л5н",
    ".до4л5ч",
    ".дом4",
    ".дон4",
    ".до4н5г",
    ".до4н5д",
    ".до4н5ж",
    ".до4н5к",
    ".до4н5с",
    ".до4н5ч",
    ".доо4",
    ".доп4",
    ".дор4",
    ".дос4",
    ".до4с5то",
    ".дот4",
    ".доу4",
    ".доф4",
    ".дох4",
    ".доц4",
    ".доч4",
    ".дош4",
    ".дощ4",
    ".доъ4",
    ".дою4",
    ".доя4",
    ".дп8",
    ".др8",
    ".дс8",
    ".дт8",
    ".дф8",
    ".дх8",
    ".дц8",
    ".дч8",
    ".дш8",
    ".дщ8",
    ".жб8",
    ".жв8",
    ".жг8",
    ".жд8",
    ".жж8",
    ".жз8",
    ".жк8",
    ".жл8",
    ".жм8",
    ".жн8",
    ".жп8",
    ".жр8",
    ".жс8",
    ".жт8",
    ".жф8",
    ".жх8",
    ".жц8",
    ".жч8",
    ".жш8",
    ".жщ8",
    ".заа4",
    ".заб4",
    ".зав4",
    ".заг4",
    ".зад4",
    ".за4д5гран",
    ".за4д5гроб",
    ".за4д5кулис",
    ".за4д5мин",
    ".за4д5мор",
    ".за4д5н",
    ".зае4",
    ".заж4",
    ".заз4",
    ".заи4",
    ".зак4",
    ".зал4",
    ".за4л5п",
    ".зам4",
    ".зан4",
    ".за4н5д",
    ".зао4",
    ".зап4",
    ".за4п5т",
    ".зар4",
    ".за4р5з",
    ".зас4",
    ".зат4",
    ".зау4",
    ".заф4",
    ".зах4",
    ".зац4",
    ".зач4",
    ".заш4",
    ".защ4",
    ".заъ4",
    ".заю4",
    ".зая4",
    ".зб8",
    ".зв8",
    ".зг8",
    ".зд8",
    ".зж8",
    ".зз8",
    ".зк8",
    ".зл8",
    ".зм8",
    ".зн8",
    ".зп8",
    ".зр8",
    ".зс8",
    ".зт8",
    ".зф8",
    ".зх8",
    ".зц8",
    ".зч8",
    ".зш8",
    ".зщ8",
    ".иза4",
    ".изб4",
    ".изв4",
    ".изг4",
    ".изд4",
    ".изе4",
    ".изж4",
    ".изз4",
    ".изи4",
    ".изй4",
    ".изк4",
    ".изл4",
    ".изм4",
    ".изн4",
    ".изо2бб4",
    ".изо2бв4",
    ".изо2бг4",
    ".изо2бд4",
    ".изо2бж4",
    ".изо2бз4",
    ".изо4би",
    ".изо2бк4",
    ".изо2бл4",
    ".изо2бм4",
    ".изо2бн4",
    ".изо2бп4",
    ".изо2бр4",
    ".изо2бс4",
    ".изо2бт4",
    ".изо2бф4",
    ".изо2бх4",
    ".изо2бц4",
    ".изо2бч4",
    ".изо2бш4",
    ".изо2бщ4",
    ".изохк",
    ".изп4",
    ".изпоа4",
    ".изпоб4",
    ".изпов4",
    ".изпог4",
    ".изпод4",
    ".изпое4",
    ".изпож4",
    ".изпоз4",
    ".изпои4",
    ".изпой4",
    ".изпок4",
    ".изпол4",
    ".изпо4л5з",
    ".изпом4",
    ".изпо4м5п",
    ".изпон4",
    ".изпоо4",
    ".изпоп4",
    ".изпор4",
    ".изпо4р5т",
    ".изпос4",
    ".изпот4",
    ".изпоу4",
    ".изпоф4",
    ".изпох4",
    ".изпоц4",
    ".изпоч4",
    ".изпош4",
    ".изпощ4",
    ".изпоъ4",
    ".изпою4",
    ".изпоя4",
    ".изр4",
    ".изс4",
    ".изт4",
    ".изу4",
    ".изф4",
    ".изх4",
    ".изц4",
    ".изч4",
    ".изш4",
    ".изщ4",
    ".изъ4",
    ".изю4",
    ".изя4",
    ".кб8",
    ".кв8",
    ".кг8",
    ".кд8",
    ".кж8",
    ".кз8",
    ".кк8",
    ".кл8",
    ".км8",
    ".кн8",
    ".кп8",
    ".кр8",
    ".кс8",
    ".кт8",
    ".кф8",
    ".кх8",
    ".кц8",
    ".кч8",
    ".кш8",
    ".кщ8",
    ".лб8",
    ".лв8",
    ".лг8",
    ".лд8",
    ".лж8",
    ".лз8",
    ".лк8",
    ".лл8",
    ".лм8",
    ".лн8",
    ".лп8",
    ".лр8",
    ".лс8",
    ".лт8",
    ".лф8",
    ".лх8",
    ".лц8",
    ".лч8",
    ".лш8",
    ".лщ8",
    ".мб8",
    ".мв8",
    ".мг8",
    ".мд8",
    ".мж8",
    ".мз8",
    ".мк8",
    ".мл8",
    ".мм8",
    ".мн8",
    ".мп8",
    ".мр8",
    ".мс8",
    ".мт8",
    ".мф8",
    ".мх8",
    ".мц8",
    ".мч8",
    ".мш8",
    ".мщ8",
    ".наа4",
    ".наб4",
    ".нав4",
    ".наг4",
    ".на4г5ло",
    ".на2дб4",
    ".на2дв4",
    ".на2дг4",
    ".на2дд4",
    ".на2д3ж4",
    ".на3д4жав",
    ".на3д4жас",
    ".на2дз4",
    ".на4ди4гр",
    ".на2дк4",
    ".на2дл4",
    ".на2дм4",
    ".на2дн4",
    ".на2дп4",
    ".на2др4",
    ".над4ращ",
    ".над4реб",
    ".над4рем",
    ".над4роб",
    ".над4рус",
    ".над4рън",
    ".над4рям",
    ".на2дс4",
    ".на2дт4",
    ".на2дф4",
    ".на2дх4",
    ".на2дц4",
    ".на2дч4",
    ".на2дш4",
    ".на2дщ4",
    ".нае4",
    ".наж4",
    ".наз4",
    ".наи4",
    ".нак4",
    ".нал4",
    ".нам4",
    ".нан4",
    ".нао4",
    ".нап4",
    ".нар4",
    ".на4р5г",
    ".на4р5к",
    ".нас4",
    ".нат4",
    ".нау4",
    ".наф4",
    ".нах4",
    ".нац4",
    ".нач4",
    ".наш4",
    ".нащ4",
    ".наъ4",
    ".наю4",
    ".ная4",
    ".нб8",
    ".нв8",
    ".нг8",
    ".нд8",
    ".нж8",
    ".нз8",
    ".нк8",
    ".нл8",
    ".нм8",
    ".нн8",
    ".нп8",
    ".нр8",
    ".нс8",
    ".нт8",
    ".нф8",
    ".нх8",
    ".нц8",
    ".нч8",
    ".нш8",
    ".нщ8",
    ".оа4",
    ".оа5зис",
    ".оба4гн",
    ".обб4",
    ".обв4",
    ".обг4",
    ".обд4",
    ".обж4",
    ".обз4",
    ".оби4гр",
    ".обк4",
    ".обл4",
    ".об4лаго",
    ".об4лаж",
    ".обм4",
    ".обн4",
    ".обо4бщ",
    ".обоз4н",
    ".обоз4р",
    ".обос4н",
    ".обособ",
    ".обп4",
    ".обр4",
    ".об4рем",
    ".об4рул",
    ".об4ръс",
    ".обс4",
    ".обт4",
    ".обу4зд",
    ".обусл",
    ".обф4",
    ".обх4",
    ".обц4",
    ".обч4",
    ".обш4",
    ".общ4",
    ".об4щ5н",
    ".обя4сн",
    ".ов4",
    ".ов4дов",
    ".ов4лад",
    ".ов5ц",
    ".ов5ч",
    ".ог4",
    ".ог5н",
    ".од4",
    ".ое4",
    ".ож4",
    ".оз4",
    ".озд4р",
    ".ои4",
    ".ой4",
    ".ок4",
    ".ок5си",
    ".ок5т",
    ".ол4",
    ".ол5тар",
    ".ом4",
    ".ом5лет",
    ".ом5ни",
    ".он4",
    ".он5баш",
    ".он5дул",
    ".он5зи",
    ".он5ко",
    ".он5лайн",
    ".он5то",
    ".оо4",
    ".оп4",
    ".оп5т",
    ".оп5ци",
    ".ор4",
    ".ор5б",
    ".ор5г",
    ".ор5д",
    ".ор5к",
    ".ор5л",
    ".ор5н",
    ".ор5т",
    ".ор5ф",
    ".ор5х",
    ".ос4",
    ".ос5ман",
    ".ос5мин",
    ".ос5миц",
    ".ос5мич",
    ".ос5мо",
    ".ос5те",
    ".ос5тро",
    ".ос5ци",
    ".отб4",
    ".отв4",
    ".отг4",
    ".отд4",
    ".отж4",
    ".отз4",
    ".оти4в",
    ".оти4д",
    ".отк4",
    ".отл4",
    ".отм4",
    ".отн4",
    ".отп4",
    ".отр4",
    ".отс4",
    ".отт4",
    ".оту4ч",
    ".отф4",
    ".отх4",
    ".отц4",
    ".отч4",
    ".отш4",
    ".отщ4",
    ".оу4",
    ".оф4",
    ".ох4",
    ".ох5ва",
    ".ох5ка",
    ".ох5на",
    ".оц4",
    ".оч4",
    ".ош4",
    ".ощ4",
    ".оъ4",
    ".ою4",
    ".оя4",
    ".пб8",
    ".пв8",
    ".пг8",
    ".пд8",
    ".пж8",
    ".пз8",
    ".пк8",
    ".пл8",
    ".пм8",
    ".пн8",
    ".поа4",
    ".поб4",
    ".пов4",
    ".пог4",
    ".по2дб4",
    ".по2дв4",
    ".под4воу",
    ".по2дг4",
    ".по2дд4",
    ".по2д3ж4",
    ".по3д4жав",
    ".по3д4жур",
    ".по2дз4",
    ".по2ди4гр",
    ".по2ди4зр",
    ".по2дк4",
    ".по2дл4",
    ".по2дм4",
    ".по2дн4",
    ".по2до4паш",
    ".по2до4стр",
    ".по2до4тд",
    ".по2до4тч",
    ".по2до4ф",
    ".по2дп4",
    ".по2др4",
    ".под4рем",
    ".под4рън",
    ".под4ръп",
    ".под4рям",
    ".по2дс4",
    ".по2дт4",
    ".по2ду4пр",
    ".по2ду4ч",
    ".по2дф4",
    ".по2дх4",
    ".по2дц4",
    ".по2дч4",
    ".по2дш4",
    ".по2дщ4",
    ".пое4",
    ".пож4",
    ".поз4",
    ".позаа4",
    ".позаб4",
    ".позав4",
    ".позаг4",
    ".позад4",
    ".позае4",
    ".позаж4",
    ".позаз4",
    ".позаи4",
    ".позай4",
    ".позак4",
    ".позал4",
    ".позам4",
    ".позан4",
    ".позао4",
    ".позап4",
    ".позар4",
    ".позас4",
    ".позат4",
    ".позау4",
    ".позаф4",
    ".позах4",
    ".позац4",
    ".позач4",
    ".позаш4",
    ".позащ4",
    ".позаъ4",
    ".позаю4",
    ".позая4",
    ".пои4",
    ".пои2за4",
    ".пои2зб4",
    ".пои2зв4",
    ".пои2зг4",
    ".пои2зд4",
    ".пои2зе4",
    ".пои2зж4",
    ".пои2зз4",
    ".пои2зи4",
    ".пои2зй4",
    ".пои2зк4",
    ".пои2зл4",
    ".пои2зм4",
    ".пои2зн4",
    ".пои2зо4",
    ".пои2зп4",
    ".пои2зр4",
    ".пои2зс4",
    ".пои2зт4",
    ".пои2зу4",
    ".пои2зф4",
    ".пои2зх4",
    ".пои2зц4",
    ".пои2зч4",
    ".пои2зш4",
    ".пои2зщ4",
    ".пои2зъ4",
    ".пои2зю4",
    ".пои2зя4",
    ".пой4",
    ".пок4",
    ".пол4",
    ".по4л5з",
    ".по4л5к",
    ".по4л5с",
    ".пом4",
    ".по4м5п",
    ".пон4",
    ".понаа4",
    ".понаб4",
    ".понав4",
    ".понаг4",
    ".пона2дб4",
    ".пона2дв4",
    ".пона2дг4",
    ".пона2дд4",
    ".пона2дж4",
    ".пона2дз4",
    ".пона2ди4гр",
    ".пона2дк4",
    ".пона2дл4",
    ".пона2дм4",
    ".пона2дн4",
    ".пона2дп4",
    ".пона2др4",
    ".понад4ращ",
    ".понад4реб",
    ".понад4рем",
    ".понад4роб",
    ".понад4рус",
    ".понад4рън",
    ".понад4рям",
    ".пона2дс4",
    ".пона2дт4",
    ".пона2дф4",
    ".пона2дх4",
    ".пона2дц4",
    ".пона2дч4",
    ".пона2дш4",
    ".пона2дщ4",
    ".понае4",
    ".понаж4",
    ".поназ4",
    ".понаи4",
    ".понай4",
    ".понак4",
    ".понал4",
    ".понам4",
    ".понан4",
    ".понао4",
    ".понап4",
    ".понар4",
    ".понас4",
    ".понат4",
    ".понау4",
    ".понаф4",
    ".понах4",
    ".понац4",
    ".понач4",
    ".понаш4",
    ".понащ4",
    ".понаъ4",
    ".понаю4",
    ".поная4",
    ".по4н5т",
    ".пооа4",
    ".поо4бад",
    ".поо4бажд",
    ".поо2бб4",
    ".поо2бв4",
    ".поо2бг4",
    ".поо2бд4",
    ".поо2бж4",
    ".поо2бз4",
    ".поо2би4гр",
    ".поо4бик",
    ".поо2бк4",
    ".поо2бл4",
    ".поо2бм4",
    ".поо2бн4",
    ".поо2бп4",
    ".поо2бр4",
    ".поо2бс4",
    ".поо2бт4",
    ".поо2бф4",
    ".поо2бх4",
    ".поо2бц4",
    ".поо2бч4",
    ".поо2бш4",
    ".поо2бщ4",
    ".поо2бя4сн",
    ".поов4",
    ".поог4",
    ".поод4",
    ".поое4",
    ".поож4",
    ".пооз4",
    ".поои4",
    ".поой4",
    ".поок4",
    ".поол4",
    ".поом4",
    ".поон4",
    ".пооо4",
    ".пооп4",
    ".поор4",
    ".поос4",
    ".поо2тб4",
    ".поо2тв4",
    ".поо2тг4",
    ".поо2тд4",
    ".поо2тж4",
    ".поо2тз4",
    ".поо2тк4",
    ".поо2тл4",
    ".поо2тм4",
    ".поо2тн4",
    ".поо2тп4",
    ".поо2тр4",
    ".поо2тс4",
    ".поо2тт4",
    ".поо2ту4ч",
    ".поо2тф4",
    ".поо2тх4",
    ".поо2тц4",
    ".поо2тч4",
    ".поо2тш4",
    ".поо2тщ4",
    ".пооу4",
    ".пооф4",
    ".поох4",
    ".пооц4",
    ".пооч4",
    ".поош4",
    ".поощ4",
    ".поо4щ5р",
    ".пооъ4",
    ".поою4",
    ".пооя4",
    ".поп4риа4",
    ".поп4риб4",
    ".поп4рив4",
    ".поп4риг4",
    ".поп4рид4",
    ".поп4рие4",
    ".поп4риж4",
    ".поп4риз4",
    ".поп4рии4",
    ".поп4рий4",
    ".поп4рик4",
    ".поп4рил4",
    ".поп4рим4",
    ".поп4рин4",
    ".поп4рио4",
    ".поп4рип4",
    ".поп4рир4",
    ".поп4рис4",
    ".поп4рит4",
    ".поп4риу4",
    ".поп4риф4",
    ".поп4рих4",
    ".поп4риц4",
    ".поп4рич4",
    ".поп4риш4",
    ".поп4рищ4",
    ".поп4риъ4",
    ".поп4рию4",
    ".поп4рия4",
    ".пор4",
    ".по4р5н",
    ".по4р5т",
    ".по4р5ф",
    ".по4р5ц",
    ".пос4",
    ".по4с4т",
    ".пот4",
    ".по4т5н",
    ".поу4",
    ".поф4",
    ".пох4",
    ".поц4",
    ".пош4",
    ".пощ4",
    ".поъ4",
    ".пою4",
    ".поя4",
    ".пп8",
    ".пр8",
    ".преа4",
    ".преб4",
    ".прев4",
    ".превъ2за4",
    ".превъ2зб4",
    ".превъ2зв4",
    ".превъ2зг4",
    ".превъ2зд4",
    ".превъ2зе4",
    ".превъ2зж4",
    ".превъ2зз4",
    ".превъ2зи4",
    ".превъ2зй4",
    ".превъ2зк4",
    ".превъ2зл4",
    ".превъ2зм4",
    ".превъ2зн4",
    ".превъ2зо4",
    ".превъ2зп4",
    ".превъ2зр4",
    ".превъ2зс4",
    ".превъ2зт4",
    ".превъ2зу4",
    ".превъ2зф4",
    ".превъ2зх4",
    ".превъ2зц4",
    ".превъ2зч4",
    ".превъ2зш4",
    ".превъ2зщ4",
    ".превъ2зъ4",
    ".превъ2зю4",
    ".превъ2зя4",
    ".прег4",
    ".пре2дб4",
    ".пре2дв4",
    ".пре2дг4",
    ".пре2дд4",
    ".пре2дж4",
    ".пре2дз4",
    ".пре2ди4зб4",
    ".пре2ди4зв4",
    ".пре2ди4нфар",
    ".пре2ди4стор",
    ".пре2дк4",
    ".пре2дл4",
    ".пре2дм4",
    ".пре2дн4",
    ".пре2до4бед",
    ".пре2до4ктом",
    ".пре2доп4ред",
    ".пре2дос4воб",
    ".пре2до2та4",
    ".пре2до2тб4",
    ".пре2до2тв4",
    ".пре2до2тг4",
    ".пре2до2тд4",
    ".пре2до2те4",
    ".пре2до2тж4",
    ".пре2до2тз4",
    ".пре2до2ти4",
    ".пре2до2тй4",
    ".пре2до2тк4",
    ".пре2до2тл4",
    ".пре2до2тм4",
    ".пре2до2тн4",
    ".пре2до2то4",
    ".пре2до2тп4",
    ".пре2до2тр4",
    ".пре2до2тс4",
    ".пре2до2тт4",
    ".пре2до2ту4",
    ".пре2до2тф4",
    ".пре2до2тх4",
    ".пре2до2тц4",
    ".пре2до2тч4",
    ".пре2до2тш4",
    ".пре2до2тщ4",
    ".пре2до2тъ4",
    ".пре2до2тю4",
    ".пре2до2тя4",
    ".пре2дох4р",
    ".пре2дп4",
    ".пре2др4",
    ".пред4рем",
    ".пре2д4реш",
    ".пред4рям",
    ".пре2дс4",
    ".пре2дт4",
    ".пре2ду4бед",
    ".пре2ду4бежд",
    ".пре2дугад",
    ".пре2думис",
    ".пре2думиш",
    ".пре2ду4пр",
    ".пре2дусе",
    ".пре2дус4л",
    ".пре2ду4трин",
    ".пре2ду4чил",
    ".пре2дф4",
    ".пре2дх4",
    ".пре2дц4",
    ".пре2дч4",
    ".пре2дш4",
    ".пре2дщ4",
    ".пре2дя4в",
    ".пре2дя4ст",
    ".прее4",
    ".преж4",
    ".пре4ж5д",
    ".презаа4",
    ".презаб4",
    ".презав4",
    ".презаг4",
    ".презад4",
    ".презае4",
    ".презаж4",
    ".презаз4",
    ".презаи4",
    ".презай4",
    ".презак4",
    ".презал4",
    ".презам4",
    ".презан4",
    ".презао4",
    ".презап4",
    ".презар4",
    ".презас4",
    ".презат4",
    ".презау4",
    ".презаф4",
    ".презах4",
    ".презац4",
    ".презач4",
    ".презаш4",
    ".презащ4",
    ".презаъ4",
    ".презаю4",
    ".презая4",
    ".пре2зб4",
    ".пре2зв4",
    ".пре2зг4",
    ".пре2зд4",
    ".пре2зж4",
    ".пре2зз4",
    ".пре2зк4",
    ".пре2зл4",
    ".пре2зм4",
    ".пре2зн4",
    ".пре4з5о4кеан",
    ".пре2зп4",
    ".през4р",
    ".пре4з5рам",
    ".пре4з5ред",
    ".пре2зс4",
    ".пре2зт4",
    ".пре2зф4",
    ".пре2зх4",
    ".пре2зц4",
    ".пре2зч4",
    ".пре2зш4",
    ".пре2зщ4",
    ".преи4",
    ".преи2за4",
    ".преи2зб4",
    ".преи2зв4",
    ".преи2зг4",
    ".преи2зд4",
    ".преи2зе4",
    ".преи2зж4",
    ".преи2зз4",
    ".преи2зи4",
    ".преи2зй4",
    ".преи2зк4",
    ".преи2зл4",
    ".преи2зм4",
    ".преи2зн4",
    ".преи2зо4",
    ".преи2зп4",
    ".преи2зр4",
    ".преи2зс4",
    ".преи2зт4",
    ".преи2зу4",
    ".преи2зф4",
    ".преи2зх4",
    ".преи2зц4",
    ".преи2зч4",
    ".преи2зш4",
    ".преи2зщ4",
    ".преи2зъ4",
    ".преи2зю4",
    ".преи2зя4",
    ".прей4",
    ".прек4",
    ".прел4",
    ".прем4",
    ".прен4",
    ".пренаа4",
    ".пренаб4",
    ".пренав4",
    ".пренаг4",
    ".пренад4",
    ".пренае4",
    ".пренаж4",
    ".преназ4",
    ".пренаи4",
    ".пренай4",
    ".пренак4",
    ".пренал4",
    ".пренам4",
    ".пренан4",
    ".пренао4",
    ".пренап4",
    ".пренар4",
    ".пренас4",
    ".пренат4",
    ".пренау4",
    ".пренаф4",
    ".пренах4",
    ".пренац4",
    ".пренач4",
    ".пренаш4",
    ".пренащ4",
    ".пренаъ4",
    ".пренаю4",
    ".преная4",
    ".прео4",
    ".преп4",
    ".прер4",
    ".прес4",
    ".пре4с5но",
    ".пре4с5па",
    ".пре4с4пи",
    ".пре4с5ц",
    ".прет4",
    ".преу4",
    ".преф4",
    ".прех4",
    ".прец4",
    ".преч4",
    ".пре4ч5к",
    ".прещ4",
    ".преъ4",
    ".прею4",
    ".прея4",
    ".приа4",
    ".приб4",
    ".прив4",
    ".приг4",
    ".прид4",
    ".прие4",
    ".приж4",
    ".приз4",
    ".при4з5м",
    ".прии4",
    ".прий4",
    ".прик4",
    ".прил4",
    ".прим4",
    ".при4м5к",
    ".прин4",
    ".при4н5т",
    ".при4н5ц",
    ".прио4",
    ".прип4",
    ".при4п5в",
    ".при4п5к",
    ".при4п5н",
    ".прир4",
    ".прис4",
    ".прит4",
    ".при4т5ч",
    ".приу4",
    ".приф4",
    ".прих4",
    ".при4х5н",
    ".приц4",
    ".прич4",
    ".приш4",
    ".при4ш5к",
    ".прищ4",
    ".приъ4",
    ".прию4",
    ".прия4",
    ".проа4",
    ".проб4",
    ".про4б5в",
    ".про4б5к",
    ".про4б5лем",
    ".пров4",
    ".прог4",
    ".прод4",
    ".прое4",
    ".прож4",
    ".проз4",
    ".прои4",
    ".прок4",
    ".про4к5с",
    ".прол4",
    ".пром4",
    ".прон4",
    ".проо4",
    ".проп4",
    ".прор4",
    ".прос4",
    ".про4с5б",
    ".про4с4т",
    ".про4с5ф",
    ".прот4",
    ".проу4",
    ".прох4",
    ".проц4",
    ".проч4",
    ".прош4",
    ".прощ4",
    ".проъ4",
    ".прою4",
    ".проя4",
    ".пс8",
    ".пт8",
    ".пф8",
    ".пх8",
    ".пц8",
    ".пч8",
    ".пш8",
    ".пщ8",
    ".ра2за4",
    ".ра2зб4",
    ".ра2зв4",
    ".ра2зг4",
    ".ра2зд4",
    ".ра2зе4",
    ".ра2зж4",
    ".ра2зз4",
    ".ра2зи4",
    ".ра2зй4",
    ".ра2зк4",
    ".ра2зл4",
    ".ра2зм4",
    ".ра2зн4",
    ".ра2зо4",
    ".ра2зп4",
    ".ра2зр4",
    ".ра2зс4",
    ".ра2зт4",
    ".ра2зу4",
    ".ра2зф4",
    ".ра2зх4",
    ".ра2зц4",
    ".ра2зч4",
    ".ра2зш4",
    ".ра2зщ4",
    ".ра2зъ4",
    ".ра2зю4",
    ".ра2зя4",
    ".рб8",
    ".рв8",
    ".рг8",
    ".рд8",
    ".рж8",
    ".рз8",
    ".рк8",
    ".рл8",
    ".рм8",
    ".рн8",
    ".рп8",
    ".рр8",
    ".рс8",
    ".рт8",
    ".рф8",
    ".рх8",
    ".рц8",
    ".рч8",
    ".рш8",
    ".рщ8",
    ".сб8",
    ".св8",
    ".сг8",
    ".сд8",
    ".сж8",
    ".сз8",
    ".ск8",
    ".сл8",
    ".см8",
    ".сн8",
    ".сп8",
    ".ср8",
    ".сс8",
    ".ст8",
    ".сф8",
    ".сх8",
    ".сц8",
    ".сч8",
    ".сш8",
    ".сщ8",
    ".тб8",
    ".тв8",
    ".тг8",
    ".тд8",
    ".тж8",
    ".тз8",
    ".тк8",
    ".тл8",
    ".тм8",
    ".тн8",
    ".тп8",
    ".тр8",
    ".тс8",
    ".тт8",
    ".тф8",
    ".тх8",
    ".тц8",
    ".тч8",
    ".тш8",
    ".тщ8",
    ".уа4",
    ".уб4",
    ".ув4",
    ".уг4",
    ".уд4",
    ".уе4",
    ".уж4",
    ".уж5ки",
    ".уз4",
    ".уз5бе",
    ".уи4",
    ".уй4",
    ".уй5дис",
    ".уй5ду",
    ".ук4",
    ".ул4",
    ".ул5т",
    ".ун4",
    ".ун5гар",
    ".ун5ци",
    ".уо4",
    ".уп4",
    ".ур4",
    ".ур5ба",
    ".ур5в",
    ".ур5н",
    ".ур5суз",
    ".ур5ти",
    ".ус4",
    ".ус5та",
    ".ус5те",
    ".ус5ти",
    ".ут4",
    ".ут5ре.",
    ".ут5реш",
    ".ут5рин",
    ".ут4ро",
    ".уу4",
    ".уф4",
    ".ух4",
    ".уц4",
    ".уч4",
    ".уч5тив",
    ".уш4",
    ".уш5но",
    ".ущ4",
    ".уъ4",
    ".ую4",
    ".ую5те",
    ".уя4",
    ".фб8",
    ".фв8",
    ".фг8",
    ".фд8",
    ".фж8",
    ".фз8",
    ".фк8",
    ".фл8",
    ".фм8",
    ".фн8",
    ".фп8",
    ".фр8",
    ".фс8",
    ".фт8",
    ".фф8",
    ".фх8",
    ".фц8",
    ".фч8",
    ".фш8",
    ".фщ8",
    ".хб8",
    ".хв8",
    ".хг8",
    ".хд8",
    ".хж8",
    ".хз8",
    ".хк8",
    ".хл8",
    ".хм8",
    ".хн8",
    ".хп8",
    ".хр8",
    ".хс8",
    ".хт8",
    ".хф8",
    ".хх8",
    ".хц8",
    ".хч8",
    ".хш8",
    ".хщ8",
    ".цб8",
    ".цв8",
    ".цг8",
    ".цд8",
    ".цж8",
    ".цз8",
    ".цк8",
    ".цл8",
    ".цм8",
    ".цн8",
    ".цп8",
    ".цр8",
    ".цс8",
    ".цт8",
    ".цф8",
    ".цх8",
    ".цц8",
    ".цч8",
    ".цш8",
    ".цщ8",
    ".чб8",
    ".чв8",
    ".чг8",
    ".чд8",
    ".чж8",
    ".чз8",
    ".чк8",
    ".чл8",
    ".чм8",
    ".чн8",
    ".чп8",
    ".чр8",
    ".чс8",
    ".чт8",
    ".чф8",
    ".чх8",
    ".чц8",
    ".чч8",
    ".чш8",
    ".чщ8",
    ".шб8",
    ".шв8",
    ".шг8",
    ".шд8",
    ".шж8",
    ".шз8",
    ".шк8",
    ".шл8",
    ".шм8",
    ".шн8",
    ".шп8",
    ".шр8",
    ".шс8",
    ".шт8",
    ".шф8",
    ".шх8",
    ".шц8",
    ".шч8",
    ".шш8",
    ".шщ8",
    ".щб8",
    ".щв8",
    ".щг8",
    ".щд8",
    ".щж8",
    ".щз8",
    ".щк8",
    ".щл8",
    ".щм8",
    ".щн8",
    ".щп8",
    ".щр8",
    ".щс8",
    ".щт8",
    ".щф8",
    ".щх8",
    ".щц8",
    ".щч8",
    ".щш8",
    ".щщ8",
    "а1",
    "4б3б4",
    "8бб.",
    "4ббб4",
    "ббв4",
    "ббг4",
    "ббд4",
    "ббж4",
    "ббз4",
    "4ббк4",
    "ббл4",
    "ббм4",
    "ббн4",
    "4ббп4",
    "ббр4",
    "ббс4",
    "4ббт4",
    "ббф4",
    "ббх4",
    "4ббц4",
    "4ббч4",
    "ббш4",
    "ббщ4",
    "2б3в",
    "8бв.",
    "4бвб4",
    "4бвв",
    "4бвг4",
    "4бвд4",
    "4бвк4",
    "4бвп4",
    "4бвт4",
    "4бвф",
    "4бвц4",
    "4бвч4",
    "2б3г",
    "8бг.",
    "4бгб4",
    "4бгг",
    "4бгк4",
    "4бгп4",
    "4бгт4",
    "4бгц4",
    "4бгч4",
    "2б3д",
    "8бд.",
    "4бдб4",
    "4бдг",
    "4бдд",
    "4бдк4",
    "4бдп4",
    "4бдт4",
    "4бдц4",
    "4бдч4",
    "2б3ж",
    "8бж.",
    "4бжб4",
    "4бжг4",
    "4бжд4",
    "4бжж",
    "4бжк4",
    "4бжп4",
    "4бжс",
    "4бжт4",
    "4бжф",
    "4бжх",
    "4бжц4",
    "4бжч4",
    "4бжш",
    "2б3з",
    "8бз.",
    "4бзб4",
    "4бзг4",
    "4бзд4",
    "4бзз",
    "4бзк4",
    "4бзп4",
    "4бзс",
    "4бзт4",
    "4бзф",
    "4бзх",
    "4бзц4",
    "4бзч4",
    "4бзш",
    "бй4",
    "4б3к4",
    "8бк.",
    "4бкб4",
    "бкв4",
    "4бкг4",
    "4бкд4",
    "бкж4",
    "бкз4",
    "4бкк4",
    "бкл4",
    "бкм4",
    "бкн4",
    "4бкп4",
    "бкр4",
    "бкс4",
    "4бкт4",
    "бкф4",
    "бкх4",
    "4бкц4",
    "4бкч4",
    "бкш4",
    "бкщ4",
    "2б3л4",
    "8бл.",
    "4блб4",
    "4блк4",
    "4блл",
    "4блп4",
    "4блт4",
    "4блц4",
    "4блч4",
    "2б3м4",
    "8бм.",
    "4бмб4",
    "4бмк4",
    "4бмм",
    "4бмп4",
    "4бмт4",
    "4бмц4",
    "4бмч4",
    "2б3н4",
    "8бн.",
    "4бнб4",
    "4бнк4",
    "4бнн",
    "4бнп4",
    "4бнт4",
    "4бнц4",
    "4бнч4",
    "4б3п4",
    "8бп.",
    "4бпб4",
    "бпв4",
    "4бпг4",
    "4бпд4",
    "бпж4",
    "бпз4",
    "4бпк4",
    "бпл4",
    "бпм4",
    "бпн4",
    "4бпп4",
    "бпр4",
    "бпс4",
    "4бпт4",
    "бпф4",
    "бпх4",
    "4бпц4",
    "4бпч4",
    "бпш4",
    "бпщ4",
    "2б3р4",
    "8бр.",
    "4брб4",
    "4брк4",
    "4брп4",
    "4брр",
    "4брт4",
    "4брц4",
    "4брч4",
    "4б3с",
    "8бс.",
    "4бсб4",
    "4бсг4",
    "4бсд4",
    "4бсж",
    "4бсз",
    "4бск4",
    "4бсп4",
    "4бсс",
    "4бст4",
    "4бсц4",
    "4бсч4",
    "4б3т4",
    "8бт.",
    "4бтб4",
    "бтв4",
    "4бтг4",
    "4бтд4",
    "бтж4",
    "бтз4",
    "4бтк4",
    "бтл4",
    "бтм4",
    "бтн4",
    "4бтп4",
    "бтр4",
    "бтс4",
    "4бтт4",
    "бтф4",
    "бтх4",
    "4бтц4",
    "4бтч4",
    "бтш4",
    "бтщ4",
    "4б3ф",
    "8бф.",
    "4бфб4",
    "4бфв",
    "4бфг4",
    "4бфд4",
    "4бфж",
    "4бфз",
    "4бфк4",
    "4бфп4",
    "4бфт4",
    "4бфф",
    "4бфц4",
    "4бфч4",
    "4б3х",
    "8бх.",
    "4бхб4",
    "4бхг4",
    "4бхд4",
    "4бхж",
    "4бхз",
    "4бхк4",
    "4бхп4",
    "4бхт4",
    "4бхх",
    "4бхц4",
    "4бхч4",
    "4б3ц4",
    "8бц.",
    "4бцб4",
    "бцв4",
    "4бцг4",
    "4бцд4",
    "бцж4",
    "бцз4",
    "4бцк4",
    "бцл4",
    "бцм4",
    "бцн4",
    "4бцп4",
    "бцр4",
    "бцс4",
    "4бцт4",
    "бцф4",
    "бцх4",
    "4бцц4",
    "4бцч4",
    "бцш4",
    "бцщ4",
    "4б3ч4",
    "8бч.",
    "4бчб4",
    "бчв4",
    "4бчг4",
    "4бчд4",
    "бчж4",
    "бчз4",
    "4бчк4",
    "бчл4",
    "бчм4",
    "бчн4",
    "4бчп4",
    "бчр4",
    "бчс4",
    "4бчт4",
    "бчф4",
    "бчх4",
    "4бчц4",
    "4бчч4",
    "бчш4",
    "бчщ4",
    "4б3ш",
    "8бш.",
    "4бшб4",
    "4бшг4",
    "4бшд4",
    "4бшж",
    "4бшз",
    "4бшк4",
    "4бшп4",
    "4бшт4",
    "4бшц4",
    "4бшч4",
    "4бшш",
    "4б3щ",
    "8бщ.",
    "4бщб4",
    "4бщк4",
    "4бщп4",
    "4бщт4",
    "4бщц4",
    "4бщч4",
    "4бщщ",
    "2в3б",
    "8вб.",
    "4вбб",
    "4вбв4",
    "4вбк",
    "4вбп",
    "4вбт",
    "4вбф4",
    "4вбц",
    "4вбч",
    "4в3в4",
    "8вв.",
    "ввб4",
    "4ввв4",
    "ввг4",
    "ввд4",
    "ввж4",
    "ввз4",
    "ввк4",
    "ввл4",
    "ввм4",
    "ввн4",
    "ввп4",
    "ввр4",
    "ввс4",
    "ввт4",
    "4ввф4",
    "ввх4",
    "ввц4",
    "ввч4",
    "ввш4",
    "ввщ4",
    "2в3г",
    "8вг.",
    "4вгв4",
    "4вгг",
    "4вгк",
    "4вгп",
    "4вгт",
    "4вгф4",
    "4вгц",
    "4вгч",
    "2в3д",
    "8вд.",
    "4вдб",
    "4вдв4",
    "4вдг",
    "4вдд",
    "4вдк",
    "4вдп",
    "4вдт",
    "4вдф4",
    "4вдц",
    "4вдч",
    "2в3ж",
    "8вж.",
    "4вжв4",
    "4вжж",
    "4вжс",
    "4вжф4",
    "4вжх",
    "4вжш",
    "2в3з",
    "8вз.",
    "4взв4",
    "4взз",
    "4взс",
    "4взф4",
    "4взх",
    "4взш",
    "вй4",
    "2в3к",
    "8вк.",
    "4вкб",
    "4вкв4",
    "4вкг",
    "4вкд",
    "4вкк",
    "4вкф4",
    "2в3л4",
    "8вл.",
    "4влв4",
    "4влл",
    "4влф4",
    "2в3м4",
    "8вм.",
    "4вмв4",
    "4вмм",
    "4вмф4",
    "2в3н4",
    "8вн.",
    "4внв4",
    "4внн",
    "4внф4",
    "2в3п",
    "8вп.",
    "4впб",
    "4впв4",
    "4впг",
    "4впд",
    "4впп",
    "4впф4",
    "2в3р4",
    "8вр.",
    "4врв4",
    "4врр",
    "4врф4",
    "2в3с",
    "8вс.",
    "4всв4",
    "4всж",
    "4всз",
    "4всс",
    "4всф4",
    "2в3т",
    "8вт.",
    "4втб",
    "4втв4",
    "4втг",
    "4втд",
    "4втк",
    "4втп",
    "4втт",
    "4втф4",
    "4втц",
    "4втч",
    "4в3ф4",
    "8вф.",
    "вфб4",
    "4вфв4",
    "вфг4",
    "вфд4",
    "4вфж4",
    "4вфз4",
    "вфк4",
    "вфл4",
    "вфм4",
    "вфн4",
    "вфп4",
    "вфр4",
    "вфс4",
    "вфт4",
    "4вфф4",
    "вфх4",
    "вфц4",
    "вфч4",
    "вфш4",
    "вфщ4",
    "2в3х",
    "8вх.",
    "4вхв4",
    "4вхж",
    "4вхз",
    "4вхф4",
    "4вхх",
    "2в3ц",
    "8вц.",
    "4вцб",
    "4вцв4",
    "4вцг",
    "4вцд",
    "4вцк",
    "4вцп",
    "4вцт",
    "4вцф4",
    "4вцц",
    "4вцч",
    "2в3ч",
    "8вч.",
    "4вчб",
    "4вчв4",
    "4вчг",
    "4вчд",
    "4вчк",
    "4вчп",
    "4вчт",
    "4вчф4",
    "4вчц",
    "4вчч",
    "2в3ш",
    "8вш.",
    "4вшв4",
    "4вшж",
    "4вшз",
    "4вшф4",
    "4вшш",
    "2в3щ",
    "8вщ.",
    "4вщв4",
    "4вщф4",
    "4вщщ",
    "2г3б",
    "8гб.",
    "4гбб",
    "4гбг4",
    "4гбк4",
    "4гбп4",
    "4гбт4",
    "4гбц4",
    "4гбч4",
    "2г3в",
    "8гв.",
    "4гвб4",
    "4гвв",
    "4гвг4",
    "4гвд4",
    "4гвк4",
    "4гвп4",
    "4гвт4",
    "4гвф",
    "4гвц4",
    "4гвч4",
    "4г3г4",
    "8гг.",
    "ггб4",
    "ггв4",
    "4ггг4",
    "ггд4",
    "ггж4",
    "ггз4",
    "4ггк4",
    "ггл4",
    "ггм4",
    "ггн4",
    "4ггп4",
    "ггр4",
    "ггс4",
    "4ггт4",
    "ггф4",
    "ггх4",
    "4ггц4",
    "4ггч4",
    "ггш4",
    "ггщ4",
    "2г3д",
    "8гд.",
    "4гдб",
    "4гдг4",
    "4гдд",
    "4гдк4",
    "4гдп4",
    "4гдт4",
    "4гдц4",
    "4гдч4",
    "2г3ж",
    "8гж.",
    "4гжб4",
    "4гжг4",
    "4гжд4",
    "4гжж",
    "4гжк4",
    "4гжп4",
    "4гжс",
    "4гжт4",
    "4гжф",
    "4гжх",
    "4гжц4",
    "4гжч4",
    "4гжш",
    "2г3з",
    "8гз.",
    "4гзб4",
    "4гзг4",
    "4гзд4",
    "4гзз",
    "4гзк4",
    "4гзп4",
    "4гзс",
    "4гзт4",
    "4гзф",
    "4гзх",
    "4гзц4",
    "4гзч4",
    "4гзш",
    "гй4",
    "4г3к4",
    "8гк.",
    "4гкб4",
    "гкв4",
    "4гкг4",
    "4гкд4",
    "гкж4",
    "гкз4",
    "4гкк4",
    "гкл4",
    "гкм4",
    "гкн4",
    "4гкп4",
    "гкр4",
    "гкс4",
    "4гкт4",
    "гкф4",
    "гкх4",
    "4гкц4",
    "4гкч4",
    "гкш4",
    "гкщ4",
    "2г3л4",
    "8гл.",
    "4глг4",
    "4глк4",
    "4глл",
    "4глп4",
    "4глт4",
    "4глц4",
    "4глч4",
    "2г3м4",
    "8гм.",
    "4гмг4",
    "4гмк4",
    "4гмм",
    "4гмп4",
    "4гмт4",
    "4гмц4",
    "4гмч4",
    "2г3н4",
    "8гн.",
    "4гнг4",
    "4гнк4",
    "4гнн",
    "4гнп4",
    "4гнт4",
    "4гнц4",
    "4гнч4",
    "4г3п4",
    "8гп.",
    "4гпб4",
    "гпв4",
    "4гпг4",
    "4гпд4",
    "гпж4",
    "гпз4",
    "4гпк4",
    "гпл4",
    "гпм4",
    "гпн4",
    "4гпп4",
    "гпр4",
    "гпс4",
    "4гпт4",
    "гпф4",
    "гпх4",
    "4гпц4",
    "4гпч4",
    "гпш4",
    "гпщ4",
    "2г3р4",
    "8гр.",
    "4грг4",
    "4грк4",
    "4грп4",
    "4грр",
    "4грт4",
    "4грц4",
    "4грч4",
    "4г3с",
    "8гс.",
    "4гсб4",
    "4гсг4",
    "4гсд4",
    "4гсж",
    "4гсз",
    "4гск4",
    "4гсп4",
    "4гсс",
    "4гст4",
    "4гсц4",
    "4гсч4",
    "4г3т4",
    "8гт.",
    "4гтб4",
    "гтв4",
    "4гтг4",
    "4гтд4",
    "гтж4",
    "гтз4",
    "4гтк4",
    "гтл4",
    "гтм4",
    "гтн4",
    "4гтп4",
    "гтр4",
    "гтс4",
    "4гтт4",
    "гтф4",
    "гтх4",
    "4гтц4",
    "4гтч4",
    "гтш4",
    "гтщ4",
    "4г3ф",
    "8гф.",
    "4гфб4",
    "4гфв",
    "4гфг4",
    "4гфд4",
    "4гфж",
    "4гфз",
    "4гфк4",
    "4гфп4",
    "4гфт4",
    "4гфф",
    "4гфц4",
    "4гфч4",
    "4г3х",
    "8гх.",
    "4гхб4",
    "4гхг4",
    "4гхд4",
    "4гхж",
    "4гхз",
    "4гхк4",
    "4гхп4",
    "4гхт4",
    "4гхх",
    "4гхц4",
    "4гхч4",
    "4г3ц4",
    "8гц.",
    "4гцб4",
    "гцв4",
    "4гцг4",
    "4гцд4",
    "гцж4",
    "гцз4",
    "4гцк4",
    "гцл4",
    "гцм4",
    "гцн4",
    "4гцп4",
    "гцр4",
    "гцс4",
    "4гцт4",
    "гцф4",
    "гцх4",
    "4гцц4",
    "4гцч4",
    "гцш4",
    "гцщ4",
    "4г3ч4",
    "8гч.",
    "4гчб4",
    "гчв4",
    "4гчг4",
    "4гчд4",
    "гчж4",
    "гчз4",
    "4гчк4",
    "гчл4",
    "гчм4",
    "гчн4",
    "4гчп4",
    "гчр4",
    "гчс4",
    "4гчт4",
    "гчф4",
    "гчх4",
    "4гчц4",
    "4гчч4",
    "гчш4",
    "гчщ4",
    "4г3ш",
    "8гш.",
    "4гшб4",
    "4гшг4",
    "4гшд4",
    "4гшж",
    "4гшз",
    "4гшк4",
    "4гшп4",
    "4гшт4",
    "4гшц4",
    "4гшч4",
    "4гшш",
    "4г3щ",
    "8гщ.",
    "4гщг4",
    "4гщк4",
    "4гщп4",
    "4гщт4",
    "4гщц4",
    "4гщч4",
    "4гщщ",
    "4д3б4",
    "8дб.",
    "4дбб4",
    "дбв4",
    "4дбг4",
    "4дбд4",
    "дбж4",
    "дбз4",
    "4дбк4",
    "дбл4",
    "дбм4",
    "дбн4",
    "4дбп4",
    "дбр4",
    "дбс4",
    "4дбт4",
    "дбф4",
    "дбх4",
    "4дбц4",
    "4дбч4",
    "дбш4",
    "дбщ4",
    "2д3в",
    "8дв.",
    "4двб4",
    "4двв",
    "4двг4",
    "4двд4",
    "4двк4",
    "4двп4",
    "4двт4",
    "4двф",
    "4двц4",
    "4двч4",
    "4д3г4",
    "8дг.",
    "4дгб4",
    "дгв4",
    "4дгг4",
    "4дгд4",
    "дгж4",
    "дгз4",
    "4дгк4",
    "дгл4",
    "дгм4",
    "дгн4",
    "4дгп4",
    "дгр4",
    "дгс4",
    "4дгт4",
    "дгф4",
    "дгх4",
    "4дгц4",
    "4дгч4",
    "дгш4",
    "дгщ4",
    "4д3д4",
    "8дд.",
    "4ддб4",
    "ддв4",
    "4ддг4",
    "4ддд4",
    "ддж4",
    "ддз4",
    "4ддк4",
    "ддл4",
    "ддм4",
    "ддн4",
    "4ддп4",
    "ддр4",
    "ддс4",
    "4ддт4",
    "ддф4",
    "ддх4",
    "4ддц4",
    "4ддч4",
    "ддш4",
    "ддщ4",
    "8дж.",
    "4джб4",
    "2джв",
    "4джг4",
    "4джд4",
    "4джж",
    "2джз",
    "4джк4",
    "2джл",
    "2джм",
    "2джн",
    "4джп4",
    "2джр",
    "4джс",
    "4джт4",
    "4джф",
    "4джх",
    "4джц4",
    "4джч4",
    "4джш",
    "2джщ",
    "8дз.",
    "4дзб4",
    "2дзв",
    "4дзг4",
    "4дзд4",
    "2дзж",
    "4дзз",
    "4дзк4",
    "2дзл",
    "2дзм",
    "2дзн",
    "4дзп4",
    "2дзр",
    "4дзс",
    "4дзт4",
    "4дзф",
    "4дзх",
    "4дзц4",
    "4дзч4",
    "4дзш",
    "2дзщ",
    "дй4",
    "4д3к4",
    "8дк.",
    "4дкб4",
    "дкв4",
    "4дкг4",
    "4дкд4",
    "дкж4",
    "дкз4",
    "4дкк4",
    "дкл4",
    "дкм4",
    "дкн4",
    "4дкп4",
    "дкр4",
    "дкс4",
    "4дкт4",
    "дкф4",
    "дкх4",
    "4дкц4",
    "4дкч4",
    "дкш4",
    "дкщ4",
    "2д3л4",
    "8дл.",
    "4длб4",
    "4длг4",
    "4длд4",
    "4длк4",
    "4длл",
    "4длп4",
    "4длт4",
    "4длц4",
    "4длч4",
    "2д3м4",
    "8дм.",
    "4дмб4",
    "4дмг4",
    "4дмд4",
    "4дмк4",
    "4дмм",
    "4дмп4",
    "4дмт4",
    "4дмц4",
    "4дмч4",
    "2д3н4",
    "8дн.",
    "4днб4",
    "4днг4",
    "4днд4",
    "4днк4",
    "4днн",
    "4днп4",
    "4днт4",
    "4днц4",
    "4днч4",
    "4д3п4",
    "8дп.",
    "4дпб4",
    "дпв4",
    "4дпг4",
    "4дпд4",
    "дпж4",
    "дпз4",
    "4дпк4",
    "дпл4",
    "дпм4",
    "дпн4",
    "4дпп4",
    "дпр4",
    "дпс4",
    "4дпт4",
    "дпф4",
    "дпх4",
    "4дпц4",
    "4дпч4",
    "дпш4",
    "дпщ4",
    "2д3р4",
    "8др.",
    "4дрб4",
    "4дрг4",
    "4дрд4",
    "4дрк4",
    "4дрп4",
    "4дрр",
    "4дрт4",
    "4дрц4",
    "4дрч4",
    "4д3с",
    "8дс.",
    "4дсб4",
    "4дсг4",
    "4дсд4",
    "4дсж",
    "4дсз",
    "4дск4",
    "4дсп4",
    "4дсс",
    "4дст4",
    "4дсц4",
    "4дсч4",
    "4д3т4",
    "8дт.",
    "4дтб4",
    "дтв4",
    "4дтг4",
    "4дтд4",
    "дтж4",
    "дтз4",
    "4дтк4",
    "дтл4",
    "дтм4",
    "дтн4",
    "4дтп4",
    "дтр4",
    "дтс4",
    "4дтт4",
    "дтф4",
    "дтх4",
    "4дтц4",
    "4дтч4",
    "дтш4",
    "дтщ4",
    "4д3ф",
    "8дф.",
    "4дфб4",
    "4дфв",
    "4дфг4",
    "4дфд4",
    "4дфж",
    "4дфз",
    "4дфк4",
    "4дфп4",
    "4дфт4",
    "4дфф",
    "4дфц4",
    "4дфч4",
    "4д3х",
    "8дх.",
    "4дхб4",
    "4дхг4",
    "4дхд4",
    "4дхж",
    "4дхз",
    "4дхк4",
    "4дхп4",
    "4дхт4",
    "4дхх",
    "4дхц4",
    "4дхч4",
    "4д3ц4",
    "8дц.",
    "4дцб4",
    "дцв4",
    "4дцг4",
    "4дцд4",
    "дцж4",
    "дцз4",
    "4дцк4",
    "дцл4",
    "дцм4",
    "дцн4",
    "4дцп4",
    "дцр4",
    "дцс4",
    "4дцт4",
    "дцф4",
    "дцх4",
    "4дцц4",
    "4дцч4",
    "дцш4",
    "дцщ4",
    "4д3ч4",
    "8дч.",
    "4дчб4",
    "дчв4",
    "4дчг4",
    "4дчд4",
    "дчж4",
    "дчз4",
    "4дчк4",
    "дчл4",
    "дчм4",
    "дчн4",
    "4дчп4",
    "дчр4",
    "дчс4",
    "4дчт4",
    "дчф4",
    "дчх4",
    "4дчц4",
    "4дчч4",
    "дчш4",
    "дчщ4",
    "4д3ш",
    "8дш.",
    "4дшб4",
    "4дшг4",
    "4дшд4",
    "4дшж",
    "4дшз",
    "4дшк4",
    "4дшп4",
    "4дшт4",
    "4дшц4",
    "4дшч4",
    "4дшш",
    "4д3щ",
    "8дщ.",
    "4дщб4",
    "4дщг4",
    "4дщд4",
    "4дщк4",
    "4дщп4",
    "4дщт4",
    "4дщц4",
    "4дщч4",
    "4дщщ",
    "е1",
    "2ж3б",
    "8жб.",
    "4жбб",
    "4жбж4",
    "4жбз4",
    "4жбк",
    "4жбп",
    "4жбс4",
    "4жбт",
    "4жбф4",
    "4жбх4",
    "4жбц",
    "4жбч",
    "4жбш4",
    "2ж3в",
    "8жв.",
    "4жвв",
    "4жвж4",
    "4жвс4",
    "4жвф4",
    "4жвх4",
    "4жвш4",
    "2ж3г",
    "8жг.",
    "4жгг",
    "4жгж4",
    "4жгз4",
    "4жгк",
    "4жгп",
    "4жгс4",
    "4жгт",
    "4жгф4",
    "4жгх4",
    "4жгц",
    "4жгч",
    "4жгш4",
    "2ж3д",
    "8жд.",
    "4ждб",
    "4ждг",
    "4ждд",
    "4ждж4",
    "4ждз4",
    "4ждк",
    "4ждп",
    "4ждс4",
    "4ждт",
    "4ждф4",
    "4ждх4",
    "4ждц",
    "4ждч",
    "4ждш4",
    "4ж3ж4",
    "8жж.",
    "жжб4",
    "жжв4",
    "жжг4",
    "жжд4",
    "4жжж4",
    "жжз4",
    "жжк4",
    "жжл4",
    "жжм4",
    "жжн4",
    "жжп4",
    "жжр4",
    "4жжс4",
    "жжт4",
    "4жжф4",
    "4жжх4",
    "жжц4",
    "жжч4",
    "4жжш4",
    "жжщ4",
    "2ж3з",
    "8жз.",
    "4жзж4",
    "4жзз",
    "4жзс4",
    "4жзф4",
    "4жзх4",
    "4жзш4",
    "жй4",
    "4ж3к",
    "8жк.",
    "4жкб",
    "4жкг",
    "4жкд",
    "4жкж4",
    "4жкз4",
    "4жкк",
    "4жкс4",
    "4жкф4",
    "4жкх4",
    "4жкш4",
    "2ж3л4",
    "8жл.",
    "4жлж4",
    "4жлл",
    "4жлс4",
    "4жлф4",
    "4жлх4",
    "4жлш4",
    "2ж3м4",
    "8жм.",
    "4жмж4",
    "4жмм",
    "4жмс4",
    "4жмф4",
    "4жмх4",
    "4жмш4",
    "2ж3н4",
    "8жн.",
    "4жнж4",
    "4жнн",
    "4жнс4",
    "4жнф4",
    "4жнх4",
    "4жнш4",
    "4ж3п",
    "8жп.",
    "4жпб",
    "4жпг",
    "4жпд",
    "4жпж4",
    "4жпз4",
    "4жпп",
    "4жпс4",
    "4жпф4",
    "4жпх4",
    "4жпш4",
    "2ж3р4",
    "8жр.",
    "4жрж4",
    "4жрр",
    "4жрс4",
    "4жрф4",
    "4жрх4",
    "4жрш4",
    "4ж3с4",
    "8жс.",
    "жсб4",
    "жсв4",
    "жсг4",
    "жсд4",
    "4жсж4",
    "4жсз4",
    "жск4",
    "жсл4",
    "жсм4",
    "жсн4",
    "жсп4",
    "жср4",
    "4жсс4",
    "жст4",
    "4жсф4",
    "4жсх4",
    "жсц4",
    "жсч4",
    "4жсш4",
    "жсщ4",
    "4ж3т",
    "8жт.",
    "4жтб",
    "4жтг",
    "4жтд",
    "4жтж4",
    "4жтз4",
    "4жтк",
    "4жтп",
    "4жтс4",
    "4жтт",
    "4жтф4",
    "4жтх4",
    "4жтц",
    "4жтч",
    "4жтш4",
    "4ж3ф4",
    "8жф.",
    "жфб4",
    "4жфв4",
    "жфг4",
    "жфд4",
    "4жфж4",
    "4жфз4",
    "жфк4",
    "жфл4",
    "жфм4",
    "жфн4",
    "жфп4",
    "жфр4",
    "4жфс4",
    "жфт4",
    "4жфф4",
    "4жфх4",
    "жфц4",
    "жфч4",
    "4жфш4",
    "жфщ4",
    "4ж3х4",
    "8жх.",
    "жхб4",
    "жхв4",
    "жхг4",
    "жхд4",
    "4жхж4",
    "4жхз4",
    "жхк4",
    "жхл4",
    "жхм4",
    "жхн4",
    "жхп4",
    "жхр4",
    "4жхс4",
    "жхт4",
    "4жхф4",
    "4жхх4",
    "жхц4",
    "жхч4",
    "4жхш4",
    "жхщ4",
    "4ж3ц",
    "8жц.",
    "4жцб",
    "4жцг",
    "4жцд",
    "4жцж4",
    "4жцз4",
    "4жцк",
    "4жцп",
    "4жцс4",
    "4жцт",
    "4жцф4",
    "4жцх4",
    "4жцц",
    "4жцч",
    "4жцш4",
    "4ж3ч",
    "8жч.",
    "4жчб",
    "4жчг",
    "4жчд",
    "4жчж4",
    "4жчз4",
    "4жчк",
    "4жчп",
    "4жчс4",
    "4жчт",
    "4жчф4",
    "4жчх4",
    "4жчц",
    "4жчч",
    "4жчш4",
    "4ж3ш4",
    "8жш.",
    "жшб4",
    "жшв4",
    "жшг4",
    "жшд4",
    "4жшж4",
    "4жшз4",
    "жшк4",
    "жшл4",
    "жшм4",
    "жшн4",
    "жшп4",
    "жшр4",
    "4жшс4",
    "жшт4",
    "4жшф4",
    "4жшх4",
    "жшц4",
    "жшч4",
    "4жшш4",
    "жшщ4",
    "4ж3щ",
    "8жщ.",
    "4жщж4",
    "4жщс4",
    "4жщф4",
    "4жщх4",
    "4жщш4",
    "4жщщ",
    "2з3б",
    "8зб.",
    "4збб",
    "4збж4",
    "4збз4",
    "4збк",
    "4збп",
    "4збс4",
    "4збт",
    "4збф4",
    "4збх4",
    "4збц",
    "4збч",
    "4збш4",
    "2з3в",
    "8зв.",
    "4звв",
    "4звз4",
    "4звс4",
    "4звф4",
    "4звх4",
    "4звш4",
    "2з3г",
    "8зг.",
    "4згг",
    "4згж4",
    "4згз4",
    "4згк",
    "4згп",
    "4згс4",
    "4згт",
    "4згф4",
    "4згх4",
    "4згц",
    "4згч",
    "4згш4",
    "2з3д",
    "8зд.",
    "4здб",
    "4здг",
    "4здд",
    "4здж4",
    "4здз4",
    "4здк",
    "4здп",
    "4здс4",
    "4здт",
    "4здф4",
    "4здх4",
    "4здц",
    "4здч",
    "4здш4",
    "2з3ж",
    "8зж.",
    "4зжж",
    "4зжз4",
    "4зжс4",
    "4зжф4",
    "4зжх4",
    "4зжш4",
    "4з3з4",
    "8зз.",
    "ззб4",
    "ззв4",
    "ззг4",
    "ззд4",
    "ззж4",
    "4ззз4",
    "ззк4",
    "ззл4",
    "ззм4",
    "ззн4",
    "ззп4",
    "ззр4",
    "4ззс4",
    "ззт4",
    "4ззф4",
    "4ззх4",
    "ззц4",
    "ззч4",
    "4ззш4",
    "ззщ4",
    "зй4",
    "4з3к",
    "8зк.",
    "4зкб",
    "4зкг",
    "4зкд",
    "4зкж4",
    "4зкз4",
    "4зкк",
    "4зкс4",
    "4зкф4",
    "4зкх4",
    "4зкш4",
    "2з3л4",
    "8зл.",
    "4злз4",
    "4злл",
    "4злс4",
    "4злф4",
    "4злх4",
    "4злш4",
    "2з3м4",
    "8зм.",
    "4змз4",
    "4змм",
    "4змс4",
    "4змф4",
    "4змх4",
    "4змш4",
    "2з3н4",
    "8зн.",
    "4знз4",
    "4знн",
    "4знс4",
    "4знф4",
    "4знх4",
    "4знш4",
    "4з3п",
    "8зп.",
    "4зпб",
    "4зпг",
    "4зпд",
    "4зпж4",
    "4зпз4",
    "4зпп",
    "4зпс4",
    "4зпф4",
    "4зпх4",
    "4зпш4",
    "2з3р4",
    "8зр.",
    "4зрз4",
    "4зрр",
    "4зрс4",
    "4зрф4",
    "4зрх4",
    "4зрш4",
    "4з3с4",
    "8зс.",
    "зсб4",
    "зсв4",
    "зсг4",
    "зсд4",
    "4зсж4",
    "4зсз4",
    "зск4",
    "зсл4",
    "зсм4",
    "зсн4",
    "зсп4",
    "зср4",
    "4зсс4",
    "зст4",
    "4зсф4",
    "4зсх4",
    "зсц4",
    "зсч4",
    "4зсш4",
    "зсщ4",
    "4з3т",
    "8зт.",
    "4зтб",
    "4зтг",
    "4зтд",
    "4зтж4",
    "4зтз4",
    "4зтк",
    "4зтп",
    "4зтс4",
    "4зтт",
    "4зтф4",
    "4зтх4",
    "4зтц",
    "4зтч",
    "4зтш4",
    "4з3ф4",
    "8зф.",
    "зфб4",
    "4зфв4",
    "зфг4",
    "зфд4",
    "4зфж4",
    "4зфз4",
    "зфк4",
    "зфл4",
    "зфм4",
    "зфн4",
    "зфп4",
    "зфр4",
    "4зфс4",
    "зфт4",
    "4зфф4",
    "4зфх4",
    "зфц4",
    "зфч4",
    "4зфш4",
    "зфщ4",
    "4з3х4",
    "8зх.",
    "зхб4",
    "зхв4",
    "зхг4",
    "зхд4",
    "4зхж4",
    "4зхз4",
    "зхк4",
    "зхл4",
    "зхм4",
    "зхн4",
    "зхп4",
    "зхр4",
    "4зхс4",
    "зхт4",
    "4зхф4",
    "4зхх4",
    "зхц4",
    "зхч4",
    "4зхш4",
    "зхщ4",
    "4з3ц",
    "8зц.",
    "4зцб",
    "4зцг",
    "4зцд",
    "4зцж4",
    "4зцз4",
    "4зцк",
    "4зцп",
    "4зцс4",
    "4зцт",
    "4зцф4",
    "4зцх4",
    "4зцц",
    "4зцч",
    "4зцш4",
    "4з3ч",
    "8зч.",
    "4зчб",
    "4зчг",
    "4зчд",
    "4зчж4",
    "4зчз4",
    "4зчк",
    "4зчп",
    "4зчс4",
    "4зчт",
    "4зчф4",
    "4зчх4",
    "4зчц",
    "4зчч",
    "4зчш4",
    "4з3ш4",
    "8зш.",
    "зшб4",
    "зшв4",
    "зшг4",
    "зшд4",
    "4зшж4",
    "4зшз4",
    "зшк4",
    "зшл4",
    "зшм4",
    "зшн4",
    "зшп4",
    "зшр4",
    "4зшс4",
    "зшт4",
    "4зшф4",
    "4зшх4",
    "зшц4",
    "зшч4",
    "4зшш4",
    "зшщ4",
    "4з3щ",
    "8зщ.",
    "4зщз4",
    "4зщс4",
    "4зщф4",
    "4зщх4",
    "4зщш4",
    "4зщщ",
    "и1",
    "4й1б",
    "4й1в",
    "4й1г",
    "4й1д",
    "4й1ж",
    "4й1з",
    "4й1к",
    "4й1л",
    "4й1м",
    "4й1н",
    "4й1п",
    "4й1р",
    "4й1с",
    "4й1т",
    "4й1ф",
    "4й1х",
    "4й1ц",
    "4й1ч",
    "4й1ш",
    "4й1щ",
    "4к3б4",
    "8кб.",
    "4кбб4",
    "кбв4",
    "4кбг4",
    "4кбд4",
    "кбж4",
    "кбз4",
    "4кбк4",
    "кбл4",
    "кбм4",
    "кбн4",
    "4кбп4",
    "кбр4",
    "кбс4",
    "4кбт4",
    "кбф4",
    "кбх4",
    "4кбц4",
    "4кбч4",
    "кбш4",
    "кбщ4",
    "2к3в4",
    "8кв.",
    "4квб4",
    "4квв",
    "4квг4",
    "4квд4",
    "4квк4",
    "4квп4",
    "4квт4",
    "4квф",
    "4квц4",
    "4квч4",
    "4к3г4",
    "8кг.",
    "4кгб4",
    "кгв4",
    "4кгг4",
    "4кгд4",
    "кгж4",
    "кгз4",
    "4кгк4",
    "кгл4",
    "кгм4",
    "кгн4",
    "4кгп4",
    "кгр4",
    "кгс4",
    "4кгт4",
    "кгф4",
    "кгх4",
    "4кгц4",
    "4кгч4",
    "кгш4",
    "кгщ4",
    "4к3д4",
    "8кд.",
    "4кдб4",
    "кдв4",
    "4кдг4",
    "4кдд4",
    "кдж4",
    "кдз4",
    "4кдк4",
    "кдл4",
    "кдм4",
    "кдн4",
    "4кдп4",
    "кдр4",
    "кдс4",
    "4кдт4",
    "кдф4",
    "кдх4",
    "4кдц4",
    "4кдч4",
    "кдш4",
    "кдщ4",
    "2к3ж4",
    "8кж.",
    "4кжб4",
    "4кжг4",
    "4кжд4",
    "4кжж",
    "4кжк4",
    "4кжп4",
    "4кжс",
    "4кжт4",
    "4кжф",
    "4кжх",
    "4кжц4",
    "4кжч4",
    "4кжш",
    "2к3з4",
    "8кз.",
    "4кзб4",
    "4кзг4",
    "4кзд4",
    "4кзз",
    "4кзк4",
    "4кзп4",
    "4кзс",
    "4кзт4",
    "4кзф",
    "4кзх",
    "4кзц4",
    "4кзч4",
    "4кзш",
    "кй4",
    "4к3к4",
    "8кк.",
    "4ккб4",
    "ккв4",
    "4ккг4",
    "4ккд4",
    "ккж4",
    "ккз4",
    "4ккк4",
    "ккл4",
    "ккм4",
    "ккн4",
    "ккп4",
    "ккр4",
    "ккс4",
    "ккт4",
    "ккф4",
    "ккх4",
    "ккц4",
    "ккч4",
    "ккш4",
    "ккщ4",
    "2к3л4",
    "8кл.",
    "4клб4",
    "4клг4",
    "4клд4",
    "4клк4",
    "4клл",
    "2к3м4",
    "8км.",
    "4кмб4",
    "4кмг4",
    "4кмд4",
    "4кмк4",
    "4кмм",
    "2к3н4",
    "8кн.",
    "4кнб4",
    "4кнг4",
    "4кнд4",
    "4кнк4",
    "4кнн",
    "2к3п",
    "8кп.",
    "4кпб4",
    "4кпг4",
    "4кпд4",
    "4кпк4",
    "4кпп",
    "2к3р4",
    "8кр.",
    "4крб4",
    "4крг4",
    "4крд4",
    "4крк4",
    "4крр",
    "2к3с",
    "8кс.",
    "4ксб4",
    "4ксг4",
    "4ксд4",
    "4ксж",
    "4ксз",
    "4кск4",
    "4ксп4",
    "4ксс",
    "4кст4",
    "4ксц4",
    "4ксч4",
    "2к3т",
    "8кт.",
    "4ктб4",
    "4ктг4",
    "4ктд4",
    "4ктк4",
    "4ктп",
    "4ктт",
    "4ктц",
    "4ктч",
    "2к3ф",
    "8кф.",
    "4кфб4",
    "4кфв",
    "4кфг4",
    "4кфд4",
    "4кфж",
    "4кфз",
    "4кфк4",
    "4кфп4",
    "4кфт4",
    "4кфф",
    "4кфц4",
    "4кфч4",
    "2к3х",
    "8кх.",
    "4кхб4",
    "4кхг4",
    "4кхд4",
    "4кхж",
    "4кхз",
    "4кхк4",
    "4кхп4",
    "4кхт4",
    "4кхх",
    "4кхц4",
    "4кхч4",
    "2к3ц",
    "8кц.",
    "4кцб4",
    "4кцг4",
    "4кцд4",
    "4кцк4",
    "4кцп",
    "4кцт",
    "4кцц",
    "4кцч",
    "2к3ч",
    "8кч.",
    "4кчб4",
    "4кчг4",
    "4кчд4",
    "4кчк4",
    "4кчп",
    "4кчт",
    "4кчц",
    "4кчч",
    "2к3ш",
    "8кш.",
    "4кшб4",
    "4кшг4",
    "4кшд4",
    "4кшж",
    "4кшз",
    "4кшк4",
    "4кшп4",
    "4кшт4",
    "4кшц4",
    "4кшч4",
    "4кшш",
    "2к3щ",
    "8кщ.",
    "4кщб4",
    "4кщг4",
    "4кщд4",
    "4кщк4",
    "4кщщ",
    "4л3б",
    "8лб.",
    "4лбб",
    "4лбк",
    "4лбл4",
    "4лбп",
    "4лбт",
    "4лбц",
    "4лбч",
    "4л3в",
    "8лв.",
    "4лвв",
    "4лвл4",
    "4лвф",
    "4л3г",
    "8лг.",
    "4лгг",
    "4лгк",
    "4лгл4",
    "4лгп",
    "4лгт",
    "4лгц",
    "4лгч",
    "4л3д",
    "8лд.",
    "4лдб",
    "4лдг",
    "4лдд",
    "4лдк",
    "4лдл4",
    "4лдп",
    "4лдт",
    "4лдц",
    "4лдч",
    "4л3ж",
    "8лж.",
    "4лжж",
    "4лжл4",
    "4лжс",
    "4лжф",
    "4лжх",
    "4лжш",
    "4л3з",
    "8лз.",
    "4лзз",
    "4лзл4",
    "4лзс",
    "4лзф",
    "4лзх",
    "4лзш",
    "4л3к",
    "8лк.",
    "4лкб",
    "4лкг",
    "4лкд",
    "4лкк",
    "4лкл4",
    "4л3л4",
    "8лл.",
    "ллб4",
    "ллв4",
    "ллг4",
    "ллд4",
    "ллж4",
    "ллз4",
    "ллк4",
    "4ллл4",
    "ллм4",
    "ллн4",
    "ллп4",
    "ллр4",
    "ллс4",
    "ллт4",
    "ллф4",
    "ллх4",
    "ллц4",
    "ллч4",
    "ллш4",
    "ллщ4",
    "4л3м",
    "8лм.",
    "4лмл4",
    "4лмм",
    "4л3н",
    "8лн.",
    "4лнл4",
    "4лнн",
    "4л3п",
    "8лп.",
    "4лпб",
    "4лпг",
    "4лпд",
    "4лпл4",
    "4лпп",
    "2л3р4",
    "8лр.",
    "4лрл4",
    "4лрр",
    "4л3с",
    "8лс.",
    "4лсж",
    "4лсз",
    "4лсл4",
    "4лсс",
    "4л3т",
    "8лт.",
    "4лтб",
    "4лтг",
    "4лтд",
    "4лтк",
    "4лтл4",
    "4лтп",
    "4лтт",
    "4лтц",
    "4лтч",
    "4л3ф",
    "8лф.",
    "4лфв",
    "4лфж",
    "4лфз",
    "4лфл4",
    "4лфф",
    "4л3х",
    "8лх.",
    "4лхж",
    "4лхз",
    "4лхл4",
    "4лхх",
    "4л3ц",
    "8лц.",
    "4лцб",
    "4лцг",
    "4лцд",
    "4лцк",
    "4лцл4",
    "4лцп",
    "4лцт",
    "4лцц",
    "4лцч",
    "4л3ч",
    "8лч.",
    "4лчб",
    "4лчг",
    "4лчд",
    "4лчк",
    "4лчл4",
    "4лчп",
    "4лчт",
    "4лчц",
    "4лчч",
    "4л3ш",
    "8лш.",
    "4лшж",
    "4лшз",
    "4лшл4",
    "4лшш",
    "4л3щ",
    "8лщ.",
    "4лщл4",
    "4лщщ",
    "4м3б",
    "8мб.",
    "4мбб",
    "4мбк",
    "4мбм4",
    "4мбп",
    "4мбт",
    "4мбц",
    "4мбч",
    "4м3в",
    "8мв.",
    "4мвв",
    "4мвм4",
    "4мвф",
    "4м3г",
    "8мг.",
    "4мгг",
    "4мгк",
    "4мгм4",
    "4мгп",
    "4мгт",
    "4мгц",
    "4мгч",
    "4м3д",
    "8мд.",
    "4мдб",
    "4мдг",
    "4мдд",
    "4мдк",
    "4мдм4",
    "4мдп",
    "4мдт",
    "4мдц",
    "4мдч",
    "4м3ж",
    "8мж.",
    "4мжж",
    "4мжм4",
    "4мжс",
    "4мжф",
    "4мжх",
    "4мжш",
    "4м3з",
    "8мз.",
    "4мзз",
    "4мзм4",
    "4мзс",
    "4мзф",
    "4мзх",
    "4мзш",
    "4м3к",
    "8мк.",
    "4мкб",
    "4мкг",
    "4мкд",
    "4мкк",
    "4мкм4",
    "2м3л4",
    "8мл.",
    "4млл",
    "4млм4",
    "4м3м4",
    "8мм.",
    "ммб4",
    "ммв4",
    "ммг4",
    "ммд4",
    "ммж4",
    "ммз4",
    "ммк4",
    "ммл4",
    "4ммм4",
    "ммн4",
    "ммп4",
    "ммр4",
    "ммс4",
    "ммт4",
    "ммф4",
    "ммх4",
    "ммц4",
    "ммч4",
    "ммш4",
    "ммщ4",
    "2м3н4",
    "8мн.",
    "4мнм4",
    "4мнн",
    "4м3п",
    "8мп.",
    "4мпб",
    "4мпг",
    "4мпд",
    "4мпм4",
    "4мпп",
    "2м3р4",
    "8мр.",
    "4мрм4",
    "4мрр",
    "4м3с",
    "8мс.",
    "4мсж",
    "4мсз",
    "4мсм4",
    "4мсс",
    "4м3т",
    "8мт.",
    "4мтб",
    "4мтг",
    "4мтд",
    "4мтк",
    "4мтм4",
    "4мтп",
    "4мтт",
    "4мтц",
    "4мтч",
    "4м3ф",
    "8мф.",
    "4мфв",
    "4мфж",
    "4мфз",
    "4мфм4",
    "4мфф",
    "4м3х",
    "8мх.",
    "4мхж",
    "4мхз",
    "4мхм4",
    "4мхх",
    "4м3ц",
    "8мц.",
    "4мцб",
    "4мцг",
    "4мцд",
    "4мцк",
    "4мцм4",
    "4мцп",
    "4мцт",
    "4мцц",
    "4мцч",
    "4м3ч",
    "8мч.",
    "4мчб",
    "4мчг",
    "4мчд",
    "4мчк",
    "4мчм4",
    "4мчп",
    "4мчт",
    "4мчц",
    "4мчч",
    "4м3ш",
    "8мш.",
    "4мшж",
    "4мшз",
    "4мшм4",
    "4мшш",
    "4м3щ",
    "8мщ.",
    "4мщм4",
    "4мщщ",
    "на2д3з",
    "4н3б",
    "8нб.",
    "4нбб",
    "4нбк",
    "4нбн4",
    "4нбп",
    "4нбт",
    "4нбц",
    "4нбч",
    "4н3в",
    "8нв.",
    "4нвв",
    "4нвн4",
    "4нвф",
    "4н3г",
    "8нг.",
    "4нгг",
    "4нгк",
    "4нгн4",
    "4нгп",
    "4нгт",
    "4нгц",
    "4нгч",
    "4н3д",
    "8нд.",
    "4ндб",
    "4ндг",
    "4ндд",
    "4ндк",
    "4ндн4",
    "4ндп",
    "4ндт",
    "4ндц",
    "4ндч",
    "4н3ж",
    "8нж.",
    "4нжж",
    "4нжн4",
    "4нжс",
    "4нжф",
    "4нжх",
    "4нжш",
    "4н3з",
    "8нз.",
    "4нзз",
    "4нзн4",
    "4нзс",
    "4нзф",
    "4нзх",
    "4нзш",
    "4н3к",
    "8нк.",
    "4нкб",
    "4нкг",
    "4нкд",
    "4нкк",
    "4нкн4",
    "2н3л4",
    "8нл.",
    "4нлл",
    "4нлн4",
    "4н3м",
    "8нм.",
    "4нмм",
    "4нмн4",
    "4н3н4",
    "8нн.",
    "ннб4",
    "ннв4",
    "ннг4",
    "ннд4",
    "ннж4",
    "ннз4",
    "ннк4",
    "ннл4",
    "ннм4",
    "4ннн4",
    "ннп4",
    "ннр4",
    "ннс4",
    "ннт4",
    "ннф4",
    "ннх4",
    "ннц4",
    "ннч4",
    "ннш4",
    "ннщ4",
    "4н3п",
    "8нп.",
    "4нпб",
    "4нпг",
    "4нпд",
    "4нпн4",
    "4нпп",
    "2н3р4",
    "8нр.",
    "4нрн4",
    "4нрр",
    "4н3с",
    "8нс.",
    "4нсж",
    "4нсз",
    "4нсн4",
    "4нсс",
    "4н3т",
    "8нт.",
    "4нтб",
    "4нтг",
    "4нтд",
    "4нтк",
    "4нтн4",
    "4нтп",
    "4нтт",
    "4нтц",
    "4нтч",
    "4н3ф",
    "8нф.",
    "4нфв",
    "4нфж",
    "4нфз",
    "4нфн4",
    "4нфф",
    "4н3х",
    "8нх.",
    "4нхж",
    "4нхз",
    "4нхн4",
    "4нхх",
    "4н3ц",
    "8нц.",
    "4нцб",
    "4нцг",
    "4нцд",
    "4нцк",
    "4нцн4",
    "4нцп",
    "4нцт",
    "4нцц",
    "4нцч",
    "4н3ч",
    "8нч.",
    "4нчб",
    "4нчг",
    "4нчд",
    "4нчк",
    "4нчн4",
    "4нчп",
    "4нчт",
    "4нчц",
    "4нчч",
    "4н3ш",
    "8нш.",
    "4ншж",
    "4ншз",
    "4ншн4",
    "4ншш",
    "4н3щ",
    "8нщ.",
    "4нщн4",
    "4нщщ",
    "о1",
    "4п3б4",
    "8пб.",
    "4пбб4",
    "пбв4",
    "4пбг4",
    "4пбд4",
    "пбж4",
    "пбз4",
    "4пбк4",
    "пбл4",
    "пбм4",
    "пбн4",
    "4пбп4",
    "пбр4",
    "пбс4",
    "4пбт4",
    "пбф4",
    "пбх4",
    "4пбц4",
    "4пбч4",
    "пбш4",
    "пбщ4",
    "2п3в4",
    "8пв.",
    "4пвб4",
    "4пвв",
    "4пвг4",
    "4пвд4",
    "4пвк4",
    "4пвп4",
    "4пвт4",
    "4пвф",
    "4пвц4",
    "4пвч4",
    "4п3г4",
    "8пг.",
    "4пгб4",
    "пгв4",
    "4пгг4",
    "4пгд4",
    "пгж4",
    "пгз4",
    "4пгк4",
    "пгл4",
    "пгм4",
    "пгн4",
    "4пгп4",
    "пгр4",
    "пгс4",
    "4пгт4",
    "пгф4",
    "пгх4",
    "4пгц4",
    "4пгч4",
    "пгш4",
    "пгщ4",
    "4п3д4",
    "8пд.",
    "4пдб4",
    "пдв4",
    "4пдг4",
    "4пдд4",
    "пдж4",
    "пдз4",
    "4пдк4",
    "пдл4",
    "пдм4",
    "пдн4",
    "4пдп4",
    "пдр4",
    "пдс4",
    "4пдт4",
    "пдф4",
    "пдх4",
    "4пдц4",
    "4пдч4",
    "пдш4",
    "пдщ4",
    "2п3ж4",
    "8пж.",
    "4пжб4",
    "4пжг4",
    "4пжд4",
    "4пжж",
    "4пжк4",
    "4пжп4",
    "4пжс",
    "4пжт4",
    "4пжф",
    "4пжх",
    "4пжц4",
    "4пжч4",
    "4пжш",
    "2п3з4",
    "8пз.",
    "4пзб4",
    "4пзг4",
    "4пзд4",
    "4пзз",
    "4пзк4",
    "4пзп4",
    "4пзс",
    "4пзт4",
    "4пзф",
    "4пзх",
    "4пзц4",
    "4пзч4",
    "4пзш",
    "пй4",
    "2п3к",
    "8пк.",
    "4пкб4",
    "4пкг4",
    "4пкд4",
    "4пкк",
    "4пкп4",
    "2п3л4",
    "8пл.",
    "4плб4",
    "4плг4",
    "4плд4",
    "4плл",
    "4плп4",
    "2п3м4",
    "8пм.",
    "4пмб4",
    "4пмг4",
    "4пмд4",
    "4пмм",
    "4пмп4",
    "2п3н4",
    "8пн.",
    "4пнб4",
    "4пнг4",
    "4пнд4",
    "4пнн",
    "4пнп4",
    "по2д3з",
    "4п3п4",
    "8пп.",
    "4ппб4",
    "ппв4",
    "4ппг4",
    "4ппд4",
    "ппж4",
    "ппз4",
    "ппк4",
    "ппл4",
    "ппм4",
    "ппн4",
    "4ппп4",
    "ппр4",
    "ппс4",
    "ппт4",
    "ппф4",
    "ппх4",
    "ппц4",
    "ппч4",
    "ппш4",
    "ппщ4",
    "2п3р4",
    "8пр.",
    "4прб4",
    "4прг4",
    "4прд4",
    "пре2д2ж",
    "пре2д3з",
    "4прп4",
    "4прр",
    "2п3с",
    "8пс.",
    "4псб4",
    "4псг4",
    "4псд4",
    "4псж",
    "4псз",
    "4пск4",
    "4псп4",
    "4псс",
    "4пст4",
    "4псц4",
    "4псч4",
    "2п3т",
    "8пт.",
    "4птб4",
    "4птг4",
    "4птд4",
    "4птк",
    "4птп4",
    "4птт",
    "4птц",
    "4птч",
    "2п3ф",
    "8пф.",
    "4пфб4",
    "4пфв",
    "4пфг4",
    "4пфд4",
    "4пфж",
    "4пфз",
    "4пфк4",
    "4пфп4",
    "4пфт4",
    "4пфф",
    "4пфц4",
    "4пфч4",
    "2п3х",
    "8пх.",
    "4пхб4",
    "4пхг4",
    "4пхд4",
    "4пхж",
    "4пхз",
    "4пхк4",
    "4пхп4",
    "4пхт4",
    "4пхх",
    "4пхц4",
    "4пхч4",
    "2п3ц",
    "8пц.",
    "4пцб4",
    "4пцг4",
    "4пцд4",
    "4пцк",
    "4пцп4",
    "4пцт",
    "4пцц",
    "4пцч",
    "2п3ч",
    "8пч.",
    "4пчб4",
    "4пчг4",
    "4пчд4",
    "4пчк",
    "4пчп4",
    "4пчт",
    "4пчц",
    "4пчч",
    "2п3ш",
    "8пш.",
    "4пшб4",
    "4пшг4",
    "4пшд4",
    "4пшж",
    "4пшз",
    "4пшк4",
    "4пшп4",
    "4пшт4",
    "4пшц4",
    "4пшч4",
    "4пшш",
    "2п3щ",
    "8пщ.",
    "4пщб4",
    "4пщг4",
    "4пщд4",
    "4пщп4",
    "4пщщ",
    "4р3б",
    "8рб.",
    "4рбб",
    "4рбк",
    "4рбп",
    "4рбр4",
    "4рбт",
    "4рбц",
    "4рбч",
    "4р3в",
    "8рв.",
    "4рвв",
    "4рвр4",
    "4рвф",
    "4р3г",
    "8рг.",
    "4ргг",
    "4ргк",
    "4ргп",
    "4ргр4",
    "4ргт",
    "4ргц",
    "4ргч",
    "4р3д",
    "8рд.",
    "4рдб",
    "4рдг",
    "4рдд",
    "4рдк",
    "4рдп",
    "4рдр4",
    "4рдт",
    "4рдц",
    "4рдч",
    "4р3ж",
    "8рж.",
    "4ржж",
    "4ржр4",
    "4ржс",
    "4ржф",
    "4ржх",
    "4ржш",
    "4р3з",
    "8рз.",
    "4рзз",
    "4рзр4",
    "4рзс",
    "4рзф",
    "4рзх",
    "4рзш",
    "4р3к",
    "8рк.",
    "4ркб",
    "4ркг",
    "4ркд",
    "4ркк",
    "4ркр4",
    "4р3л",
    "8рл.",
    "4рлл",
    "4рлр4",
    "4р3м",
    "8рм.",
    "4рмм",
    "4рмр4",
    "4р3н",
    "8рн.",
    "4рнн",
    "4рнр4",
    "4р3п",
    "8рп.",
    "4рпб",
    "4рпг",
    "4рпд",
    "4рпп",
    "4рпр4",
    "4р3р4",
    "8рр.",
    "ррб4",
    "ррв4",
    "ррг4",
    "ррд4",
    "ррж4",
    "ррз4",
    "ррк4",
    "ррл4",
    "ррм4",
    "ррн4",
    "ррп4",
    "4ррр4",
    "ррс4",
    "ррт4",
    "ррф4",
    "ррх4",
    "ррц4",
    "ррч4",
    "ррш4",
    "ррщ4",
    "4р3с",
    "8рс.",
    "4рсж",
    "4рсз",
    "4рср4",
    "4рсс",
    "4р3т",
    "8рт.",
    "4ртб",
    "4ртг",
    "4ртд",
    "4ртк",
    "4ртп",
    "4ртр4",
    "4ртт",
    "4ртц",
    "4ртч",
    "4р3ф",
    "8рф.",
    "4рфв",
    "4рфж",
    "4рфз",
    "4рфр4",
    "4рфф",
    "4р3х",
    "8рх.",
    "4рхж",
    "4рхз",
    "4рхр4",
    "4рхх",
    "4р3ц",
    "8рц.",
    "4рцб",
    "4рцг",
    "4рцд",
    "4рцк",
    "4рцп",
    "4рцр4",
    "4рцт",
    "4рцц",
    "4рцч",
    "4р3ч",
    "8рч.",
    "4рчб",
    "4рчг",
    "4рчд",
    "4рчк",
    "4рчп",
    "4рчр4",
    "4рчт",
    "4рчц",
    "4рчч",
    "4р3ш",
    "8рш.",
    "4ршж",
    "4ршз",
    "4ршр4",
    "4ршш",
    "4р3щ",
    "8рщ.",
    "4рщр4",
    "4рщщ",
    "2с3б4",
    "8сб.",
    "4сбб",
    "4сбж4",
    "4сбз4",
    "4сбк",
    "4сбп",
    "4сбс4",
    "4сбт",
    "4сбф4",
    "4сбх4",
    "4сбц",
    "4сбч",
    "4сбш4",
    "2с3в4",
    "8св.",
    "4свв",
    "4свж4",
    "4свз4",
    "4свс4",
    "4свф",
    "2с3г4",
    "8сг.",
    "4сгг",
    "4сгж4",
    "4сгз4",
    "4сгк",
    "4сгп",
    "4сгс4",
    "4сгт",
    "4сгф4",
    "4сгх4",
    "4сгц",
    "4сгч",
    "4сгш4",
    "2с3д4",
    "8сд.",
    "4сдб",
    "4сдг",
    "4сдд",
    "4сдж4",
    "4сдз4",
    "4сдк",
    "4сдп",
    "4сдс4",
    "4сдт",
    "4сдф4",
    "4сдх4",
    "4сдц",
    "4сдч",
    "4сдш4",
    "4с3ж4",
    "8сж.",
    "сжб4",
    "сжв4",
    "сжг4",
    "сжд4",
    "4сжж4",
    "4сжз4",
    "сжк4",
    "сжл4",
    "сжм4",
    "сжн4",
    "сжп4",
    "сжр4",
    "4сжс4",
    "сжт4",
    "4сжф4",
    "4сжх4",
    "сжц4",
    "сжч4",
    "4сжш4",
    "сжщ4",
    "4с3з4",
    "8сз.",
    "сзб4",
    "сзв4",
    "сзг4",
    "сзд4",
    "4сзж4",
    "4сзз4",
    "сзк4",
    "сзл4",
    "сзм4",
    "сзн4",
    "сзп4",
    "сзр4",
    "4сзс4",
    "сзт4",
    "4сзф4",
    "4сзх4",
    "сзц4",
    "сзч4",
    "4сзш4",
    "сзщ4",
    "сй4",
    "2с3к",
    "8ск.",
    "4скб",
    "4скг",
    "4скд",
    "4скж4",
    "4скз4",
    "4скк",
    "4скс4",
    "4скф4",
    "4скх4",
    "4скш4",
    "2с3л4",
    "8сл.",
    "4слж4",
    "4слз4",
    "4слл",
    "4слс4",
    "2с3м4",
    "8см.",
    "4смж4",
    "4смз4",
    "4смм",
    "4смс4",
    "2с3н4",
    "8сн.",
    "4снж4",
    "4снз4",
    "4снн",
    "4снс4",
    "2с3п",
    "8сп.",
    "4спб",
    "4спг",
    "4спд",
    "4спж4",
    "4спз4",
    "4спп",
    "4спс4",
    "4спф4",
    "4спх4",
    "4спш4",
    "2с3р4",
    "8ср.",
    "4срж4",
    "4срз4",
    "4срр",
    "4срс4",
    "4с3с4",
    "8сс.",
    "ссб4",
    "ссв4",
    "ссг4",
    "ссд4",
    "4ссж4",
    "4ссз4",
    "сск4",
    "ссл4",
    "ссм4",
    "ссн4",
    "ссп4",
    "сср4",
    "4ссс4",
    "сст4",
    "ссф4",
    "ссх4",
    "ссц4",
    "ссч4",
    "ссш4",
    "ссщ4",
    "2с3т",
    "8ст.",
    "4стб",
    "4стг",
    "4стд",
    "4стж4",
    "4стз4",
    "4стк",
    "4стп",
    "4стс4",
    "4стт",
    "4стф4",
    "4стх4",
    "4стц",
    "4стч",
    "4стш4",
    "2с3ф",
    "8сф.",
    "4сфв",
    "4сфж4",
    "4сфз4",
    "4сфс4",
    "4сфф",
    "2с3х",
    "8сх.",
    "4схж4",
    "4схз4",
    "4схс4",
    "4схх",
    "2с3ц",
    "8сц.",
    "4сцб",
    "4сцг",
    "4сцд",
    "4сцж4",
    "4сцз4",
    "4сцк",
    "4сцп",
    "4сцс4",
    "4сцт",
    "4сцф4",
    "4сцх4",
    "4сцц",
    "4сцч",
    "4сцш4",
    "2с3ч",
    "8сч.",
    "4счб",
    "4счг",
    "4счд",
    "4счж4",
    "4счз4",
    "4счк",
    "4счп",
    "4счс4",
    "4счт",
    "4счф4",
    "4счх4",
    "4счц",
    "4счч",
    "4счш4",
    "2с3ш",
    "8сш.",
    "4сшж4",
    "4сшз4",
    "4сшс4",
    "4сшш",
    "2с3щ",
    "8сщ.",
    "4сщж4",
    "4сщз4",
    "4сщс4",
    "4сщщ",
    "4т3б4",
    "8тб.",
    "4тбб4",
    "тбв4",
    "4тбг4",
    "4тбд4",
    "тбж4",
    "тбз4",
    "4тбк4",
    "тбл4",
    "тбм4",
    "тбн4",
    "4тбп4",
    "тбр4",
    "тбс4",
    "4тбт4",
    "тбф4",
    "тбх4",
    "4тбц4",
    "4тбч4",
    "тбш4",
    "тбщ4",
    "2т3в4",
    "8тв.",
    "4твб4",
    "4твв",
    "4твг4",
    "4твд4",
    "4твк4",
    "4твп4",
    "4твт4",
    "4твф",
    "4твц4",
    "4твч4",
    "4т3г4",
    "8тг.",
    "4тгб4",
    "тгв4",
    "4тгг4",
    "4тгд4",
    "тгж4",
    "тгз4",
    "4тгк4",
    "тгл4",
    "тгм4",
    "тгн4",
    "4тгп4",
    "тгр4",
    "тгс4",
    "4тгт4",
    "тгф4",
    "тгх4",
    "4тгц4",
    "4тгч4",
    "тгш4",
    "тгщ4",
    "4т3д4",
    "8тд.",
    "4тдб4",
    "тдв4",
    "4тдг4",
    "4тдд4",
    "тдж4",
    "тдз4",
    "4тдк4",
    "тдл4",
    "тдм4",
    "тдн4",
    "4тдп4",
    "тдр4",
    "тдс4",
    "4тдт4",
    "тдф4",
    "тдх4",
    "4тдц4",
    "4тдч4",
    "тдш4",
    "тдщ4",
    "2т3ж4",
    "8тж.",
    "4тжб4",
    "4тжг4",
    "4тжд4",
    "4тжж",
    "4тжк4",
    "4тжп4",
    "4тжс",
    "4тжт4",
    "4тжф",
    "4тжх",
    "4тжц4",
    "4тжч4",
    "4тжш",
    "2т3з4",
    "8тз.",
    "4тзб4",
    "4тзг4",
    "4тзд4",
    "4тзз",
    "4тзк4",
    "4тзп4",
    "4тзс",
    "4тзт4",
    "4тзф",
    "4тзх",
    "4тзц4",
    "4тзч4",
    "4тзш",
    "тй4",
    "4т3к4",
    "8тк.",
    "4ткб4",
    "ткв4",
    "4ткг4",
    "4ткд4",
    "ткж4",
    "ткз4",
    "4ткк4",
    "ткл4",
    "ткм4",
    "ткн4",
    "4ткп4",
    "ткр4",
    "ткс4",
    "4ткт4",
    "ткф4",
    "ткх4",
    "4ткц4",
    "4ткч4",
    "ткш4",
    "ткщ4",
    "2т3л4",
    "8тл.",
    "4тлб4",
    "4тлг4",
    "4тлд4",
    "4тлк4",
    "4тлл",
    "4тлп4",
    "4тлт4",
    "4тлц4",
    "4тлч4",
    "2т3м4",
    "8тм.",
    "4тмб4",
    "4тмг4",
    "4тмд4",
    "4тмк4",
    "4тмм",
    "4тмп4",
    "4тмт4",
    "4тмц4",
    "4тмч4",
    "2т3н4",
    "8тн.",
    "4тнб4",
    "4тнг4",
    "4тнд4",
    "4тнк4",
    "4тнн",
    "4тнп4",
    "4тнт4",
    "4тнц4",
    "4тнч4",
    "4т3п4",
    "8тп.",
    "4тпб4",
    "тпв4",
    "4тпг4",
    "4тпд4",
    "тпж4",
    "тпз4",
    "4тпк4",
    "тпл4",
    "тпм4",
    "тпн4",
    "4тпп4",
    "тпр4",
    "тпс4",
    "4тпт4",
    "тпф4",
    "тпх4",
    "4тпц4",
    "4тпч4",
    "тпш4",
    "тпщ4",
    "2т3р4",
    "8тр.",
    "4трб4",
    "4трг4",
    "4трд4",
    "4трк4",
    "4трп4",
    "4трр",
    "4трт4",
    "4трц4",
    "4трч4",
    "2т3с",
    "8тс.",
    "4тсб4",
    "4тсг4",
    "4тсд4",
    "4тсж",
    "4тсз",
    "4тск4",
    "4тсп4",
    "4тсс",
    "4тст4",
    "4тсц4",
    "4тсч4",
    "4т3т4",
    "8тт.",
    "4ттб4",
    "ттв4",
    "4ттг4",
    "4ттд4",
    "ттж4",
    "ттз4",
    "4ттк4",
    "ттл4",
    "ттм4",
    "ттн4",
    "4ттп4",
    "ттр4",
    "ттс4",
    "4ттт4",
    "ттф4",
    "ттх4",
    "4ттц4",
    "4ттч4",
    "ттш4",
    "ттщ4",
    "2т3ф",
    "8тф.",
    "4тфб4",
    "4тфв",
    "4тфг4",
    "4тфд4",
    "4тфж",
    "4тфз",
    "4тфк4",
    "4тфп4",
    "4тфт4",
    "4тфф",
    "4тфц4",
    "4тфч4",
    "2т3х",
    "8тх.",
    "4тхб4",
    "4тхг4",
    "4тхд4",
    "4тхж",
    "4тхз",
    "4тхк4",
    "4тхп4",
    "4тхт4",
    "4тхх",
    "4тхц4",
    "4тхч4",
    "4т3ц4",
    "8тц.",
    "4тцб4",
    "тцв4",
    "4тцг4",
    "4тцд4",
    "тцж4",
    "тцз4",
    "4тцк4",
    "тцл4",
    "тцм4",
    "тцн4",
    "4тцп4",
    "тцр4",
    "тцс4",
    "4тцт4",
    "тцф4",
    "тцх4",
    "4тцц4",
    "4тцч4",
    "тцш4",
    "тцщ4",
    "4т3ч4",
    "8тч.",
    "4тчб4",
    "тчв4",
    "4тчг4",
    "4тчд4",
    "тчж4",
    "тчз4",
    "4тчк4",
    "тчл4",
    "тчм4",
    "тчн4",
    "4тчп4",
    "тчр4",
    "тчс4",
    "4тчт4",
    "тчф4",
    "тчх4",
    "4тчц4",
    "4тчч4",
    "тчш4",
    "тчщ4",
    "2т3ш",
    "8тш.",
    "4тшб4",
    "4тшг4",
    "4тшд4",
    "4тшж",
    "4тшз",
    "4тшк4",
    "4тшп4",
    "4тшт4",
    "4тшц4",
    "4тшч4",
    "4тшш",
    "2т3щ",
    "8тщ.",
    "4тщб4",
    "4тщг4",
    "4тщд4",
    "4тщк4",
    "4тщп4",
    "4тщт4",
    "4тщц4",
    "4тщч4",
    "4тщщ",
    "у1",
    "2ф3б4",
    "8фб.",
    "4фбб",
    "4фбв4",
    "4фбж4",
    "4фбз4",
    "4фбк",
    "4фбп",
    "4фбс4",
    "4фбт",
    "4фбф4",
    "4фбх4",
    "4фбц",
    "4фбч",
    "4фбш4",
    "4ф3в4",
    "8фв.",
    "фвб4",
    "4фвв4",
    "фвг4",
    "фвд4",
    "4фвж4",
    "4фвз4",
    "фвк4",
    "фвл4",
    "фвм4",
    "фвн4",
    "фвп4",
    "фвр4",
    "фвс4",
    "фвт4",
    "4фвф4",
    "фвх4",
    "фвц4",
    "фвч4",
    "фвш4",
    "фвщ4",
    "2ф3г4",
    "8фг.",
    "4фгв4",
    "4фгг",
    "4фгж4",
    "4фгз4",
    "4фгк",
    "4фгп",
    "4фгс4",
    "4фгт",
    "4фгф4",
    "4фгх4",
    "4фгц",
    "4фгч",
    "4фгш4",
    "2ф3д4",
    "8фд.",
    "4фдб",
    "4фдв4",
    "4фдг",
    "4фдд",
    "4фдж4",
    "4фдз4",
    "4фдк",
    "4фдп",
    "4фдс4",
    "4фдт",
    "4фдф4",
    "4фдх4",
    "4фдц",
    "4фдч",
    "4фдш4",
    "4ф3ж4",
    "8фж.",
    "фжб4",
    "4фжв4",
    "фжг4",
    "фжд4",
    "4фжж4",
    "4фжз4",
    "фжк4",
    "фжл4",
    "фжм4",
    "фжн4",
    "фжп4",
    "фжр4",
    "4фжс4",
    "фжт4",
    "4фжф4",
    "4фжх4",
    "фжц4",
    "фжч4",
    "4фжш4",
    "фжщ4",
    "4ф3з4",
    "8фз.",
    "фзб4",
    "4фзв4",
    "фзг4",
    "фзд4",
    "4фзж4",
    "4фзз4",
    "фзк4",
    "фзл4",
    "фзм4",
    "фзн4",
    "фзп4",
    "фзр4",
    "4фзс4",
    "фзт4",
    "4фзф4",
    "4фзх4",
    "фзц4",
    "фзч4",
    "4фзш4",
    "фзщ4",
    "фй4",
    "2ф3к",
    "8фк.",
    "4фкб",
    "4фкв4",
    "4фкг",
    "4фкд",
    "4фкж4",
    "4фкз4",
    "4фкк",
    "4фкс4",
    "4фкф4",
    "4фкх4",
    "4фкш4",
    "2ф3л4",
    "8фл.",
    "4флв4",
    "4флж4",
    "4флз4",
    "4флл",
    "4флф4",
    "2ф3м4",
    "8фм.",
    "4фмв4",
    "4фмж4",
    "4фмз4",
    "4фмм",
    "4фмф4",
    "2ф3н4",
    "8фн.",
    "4фнв4",
    "4фнж4",
    "4фнз4",
    "4фнн",
    "4фнф4",
    "2ф3п",
    "8фп.",
    "4фпб",
    "4фпв4",
    "4фпг",
    "4фпд",
    "4фпж4",
    "4фпз4",
    "4фпп",
    "4фпс4",
    "4фпф4",
    "4фпх4",
    "4фпш4",
    "2ф3р4",
    "8фр.",
    "4фрв4",
    "4фрж4",
    "4фрз4",
    "4фрр",
    "4фрф4",
    "2ф3с",
    "8фс.",
    "4фсв4",
    "4фсж4",
    "4фсз4",
    "4фсс",
    "4фсф4",
    "2ф3т",
    "8фт.",
    "4фтб",
    "4фтв4",
    "4фтг",
    "4фтд",
    "4фтж4",
    "4фтз4",
    "4фтк",
    "4фтп",
    "4фтс4",
    "4фтт",
    "4фтф4",
    "4фтх4",
    "4фтц",
    "4фтч",
    "4фтш4",
    "4ф3ф4",
    "8фф.",
    "ффб4",
    "4ффв4",
    "ффг4",
    "ффд4",
    "4ффж4",
    "4ффз4",
    "ффк4",
    "ффл4",
    "ффм4",
    "ффн4",
    "ффп4",
    "ффр4",
    "ффс4",
    "ффт4",
    "4ффф4",
    "ффх4",
    "ффц4",
    "ффч4",
    "ффш4",
    "ффщ4",
    "2ф3х",
    "8фх.",
    "4фхв4",
    "4фхж4",
    "4фхз4",
    "4фхф4",
    "4фхх",
    "2ф3ц",
    "8фц.",
    "4фцб",
    "4фцв4",
    "4фцг",
    "4фцд",
    "4фцж4",
    "4фцз4",
    "4фцк",
    "4фцп",
    "4фцс4",
    "4фцт",
    "4фцф4",
    "4фцх4",
    "4фцц",
    "4фцч",
    "4фцш4",
    "2ф3ч",
    "8фч.",
    "4фчб",
    "4фчв4",
    "4фчг",
    "4фчд",
    "4фчж4",
    "4фчз4",
    "4фчк",
    "4фчп",
    "4фчс4",
    "4фчт",
    "4фчф4",
    "4фчх4",
    "4фчц",
    "4фчч",
    "4фчш4",
    "2ф3ш",
    "8фш.",
    "4фшв4",
    "4фшж4",
    "4фшз4",
    "4фшф4",
    "4фшш",
    "2ф3щ",
    "8фщ.",
    "4фщв4",
    "4фщж4",
    "4фщз4",
    "4фщф4",
    "4фщщ",
    "2х3б4",
    "8хб.",
    "4хбб",
    "4хбж4",
    "4хбз4",
    "4хбк",
    "4хбп",
    "4хбс4",
    "4хбт",
    "4хбф4",
    "4хбх4",
    "4хбц",
    "4хбч",
    "4хбш4",
    "2х3в4",
    "8хв.",
    "4хвв",
    "4хвж4",
    "4хвз4",
    "4хвф",
    "4хвх4",
    "2х3г4",
    "8хг.",
    "4хгг",
    "4хгж4",
    "4хгз4",
    "4хгк",
    "4хгп",
    "4хгс4",
    "4хгт",
    "4хгф4",
    "4хгх4",
    "4хгц",
    "4хгч",
    "4хгш4",
    "2х3д4",
    "8хд.",
    "4хдб",
    "4хдг",
    "4хдд",
    "4хдж4",
    "4хдз4",
    "4хдк",
    "4хдп",
    "4хдс4",
    "4хдт",
    "4хдф4",
    "4хдх4",
    "4хдц",
    "4хдч",
    "4хдш4",
    "4х3ж4",
    "8хж.",
    "хжб4",
    "хжв4",
    "хжг4",
    "хжд4",
    "4хжж4",
    "4хжз4",
    "хжк4",
    "хжл4",
    "хжм4",
    "хжн4",
    "хжп4",
    "хжр4",
    "4хжс4",
    "хжт4",
    "4хжф4",
    "4хжх4",
    "хжц4",
    "хжч4",
    "4хжш4",
    "хжщ4",
    "4х3з4",
    "8хз.",
    "хзб4",
    "хзв4",
    "хзг4",
    "хзд4",
    "4хзж4",
    "4хзз4",
    "хзк4",
    "хзл4",
    "хзм4",
    "хзн4",
    "хзп4",
    "хзр4",
    "4хзс4",
    "хзт4",
    "4хзф4",
    "4хзх4",
    "хзц4",
    "хзч4",
    "4хзш4",
    "хзщ4",
    "хй4",
    "2х3к",
    "8хк.",
    "4хкб",
    "4хкг",
    "4хкд",
    "4хкж4",
    "4хкз4",
    "4хкк",
    "4хкс4",
    "4хкф4",
    "4хкх4",
    "4хкш4",
    "2х3л4",
    "8хл.",
    "4хлж4",
    "4хлз4",
    "4хлл",
    "4хлх4",
    "2х3м4",
    "8хм.",
    "4хмж4",
    "4хмз4",
    "4хмм",
    "4хмх4",
    "2х3н4",
    "8хн.",
    "4хнж4",
    "4хнз4",
    "4хнн",
    "4хнх4",
    "2х3п",
    "8хп.",
    "4хпб",
    "4хпг",
    "4хпд",
    "4хпж4",
    "4хпз4",
    "4хпп",
    "4хпс4",
    "4хпф4",
    "4хпх4",
    "4хпш4",
    "2х3р4",
    "8хр.",
    "4хрж4",
    "4хрз4",
    "4хрр",
    "4хрх4",
    "2х3с",
    "8хс.",
    "4хсж4",
    "4хсз4",
    "4хсс",
    "4хсх4",
    "2х3т",
    "8хт.",
    "4хтб",
    "4хтг",
    "4хтд",
    "4хтж4",
    "4хтз4",
    "4хтк",
    "4хтп",
    "4хтс4",
    "4хтт",
    "4хтф4",
    "4хтх4",
    "4хтц",
    "4хтч",
    "4хтш4",
    "2х3ф",
    "8хф.",
    "4хфв",
    "4хфж4",
    "4хфз4",
    "4хфф",
    "4хфх4",
    "4х3х4",
    "8хх.",
    "ххб4",
    "ххв4",
    "ххг4",
    "ххд4",
    "4ххж4",
    "4ххз4",
    "ххк4",
    "ххл4",
    "ххм4",
    "ххн4",
    "ххп4",
    "ххр4",
    "ххс4",
    "ххт4",
    "ххф4",
    "4ххх4",
    "ххц4",
    "ххч4",
    "ххш4",
    "ххщ4",
    "2х3ц",
    "8хц.",
    "4хцб",
    "4хцг",
    "4хцд",
    "4хцж4",
    "4хцз4",
    "4хцк",
    "4хцп",
    "4хцс4",
    "4хцт",
    "4хцф4",
    "4хцх4",
    "4хцц",
    "4хцч",
    "4хцш4",
    "2х3ч",
    "8хч.",
    "4хчб",
    "4хчг",
    "4хчд",
    "4хчж4",
    "4хчз4",
    "4хчк",
    "4хчп",
    "4хчс4",
    "4хчт",
    "4хчф4",
    "4хчх4",
    "4хчц",
    "4хчч",
    "4хчш4",
    "2х3ш",
    "8хш.",
    "4хшж4",
    "4хшз4",
    "4хшх4",
    "4хшш",
    "2х3щ",
    "8хщ.",
    "4хщж4",
    "4хщз4",
    "4хщх4",
    "4хщщ",
    "4ц3б4",
    "8цб.",
    "4цбб4",
    "цбв4",
    "4цбг4",
    "4цбд4",
    "цбж4",
    "цбз4",
    "4цбк4",
    "цбл4",
    "цбм4",
    "цбн4",
    "4цбп4",
    "цбр4",
    "цбс4",
    "4цбт4",
    "цбф4",
    "цбх4",
    "4цбц4",
    "4цбч4",
    "цбш4",
    "цбщ4",
    "2ц3в4",
    "8цв.",
    "4цвб4",
    "4цвв",
    "4цвг4",
    "4цвд4",
    "4цвк4",
    "4цвп4",
    "4цвт4",
    "4цвф",
    "4цвц4",
    "4цвч4",
    "4ц3г4",
    "8цг.",
    "4цгб4",
    "цгв4",
    "4цгг4",
    "4цгд4",
    "цгж4",
    "цгз4",
    "4цгк4",
    "цгл4",
    "цгм4",
    "цгн4",
    "4цгп4",
    "цгр4",
    "цгс4",
    "4цгт4",
    "цгф4",
    "цгх4",
    "4цгц4",
    "4цгч4",
    "цгш4",
    "цгщ4",
    "4ц3д4",
    "8цд.",
    "4цдб4",
    "цдв4",
    "4цдг4",
    "4цдд4",
    "цдж4",
    "цдз4",
    "4цдк4",
    "цдл4",
    "цдм4",
    "цдн4",
    "4цдп4",
    "цдр4",
    "цдс4",
    "4цдт4",
    "цдф4",
    "цдх4",
    "4цдц4",
    "4цдч4",
    "цдш4",
    "цдщ4",
    "2ц3ж4",
    "8цж.",
    "4цжб4",
    "4цжг4",
    "4цжд4",
    "4цжж",
    "4цжк4",
    "4цжп4",
    "4цжс",
    "4цжт4",
    "4цжф",
    "4цжх",
    "4цжц4",
    "4цжч4",
    "4цжш",
    "2ц3з4",
    "8цз.",
    "4цзб4",
    "4цзг4",
    "4цзд4",
    "4цзз",
    "4цзк4",
    "4цзп4",
    "4цзс",
    "4цзт4",
    "4цзф",
    "4цзх",
    "4цзц4",
    "4цзч4",
    "4цзш",
    "цй4",
    "4ц3к4",
    "8цк.",
    "4цкб4",
    "цкв4",
    "4цкг4",
    "4цкд4",
    "цкж4",
    "цкз4",
    "4цкк4",
    "цкл4",
    "цкм4",
    "цкн4",
    "4цкп4",
    "цкр4",
    "цкс4",
    "4цкт4",
    "цкф4",
    "цкх4",
    "4цкц4",
    "4цкч4",
    "цкш4",
    "цкщ4",
    "2ц3л4",
    "8цл.",
    "4цлб4",
    "4цлг4",
    "4цлд4",
    "4цлк4",
    "4цлл",
    "4цлп4",
    "4цлт4",
    "4цлц4",
    "4цлч4",
    "2ц3м4",
    "8цм.",
    "4цмб4",
    "4цмг4",
    "4цмд4",
    "4цмк4",
    "4цмм",
    "4цмп4",
    "4цмт4",
    "4цмц4",
    "4цмч4",
    "2ц3н4",
    "8цн.",
    "4цнб4",
    "4цнг4",
    "4цнд4",
    "4цнк4",
    "4цнн",
    "4цнп4",
    "4цнт4",
    "4цнц4",
    "4цнч4",
    "4ц3п4",
    "8цп.",
    "4цпб4",
    "цпв4",
    "4цпг4",
    "4цпд4",
    "цпж4",
    "цпз4",
    "4цпк4",
    "цпл4",
    "цпм4",
    "цпн4",
    "4цпп4",
    "цпр4",
    "цпс4",
    "4цпт4",
    "цпф4",
    "цпх4",
    "4цпц4",
    "4цпч4",
    "цпш4",
    "цпщ4",
    "2ц3р4",
    "8цр.",
    "4црб4",
    "4црг4",
    "4црд4",
    "4црк4",
    "4црп4",
    "4црр",
    "4црт4",
    "4црц4",
    "4црч4",
    "2ц3с",
    "8цс.",
    "4цсб4",
    "4цсг4",
    "4цсд4",
    "4цсж",
    "4цсз",
    "4цск4",
    "4цсп4",
    "4цсс",
    "4цст4",
    "4цсц4",
    "4цсч4",
    "4ц3т4",
    "8цт.",
    "4цтб4",
    "цтв4",
    "4цтг4",
    "4цтд4",
    "цтж4",
    "цтз4",
    "4цтк4",
    "цтл4",
    "цтм4",
    "цтн4",
    "4цтп4",
    "цтр4",
    "цтс4",
    "4цтт4",
    "цтф4",
    "цтх4",
    "4цтц4",
    "4цтч4",
    "цтш4",
    "цтщ4",
    "2ц3ф",
    "8цф.",
    "4цфб4",
    "4цфв",
    "4цфг4",
    "4цфд4",
    "4цфж",
    "4цфз",
    "4цфк4",
    "4цфп4",
    "4цфт4",
    "4цфф",
    "4цфц4",
    "4цфч4",
    "2ц3х",
    "8цх.",
    "4цхб4",
    "4цхг4",
    "4цхд4",
    "4цхж",
    "4цхз",
    "4цхк4",
    "4цхп4",
    "4цхт4",
    "4цхх",
    "4цхц4",
    "4цхч4",
    "4ц3ц4",
    "8цц.",
    "4ццб4",
    "ццв4",
    "4ццг4",
    "4ццд4",
    "ццж4",
    "ццз4",
    "4ццк4",
    "ццл4",
    "ццм4",
    "ццн4",
    "4ццп4",
    "ццр4",
    "ццс4",
    "4ццт4",
    "ццф4",
    "ццх4",
    "4ццц4",
    "4ццч4",
    "ццш4",
    "ццщ4",
    "4ц3ч4",
    "8цч.",
    "4цчб4",
    "цчв4",
    "4цчг4",
    "4цчд4",
    "цчж4",
    "цчз4",
    "4цчк4",
    "цчл4",
    "цчм4",
    "цчн4",
    "4цчп4",
    "цчр4",
    "цчс4",
    "4цчт4",
    "цчф4",
    "цчх4",
    "4цчц4",
    "4цчч4",
    "цчш4",
    "цчщ4",
    "2ц3ш",
    "8цш.",
    "4цшб4",
    "4цшг4",
    "4цшд4",
    "4цшж",
    "4цшз",
    "4цшк4",
    "4цшп4",
    "4цшт4",
    "4цшц4",
    "4цшч4",
    "4цшш",
    "2ц3щ",
    "8цщ.",
    "4цщб4",
    "4цщг4",
    "4цщд4",
    "4цщк4",
    "4цщп4",
    "4цщт4",
    "4цщц4",
    "4цщч4",
    "4цщщ",
    "4ч3б4",
    "8чб.",
    "4чбб4",
    "чбв4",
    "4чбг4",
    "4чбд4",
    "чбж4",
    "чбз4",
    "4чбк4",
    "чбл4",
    "чбм4",
    "чбн4",
    "4чбп4",
    "чбр4",
    "чбс4",
    "4чбт4",
    "чбф4",
    "чбх4",
    "4чбц4",
    "4чбч4",
    "чбш4",
    "чбщ4",
    "2ч3в4",
    "8чв.",
    "4чвб4",
    "4чвв",
    "4чвг4",
    "4чвд4",
    "4чвк4",
    "4чвп4",
    "4чвт4",
    "4чвф",
    "4чвц4",
    "4чвч4",
    "4ч3г4",
    "8чг.",
    "4чгб4",
    "чгв4",
    "4чгг4",
    "4чгд4",
    "чгж4",
    "чгз4",
    "4чгк4",
    "чгл4",
    "чгм4",
    "чгн4",
    "4чгп4",
    "чгр4",
    "чгс4",
    "4чгт4",
    "чгф4",
    "чгх4",
    "4чгц4",
    "4чгч4",
    "чгш4",
    "чгщ4",
    "4ч3д4",
    "8чд.",
    "4чдб4",
    "чдв4",
    "4чдг4",
    "4чдд4",
    "чдж4",
    "чдз4",
    "4чдк4",
    "чдл4",
    "чдм4",
    "чдн4",
    "4чдп4",
    "чдр4",
    "чдс4",
    "4чдт4",
    "чдф4",
    "чдх4",
    "4чдц4",
    "4чдч4",
    "чдш4",
    "чдщ4",
    "2ч3ж4",
    "8чж.",
    "4чжб4",
    "4чжг4",
    "4чжд4",
    "4чжж",
    "4чжк4",
    "4чжп4",
    "4чжс",
    "4чжт4",
    "4чжф",
    "4чжх",
    "4чжц4",
    "4чжч4",
    "4чжш",
    "2ч3з4",
    "8чз.",
    "4чзб4",
    "4чзг4",
    "4чзд4",
    "4чзз",
    "4чзк4",
    "4чзп4",
    "4чзс",
    "4чзт4",
    "4чзф",
    "4чзх",
    "4чзц4",
    "4чзч4",
    "4чзш",
    "чй4",
    "4ч3к4",
    "8чк.",
    "4чкб4",
    "чкв4",
    "4чкг4",
    "4чкд4",
    "чкж4",
    "чкз4",
    "4чкк4",
    "чкл4",
    "чкм4",
    "чкн4",
    "4чкп4",
    "чкр4",
    "чкс4",
    "4чкт4",
    "чкф4",
    "чкх4",
    "4чкц4",
    "4чкч4",
    "чкш4",
    "чкщ4",
    "2ч3л4",
    "8чл.",
    "4члб4",
    "4члг4",
    "4члд4",
    "4члк4",
    "4члл",
    "4члп4",
    "4члт4",
    "4члц4",
    "4члч4",
    "2ч3м4",
    "8чм.",
    "4чмб4",
    "4чмг4",
    "4чмд4",
    "4чмк4",
    "4чмм",
    "4чмп4",
    "4чмт4",
    "4чмц4",
    "4чмч4",
    "2ч3н4",
    "8чн.",
    "4чнб4",
    "4чнг4",
    "4чнд4",
    "4чнк4",
    "4чнн",
    "4чнп4",
    "4чнт4",
    "4чнц4",
    "4чнч4",
    "4ч3п4",
    "8чп.",
    "4чпб4",
    "чпв4",
    "4чпг4",
    "4чпд4",
    "чпж4",
    "чпз4",
    "4чпк4",
    "чпл4",
    "чпм4",
    "чпн4",
    "4чпп4",
    "чпр4",
    "чпс4",
    "4чпт4",
    "чпф4",
    "чпх4",
    "4чпц4",
    "4чпч4",
    "чпш4",
    "чпщ4",
    "2ч3р4",
    "8чр.",
    "4чрб4",
    "4чрг4",
    "4чрд4",
    "4чрк4",
    "4чрп4",
    "4чрр",
    "4чрт4",
    "4чрц4",
    "4чрч4",
    "2ч3с",
    "8чс.",
    "4чсб4",
    "4чсг4",
    "4чсд4",
    "4чсж",
    "4чсз",
    "4чск4",
    "4чсп4",
    "4чсс",
    "4чст4",
    "4чсц4",
    "4чсч4",
    "4ч3т4",
    "8чт.",
    "4чтб4",
    "чтв4",
    "4чтг4",
    "4чтд4",
    "чтж4",
    "чтз4",
    "4чтк4",
    "чтл4",
    "чтм4",
    "чтн4",
    "4чтп4",
    "чтр4",
    "чтс4",
    "4чтт4",
    "чтф4",
    "чтх4",
    "4чтц4",
    "4чтч4",
    "чтш4",
    "чтщ4",
    "2ч3ф",
    "8чф.",
    "4чфб4",
    "4чфв",
    "4чфг4",
    "4чфд4",
    "4чфж",
    "4чфз",
    "4чфк4",
    "4чфп4",
    "4чфт4",
    "4чфф",
    "4чфц4",
    "4чфч4",
    "2ч3х",
    "8чх.",
    "4чхб4",
    "4чхг4",
    "4чхд4",
    "4чхж",
    "4чхз",
    "4чхк4",
    "4чхп4",
    "4чхт4",
    "4чхх",
    "4чхц4",
    "4чхч4",
    "4ч3ц4",
    "8чц.",
    "4чцб4",
    "чцв4",
    "4чцг4",
    "4чцд4",
    "чцж4",
    "чцз4",
    "4чцк4",
    "чцл4",
    "чцм4",
    "чцн4",
    "4чцп4",
    "чцр4",
    "чцс4",
    "4чцт4",
    "чцф4",
    "чцх4",
    "4чцц4",
    "4чцч4",
    "чцш4",
    "чцщ4",
    "4ч3ч4",
    "8чч.",
    "4ччб4",
    "ччв4",
    "4ччг4",
    "4ччд4",
    "ччж4",
    "ччз4",
    "4ччк4",
    "ччл4",
    "ччм4",
    "ччн4",
    "4ччп4",
    "ччр4",
    "ччс4",
    "4ччт4",
    "ччф4",
    "ччх4",
    "4ччц4",
    "4ччч4",
    "ччш4",
    "ччщ4",
    "2ч3ш",
    "8чш.",
    "4чшб4",
    "4чшг4",
    "4чшд4",
    "4чшж",
    "4чшз",
    "4чшк4",
    "4чшп4",
    "4чшт4",
    "4чшц4",
    "4чшч4",
    "4чшш",
    "2ч3щ",
    "8чщ.",
    "4чщб4",
    "4чщг4",
    "4чщд4",
    "4чщк4",
    "4чщп4",
    "4чщт4",
    "4чщц4",
    "4чщч4",
    "4чщщ",
    "2ш3б4",
    "8шб.",
    "4шбб",
    "4шбж4",
    "4шбз4",
    "4шбк",
    "4шбп",
    "4шбс4",
    "4шбт",
    "4шбф4",
    "4шбх4",
    "4шбц",
    "4шбч",
    "4шбш4",
    "2ш3в4",
    "8шв.",
    "4швв",
    "4швж4",
    "4швз4",
    "4швф",
    "4швш4",
    "2ш3г4",
    "8шг.",
    "4шгг",
    "4шгж4",
    "4шгз4",
    "4шгк",
    "4шгп",
    "4шгс4",
    "4шгт",
    "4шгф4",
    "4шгх4",
    "4шгц",
    "4шгч",
    "4шгш4",
    "2ш3д4",
    "8шд.",
    "4шдб",
    "4шдг",
    "4шдд",
    "4шдж4",
    "4шдз4",
    "4шдк",
    "4шдп",
    "4шдс4",
    "4шдт",
    "4шдф4",
    "4шдх4",
    "4шдц",
    "4шдч",
    "4шдш4",
    "4ш3ж4",
    "8шж.",
    "шжб4",
    "шжв4",
    "шжг4",
    "шжд4",
    "4шжж4",
    "4шжз4",
    "шжк4",
    "шжл4",
    "шжм4",
    "шжн4",
    "шжп4",
    "шжр4",
    "4шжс4",
    "шжт4",
    "4шжф4",
    "4шжх4",
    "шжц4",
    "шжч4",
    "4шжш4",
    "шжщ4",
    "4ш3з4",
    "8шз.",
    "шзб4",
    "шзв4",
    "шзг4",
    "шзд4",
    "4шзж4",
    "4шзз4",
    "шзк4",
    "шзл4",
    "шзм4",
    "шзн4",
    "шзп4",
    "шзр4",
    "4шзс4",
    "шзт4",
    "4шзф4",
    "4шзх4",
    "шзц4",
    "шзч4",
    "4шзш4",
    "шзщ4",
    "шй4",
    "2ш3к",
    "8шк.",
    "4шкб",
    "4шкг",
    "4шкд",
    "4шкж4",
    "4шкз4",
    "4шкк",
    "4шкс4",
    "4шкф4",
    "4шкх4",
    "4шкш4",
    "2ш3л4",
    "8шл.",
    "4шлж4",
    "4шлз4",
    "4шлл",
    "4шлш4",
    "2ш3м4",
    "8шм.",
    "4шмж4",
    "4шмз4",
    "4шмм",
    "4шмш4",
    "2ш3н4",
    "8шн.",
    "4шнж4",
    "4шнз4",
    "4шнн",
    "4шнш4",
    "2ш3п",
    "8шп.",
    "4шпб",
    "4шпг",
    "4шпд",
    "4шпж4",
    "4шпз4",
    "4шпп",
    "4шпс4",
    "4шпф4",
    "4шпх4",
    "4шпш4",
    "2ш3р4",
    "8шр.",
    "4шрж4",
    "4шрз4",
    "4шрр",
    "4шрш4",
    "2ш3с",
    "8шс.",
    "4шсж4",
    "4шсз4",
    "4шсс",
    "4шсш4",
    "2ш3т",
    "8шт.",
    "4штб",
    "4штг",
    "4штд",
    "4штж4",
    "4штз4",
    "4штк",
    "4штп",
    "4штс4",
    "4штт",
    "4штф4",
    "4штх4",
    "4штц",
    "4штч",
    "4штш4",
    "2ш3ф",
    "8шф.",
    "4шфв",
    "4шфж4",
    "4шфз4",
    "4шфф",
    "4шфш4",
    "2ш3х",
    "8шх.",
    "4шхж4",
    "4шхз4",
    "4шхх",
    "4шхш4",
    "2ш3ц",
    "8шц.",
    "4шцб",
    "4шцг",
    "4шцд",
    "4шцж4",
    "4шцз4",
    "4шцк",
    "4шцп",
    "4шцс4",
    "4шцт",
    "4шцф4",
    "4шцх4",
    "4шцц",
    "4шцч",
    "4шцш4",
    "2ш3ч",
    "8шч.",
    "4шчб",
    "4шчг",
    "4шчд",
    "4шчж4",
    "4шчз4",
    "4шчк",
    "4шчп",
    "4шчс4",
    "4шчт",
    "4шчф4",
    "4шчх4",
    "4шчц",
    "4шчч",
    "4шчш4",
    "4ш3ш4",
    "8шш.",
    "шшб4",
    "шшв4",
    "шшг4",
    "шшд4",
    "4шшж4",
    "4шшз4",
    "шшк4",
    "шшл4",
    "шшм4",
    "шшн4",
    "шшп4",
    "шшр4",
    "шшс4",
    "шшт4",
    "шшф4",
    "шшх4",
    "шшц4",
    "шшч4",
    "4шшш4",
    "шшщ4",
    "2ш3щ",
    "8шщ.",
    "4шщж4",
    "4шщз4",
    "4шщш4",
    "4шщщ",
    "2щ3б4",
    "8щб.",
    "4щбб",
    "4щбк",
    "4щбп",
    "4щбт",
    "4щбц",
    "4щбч",
    "4щбщ4",
    "2щ3в4",
    "8щв.",
    "4щвв",
    "4щвф",
    "4щвщ4",
    "2щ3г4",
    "8щг.",
    "4щгг",
    "4щгк",
    "4щгп",
    "4щгт",
    "4щгц",
    "4щгч",
    "4щгщ4",
    "2щ3д4",
    "8щд.",
    "4щдб",
    "4щдг",
    "4щдд",
    "4щдк",
    "4щдп",
    "4щдт",
    "4щдц",
    "4щдч",
    "4щдщ4",
    "2щ3ж4",
    "8щж.",
    "4щжж",
    "4щжс",
    "4щжф",
    "4щжх",
    "4щжш",
    "4щжщ4",
    "2щ3з4",
    "8щз.",
    "4щзз",
    "4щзс",
    "4щзф",
    "4щзх",
    "4щзш",
    "4щзщ4",
    "щй4",
    "2щ3к",
    "8щк.",
    "4щкб",
    "4щкг",
    "4щкд",
    "4щкк",
    "4щкщ4",
    "2щ3л4",
    "8щл.",
    "4щлл",
    "4щлщ4",
    "2щ3м4",
    "8щм.",
    "4щмм",
    "4щмщ4",
    "2щ3н4",
    "8щн.",
    "4щнн",
    "4щнщ4",
    "2щ3п",
    "8щп.",
    "4щпб",
    "4щпг",
    "4щпд",
    "4щпп",
    "4щпщ4",
    "2щ3р4",
    "8щр.",
    "4щрр",
    "4щрщ4",
    "2щ3с",
    "8щс.",
    "4щсж",
    "4щсз",
    "4щсс",
    "4щсщ4",
    "2щ3т",
    "8щт.",
    "4щтб",
    "4щтг",
    "4щтд",
    "4щтк",
    "4щтп",
    "4щтт",
    "4щтц",
    "4щтч",
    "4щтщ4",
    "2щ3ф",
    "8щф.",
    "4щфв",
    "4щфж",
    "4щфз",
    "4щфф",
    "4щфщ4",
    "2щ3х",
    "8щх.",
    "4щхж",
    "4щхз",
    "4щхх",
    "4щхщ4",
    "2щ3ц",
    "8щц.",
    "4щцб",
    "4щцг",
    "4щцд",
    "4щцк",
    "4щцп",
    "4щцт",
    "4щцц",
    "4щцч",
    "4щцщ4",
    "2щ3ч",
    "8щч.",
    "4щчб",
    "4щчг",
    "4щчд",
    "4щчк",
    "4щчп",
    "4щчт",
    "4щчц",
    "4щчч",
    "4щчщ4",
    "2щ3ш",
    "8щш.",
    "4щшж",
    "4щшз",
    "4щшш",
    "4щшщ4",
    "4щ3щ4",
    "8щщ.",
    "щщб4",
    "щщв4",
    "щщг4",
    "щщд4",
    "щщж4",
    "щщз4",
    "щщк4",
    "щщл4",
    "щщм4",
    "щщн4",
    "щщп4",
    "щщр4",
    "щщс4",
    "щщт4",
    "щщф4",
    "щщх4",
    "щщц4",
    "щщч4",
    "щщш4",
    "4щщщ4",
    "ъ1",
    "ю1",
    "я1",
    ""
  ];

  var endinput;

  return {
    patterns: patterns,
    exceptions: hyphenation
  };
});
