import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { Box } from '@rocket.chat/fuselage';
import { VerticalWizardLayout, VerticalWizardLayoutTitle, VerticalWizardLayoutFooter } from '@rocket.chat/layout';
import { useSetting, useAssetWithDarkModePath } from '@rocket.chat/ui-contexts';
import LoginPoweredBy from '../components/LoginPoweredBy';
import LoginSwitchLanguageFooter from '../components/LoginSwitchLanguageFooter';
import LoginTerms from '../components/LoginTerms';
import { RegisterTitle } from '../components/RegisterTitle';
const VerticalTemplate = ({ children }) => {
    const hideLogo = useSetting('Layout_Login_Hide_Logo', false);
    const customLogo = useAssetWithDarkModePath('logo');
    const customBackground = useAssetWithDarkModePath('background');
    return (_jsxs(VerticalWizardLayout, { background: customBackground, logo: !hideLogo && customLogo ? _jsx(Box, { is: 'img', maxHeight: 'x40', mi: 'neg-x8', src: customLogo, alt: 'Logo' }) : _jsx(_Fragment, {}), children: [_jsx(VerticalWizardLayoutTitle, { children: _jsx(RegisterTitle, {}) }), _jsx(LoginPoweredBy, {}), children, _jsxs(VerticalWizardLayoutFooter, { children: [_jsx(LoginTerms, {}), _jsx(LoginSwitchLanguageFooter, {})] })] }));
};
export default VerticalTemplate;
//# sourceMappingURL=VerticalTemplate.js.map