var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Button } from '@rocket.chat/fuselage';
import { useLocalStorage } from '@rocket.chat/fuselage-hooks';
import { HorizontalWizardLayoutCaption } from '@rocket.chat/layout';
import { normalizeLanguage } from '@rocket.chat/tools';
import { useSetting, useLoadLanguage, useLanguage, useLanguages } from '@rocket.chat/ui-contexts';
import { useMemo, useEffect } from 'react';
import { Trans, useTranslation } from 'react-i18next';
const useSuggestedLanguages = (_a) => {
    var _b;
    var { browserLanguage = normalizeLanguage((_b = window.navigator.language) !== null && _b !== void 0 ? _b : 'en'), } = _a;
    const availableLanguages = useLanguages();
    const currentLanguage = useLanguage();
    const serverLanguage = normalizeLanguage(useSetting('Language', 'en'));
    const suggestions = useMemo(() => {
        const potentialLanguages = new Set([serverLanguage, browserLanguage, 'en'].map(normalizeLanguage));
        const potentialSuggestions = Array.from(potentialLanguages).map((potentialLanguageKey) => availableLanguages.find((language) => language.key === potentialLanguageKey));
        return potentialSuggestions.filter((language) => {
            return !!language && language.key !== currentLanguage;
        });
    }, [serverLanguage, browserLanguage, availableLanguages, currentLanguage]);
    const { i18n } = useTranslation();
    useEffect(() => {
        i18n.loadLanguages(suggestions.map((suggestion) => suggestion.key));
    }, [i18n, suggestions]);
    return { suggestions };
};
const LoginSwitchLanguageFooter = (_a) => {
    var _b;
    var { browserLanguage = normalizeLanguage((_b = window.navigator.language) !== null && _b !== void 0 ? _b : 'en'), } = _a;
    const loadLanguage = useLoadLanguage();
    const { suggestions } = useSuggestedLanguages({ browserLanguage });
    const [, setPreferedLanguage] = useLocalStorage('preferedLanguage', '');
    const handleSwitchLanguageClick = (language) => (event) => __awaiter(void 0, void 0, void 0, function* () {
        event.preventDefault();
        yield loadLanguage(language.key);
        setPreferedLanguage(language.key);
    });
    if (!suggestions.length) {
        return null;
    }
    return (_jsx(HorizontalWizardLayoutCaption, { children: suggestions.map((suggestion) => {
            // If suggestion is "Default", skip it
            if (!suggestion.key) {
                return;
            }
            return (_jsx(Button, { secondary: true, small: true, mie: 8, onClick: handleSwitchLanguageClick(suggestion), children: _jsxs(Trans, { i18nKey: 'registration.component.switchLanguage', tOptions: { lng: suggestion.key }, values: { name: suggestion.ogName }, children: ["Change to ", _jsx("strong", { children: suggestion.ogName })] }) }, suggestion.key));
        }) }));
};
export default LoginSwitchLanguageFooter;
//# sourceMappingURL=LoginSwitchLanguageFooter.js.map