import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { FieldGroup, TextInput, Field, FieldLabel, FieldRow, FieldError, ButtonGroup, Button, Callout } from '@rocket.chat/fuselage';
import { Form, ActionLink } from '@rocket.chat/layout';
import { useDocumentTitle } from '@rocket.chat/ui-client';
import { useEffect, useId, useRef } from 'react';
import { useForm } from 'react-hook-form';
import { useTranslation } from 'react-i18next';
import { useSendForgotPassword } from './hooks/useSendForgotPassword';
export const ResetPasswordForm = ({ setLoginRoute }) => {
    var _a;
    const { t } = useTranslation();
    const emailId = useId();
    const formLabelId = useId();
    const forgotPasswordFormRef = useRef(null);
    useDocumentTitle(t('registration.component.resetPassword'), false);
    const { register, handleSubmit, formState: { errors, isSubmitting }, } = useForm({ mode: 'onBlur' });
    useEffect(() => {
        if (forgotPasswordFormRef.current) {
            forgotPasswordFormRef.current.focus();
        }
    }, []);
    const { mutateAsync, isSuccess } = useSendForgotPassword();
    return (_jsxs(Form, { ref: forgotPasswordFormRef, tabIndex: -1, "aria-labelledby": formLabelId, "aria-describedby": 'welcomeTitle', onSubmit: handleSubmit((data) => {
            mutateAsync({ email: data.email });
        }), children: [_jsx(Form.Header, { children: _jsx(Form.Title, { id: formLabelId, children: t('registration.component.resetPassword') }) }), _jsxs(Form.Container, { children: [_jsx(FieldGroup, { children: _jsxs(Field, { children: [_jsx(FieldLabel, { required: true, htmlFor: emailId, children: t('registration.component.form.email') }), _jsx(FieldRow, { children: _jsx(TextInput, Object.assign({}, register('email', {
                                        required: t('Required_field', { field: t('registration.component.form.email') }),
                                        pattern: {
                                            value: /^[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,}$/i,
                                            message: t('registration.page.resetPassword.errors.invalidEmail'),
                                        },
                                    }), { error: (_a = errors.email) === null || _a === void 0 ? void 0 : _a.message, "aria-invalid": Boolean(errors.email), "aria-required": 'true', "aria-describedby": `${emailId}-error`, placeholder: t('registration.component.form.emailPlaceholder'), id: emailId })) }), errors.email && (_jsx(FieldError, { "aria-live": 'assertive', id: `${emailId}-error`, children: errors.email.message }))] }) }), isSuccess && (_jsx(FieldGroup, { children: _jsx(Callout, { "aria-live": 'assertive', role: 'status', mbs: 24, icon: 'mail', children: t('registration.page.resetPassword.sent') }) }))] }), _jsxs(Form.Footer, { children: [_jsx(ButtonGroup, { children: _jsx(Button, { type: 'submit', loading: isSubmitting, primary: true, children: t('registration.page.resetPassword.sendInstructions') }) }), _jsx(ActionLink, { onClick: () => {
                            setLoginRoute('login');
                        }, children: t('registration.page.register.back') })] })] }));
};
export default ResetPasswordForm;
//# sourceMappingURL=ResetPasswordForm.js.map