import { jsx as _jsx } from "react/jsx-runtime";
import { useDocumentTitle } from '@rocket.chat/ui-client';
import { useSetting } from '@rocket.chat/ui-contexts';
import { useTranslation } from 'react-i18next';
import RegisterForm from './RegisterForm';
import RegisterFormDisabled from './RegisterFormDisabled';
import RegisterTemplate from './RegisterTemplate';
import SecretRegisterForm from './SecretRegisterForm';
import SecretRegisterInvalidForm from './SecretRegisterInvalidForm';
import FormSkeleton from './template/FormSkeleton';
export const RegisterSecretPageRouter = ({ setLoginRoute, origin, }) => {
    const { t } = useTranslation();
    const registrationMode = useSetting('Accounts_RegistrationForm', 'Public');
    const isPublicRegistration = registrationMode === 'Public';
    const isRegistrationAllowedForSecret = registrationMode === 'Secret URL';
    const isRegistrationDisabled = registrationMode === 'Disabled' || (origin === 'register' && isRegistrationAllowedForSecret);
    useDocumentTitle(t('registration.component.form.createAnAccount'), false);
    if (origin === 'secret-register' && !isRegistrationAllowedForSecret) {
        return _jsx(SecretRegisterInvalidForm, {});
    }
    if (isPublicRegistration || (origin === 'invite-register' && isRegistrationAllowedForSecret)) {
        return (_jsx(RegisterTemplate, { children: _jsx(RegisterForm, { setLoginRoute: setLoginRoute }) }));
    }
    if (isRegistrationDisabled) {
        return (_jsx(RegisterTemplate, { children: _jsx(RegisterFormDisabled, { setLoginRoute: setLoginRoute }) }));
    }
    if (isRegistrationAllowedForSecret) {
        return _jsx(SecretRegisterForm, { setLoginRoute: setLoginRoute });
    }
    return (_jsx(RegisterTemplate, { children: _jsx(FormSkeleton, {}) }));
};
export default RegisterSecretPageRouter;
//# sourceMappingURL=RegisterSecretPageRouter.js.map