import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Callout } from '@rocket.chat/fuselage';
import { Form, ActionLink } from '@rocket.chat/layout';
import { useSetting } from '@rocket.chat/ui-contexts';
import { Trans, useTranslation } from 'react-i18next';
export const RegisterFormDisabled = ({ setLoginRoute }) => {
    const linkReplacementText = useSetting('Accounts_RegistrationForm_LinkReplacementText', '');
    const { t } = useTranslation();
    return (_jsxs(Form, { children: [_jsx(Form.Header, { children: _jsx(Form.Title, { children: t('registration.component.form.register') }) }), _jsx(Form.Container, { children: _jsx(Callout, { role: 'status', type: 'warning', children: linkReplacementText }) }), _jsx(Form.Footer, { children: _jsx(ActionLink, { onClick: () => {
                        setLoginRoute('login');
                    }, children: _jsx(Trans, { i18nKey: 'registration.page.register.back', children: "Back to Login" }) }) })] }));
};
export default RegisterFormDisabled;
//# sourceMappingURL=RegisterFormDisabled.js.map