var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
/* eslint-disable complexity */
import { FieldGroup, TextInput, Field, FieldLabel, FieldRow, FieldError, PasswordInput, ButtonGroup, Button, TextAreaInput, Callout, } from '@rocket.chat/fuselage';
import { Form, ActionLink } from '@rocket.chat/layout';
import { CustomFieldsForm, PasswordVerifier, useValidatePassword } from '@rocket.chat/ui-client';
import { useAccountsCustomFields, useSetting, useToastMessageDispatch } from '@rocket.chat/ui-contexts';
import { useEffect, useId, useRef, useState } from 'react';
import { useForm } from 'react-hook-form';
import { Trans, useTranslation } from 'react-i18next';
import EmailConfirmationForm from './EmailConfirmationForm';
import { useRegisterMethod } from './hooks/useRegisterMethod';
export const RegisterForm = ({ setLoginRoute }) => {
    var _a, _b, _c, _d, _e, _f, _g;
    const { t } = useTranslation();
    const requireNameForRegister = useSetting('Accounts_RequireNameForSignUp', true);
    const requiresPasswordConfirmation = useSetting('Accounts_RequirePasswordConfirmation', true);
    const manuallyApproveNewUsersRequired = useSetting('Accounts_ManuallyApproveNewUsers', false);
    const usernameOrEmailPlaceholder = useSetting('Accounts_EmailOrUsernamePlaceholder', '');
    const passwordPlaceholder = useSetting('Accounts_PasswordPlaceholder', '');
    const passwordConfirmationPlaceholder = useSetting('Accounts_ConfirmPasswordPlaceholder', '');
    const formLabelId = useId();
    const passwordVerifierId = useId();
    const nameId = useId();
    const emailId = useId();
    const usernameId = useId();
    const passwordId = useId();
    const passwordConfirmationId = useId();
    const reasonId = useId();
    const registerUser = useRegisterMethod();
    const customFields = useAccountsCustomFields();
    const [serverError, setServerError] = useState(undefined);
    const dispatchToastMessage = useToastMessageDispatch();
    const { register, handleSubmit, setError, watch, getValues, clearErrors, control, formState: { errors }, } = useForm({ mode: 'onBlur' });
    const { password } = watch();
    const passwordIsValid = useValidatePassword(password);
    const registerFormRef = useRef(null);
    useEffect(() => {
        if (registerFormRef.current) {
            registerFormRef.current.focus();
        }
    }, []);
    const handleRegister = (_a) => __awaiter(void 0, void 0, void 0, function* () {
        var { password, passwordConfirmation: _ } = _a, formData = __rest(_a, ["password", "passwordConfirmation"]);
        registerUser.mutate(Object.assign({ pass: password }, formData), {
            onError: (error) => {
                if ([error.error, error.errorType].includes('error-invalid-email')) {
                    setError('email', { type: 'invalid-email', message: t('registration.component.form.invalidEmail') });
                }
                if (error.errorType === 'error-user-already-exists') {
                    setError('username', { type: 'user-already-exists', message: t('registration.component.form.usernameAlreadyExists') });
                }
                if (/Email already exists/.test(error.error)) {
                    setError('email', { type: 'email-already-exists', message: t('registration.component.form.emailAlreadyExists') });
                }
                if (/Username is already in use/.test(error.error)) {
                    setError('username', { type: 'username-already-exists', message: t('registration.component.form.userAlreadyExist') });
                }
                if (/The username provided is not valid/.test(error.error)) {
                    setError('username', {
                        type: 'username-contains-invalid-chars',
                        message: t('registration.component.form.usernameContainsInvalidChars'),
                    });
                }
                if (/Name contains invalid characters/.test(error.error)) {
                    setError('name', { type: 'name-contains-invalid-chars', message: t('registration.component.form.nameContainsInvalidChars') });
                }
                if (/error-too-many-requests/.test(error.error)) {
                    dispatchToastMessage({ type: 'error', message: error.error });
                }
                if (/error-user-is-not-activated/.test(error.error)) {
                    dispatchToastMessage({ type: 'info', message: t('registration.page.registration.waitActivationWarning') });
                    setLoginRoute('login');
                }
                if (error.error === 'error-user-registration-custom-field') {
                    setServerError(error.message);
                }
            },
        });
    });
    if (((_a = errors.email) === null || _a === void 0 ? void 0 : _a.type) === 'invalid-email') {
        return _jsx(EmailConfirmationForm, { onBackToLogin: () => clearErrors('email'), email: getValues('email') });
    }
    return (_jsxs(Form, { tabIndex: -1, ref: registerFormRef, "aria-labelledby": formLabelId, "aria-describedby": 'welcomeTitle', onSubmit: handleSubmit(handleRegister), children: [_jsx(Form.Header, { children: _jsx(Form.Title, { id: formLabelId, children: t('registration.component.form.createAnAccount') }) }), _jsx(Form.Container, { children: _jsxs(FieldGroup, { children: [_jsxs(Field, { children: [_jsx(FieldLabel, { required: requireNameForRegister, htmlFor: nameId, children: t('registration.component.form.name') }), _jsx(FieldRow, { children: _jsx(TextInput, Object.assign({}, register('name', {
                                        required: requireNameForRegister ? t('Required_field', { field: t('registration.component.form.name') }) : false,
                                    }), { error: (_b = errors === null || errors === void 0 ? void 0 : errors.name) === null || _b === void 0 ? void 0 : _b.message, "aria-required": requireNameForRegister, "aria-invalid": errors.name ? 'true' : 'false', placeholder: t('onboarding.form.adminInfoForm.fields.fullName.placeholder'), "aria-describedby": `${nameId}-error`, id: nameId })) }), errors.name && (_jsx(FieldError, { role: 'alert', id: `${nameId}-error`, children: errors.name.message }))] }), _jsxs(Field, { children: [_jsx(FieldLabel, { required: true, htmlFor: emailId, children: t('registration.component.form.email') }), _jsx(FieldRow, { children: _jsx(TextInput, Object.assign({}, register('email', {
                                        required: t('Required_field', { field: t('registration.component.form.email') }),
                                        pattern: {
                                            value: /^[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,}$/i,
                                            message: t('registration.component.form.invalidEmail'),
                                        },
                                    }), { placeholder: usernameOrEmailPlaceholder || t('registration.component.form.emailPlaceholder'), error: (_c = errors === null || errors === void 0 ? void 0 : errors.email) === null || _c === void 0 ? void 0 : _c.message, "aria-required": 'true', "aria-invalid": errors.email ? 'true' : 'false', "aria-describedby": `${emailId}-error`, id: emailId })) }), errors.email && (_jsx(FieldError, { role: 'alert', id: `${emailId}-error`, children: errors.email.message }))] }), _jsxs(Field, { children: [_jsx(FieldLabel, { required: true, htmlFor: usernameId, children: t('registration.component.form.username') }), _jsx(FieldRow, { children: _jsx(TextInput, Object.assign({}, register('username', {
                                        required: t('Required_field', { field: t('registration.component.form.username') }),
                                    }), { error: (_d = errors === null || errors === void 0 ? void 0 : errors.username) === null || _d === void 0 ? void 0 : _d.message, "aria-required": 'true', "aria-invalid": errors.username ? 'true' : 'false', "aria-describedby": `${usernameId}-error`, id: usernameId, placeholder: 'jon.doe' })) }), errors.username && (_jsx(FieldError, { role: 'alert', id: `${usernameId}-error`, children: errors.username.message }))] }), _jsxs(Field, { children: [_jsx(FieldLabel, { required: true, htmlFor: passwordId, children: t('registration.component.form.password') }), _jsx(FieldRow, { children: _jsx(PasswordInput, Object.assign({}, register('password', {
                                        required: t('Required_field', { field: t('registration.component.form.password') }),
                                        validate: () => (!passwordIsValid ? t('Password_must_meet_the_complexity_requirements') : true),
                                    }), { error: (_e = errors.password) === null || _e === void 0 ? void 0 : _e.message, "aria-required": 'true', "aria-invalid": errors.password ? 'true' : undefined, id: passwordId, placeholder: passwordPlaceholder || t('Create_a_password'), "aria-describedby": `${passwordVerifierId} ${passwordId}-error` })) }), (errors === null || errors === void 0 ? void 0 : errors.password) && (_jsx(FieldError, { role: 'alert', id: `${passwordId}-error`, children: errors.password.message })), _jsx(PasswordVerifier, { password: password, id: passwordVerifierId })] }), requiresPasswordConfirmation && (_jsxs(Field, { children: [_jsx(FieldLabel, { required: true, htmlFor: passwordConfirmationId, children: t('registration.component.form.confirmPassword') }), _jsx(FieldRow, { children: _jsx(PasswordInput, Object.assign({}, register('passwordConfirmation', {
                                        required: t('Required_field', { field: t('registration.component.form.confirmPassword') }),
                                        deps: ['password'],
                                        validate: (val) => (watch('password') === val ? true : t('registration.component.form.invalidConfirmPass')),
                                    }), { error: (_f = errors.passwordConfirmation) === null || _f === void 0 ? void 0 : _f.message, "aria-required": 'true', "aria-invalid": errors.passwordConfirmation ? 'true' : 'false', id: passwordConfirmationId, "aria-describedby": `${passwordConfirmationId}-error`, placeholder: passwordConfirmationPlaceholder || t('Confirm_password'), disabled: !passwordIsValid })) }), errors.passwordConfirmation && (_jsx(FieldError, { role: 'alert', id: `${passwordConfirmationId}-error`, children: errors.passwordConfirmation.message }))] })), manuallyApproveNewUsersRequired && (_jsxs(Field, { children: [_jsx(FieldLabel, { required: true, htmlFor: reasonId, children: t('registration.component.form.reasonToJoin') }), _jsx(FieldRow, { children: _jsx(TextAreaInput, Object.assign({}, register('reason', {
                                        required: t('Required_field', { field: t('registration.component.form.reasonToJoin') }),
                                    }), { error: (_g = errors === null || errors === void 0 ? void 0 : errors.reason) === null || _g === void 0 ? void 0 : _g.message, "aria-required": 'true', "aria-invalid": errors.reason ? 'true' : 'false', "aria-describedby": `${reasonId}-error`, id: reasonId })) }), errors.reason && (_jsx(FieldError, { role: 'alert', id: `${reasonId}-error`, children: errors.reason.message }))] })), _jsx(CustomFieldsForm, { formName: 'customFields', formControl: control, metadata: customFields }), serverError && _jsx(Callout, { type: 'danger', children: serverError })] }) }), _jsxs(Form.Footer, { children: [_jsx(ButtonGroup, { children: _jsx(Button, { type: 'submit', loading: registerUser.isPending, primary: true, children: t('registration.component.form.joinYourTeam') }) }), _jsx(ActionLink, { onClick: () => {
                            setLoginRoute('login');
                        }, children: _jsx(Trans, { i18nKey: 'registration.page.register.back', children: "Back to Login" }) })] })] }));
};
export default RegisterForm;
//# sourceMappingURL=RegisterForm.js.map