import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { FieldGroup, TextInput, Field, FieldLabel, FieldRow, FieldError, ButtonGroup, Button, Callout } from '@rocket.chat/fuselage';
import { Form, ActionLink } from '@rocket.chat/layout';
import { useForm } from 'react-hook-form';
import { useTranslation } from 'react-i18next';
import { useLoginSendEmailConfirmation } from './hooks/useLoginSendEmailConfirmation';
export const EmailConfirmationForm = ({ email, onBackToLogin }) => {
    var _a;
    const { t } = useTranslation();
    const basicEmailRegex = /^[^@]+@[^@]+$/;
    const isEmail = basicEmailRegex.test(email || '');
    const { register, handleSubmit, formState: { errors }, } = useForm({
        defaultValues: {
            email: isEmail ? email : '',
        },
    });
    const sendEmail = useLoginSendEmailConfirmation();
    return (_jsxs(Form, { onSubmit: handleSubmit((data) => {
            if (sendEmail.isPending) {
                return;
            }
            sendEmail.mutate(data.email);
        }), children: [_jsxs(Form.Header, { children: [_jsx(Form.Title, { children: t('registration.component.form.confirmation') }), _jsx(Form.Subtitle, { children: t('registration.page.emailVerification.subTitle') })] }), _jsxs(Form.Container, { children: [_jsx(FieldGroup, { disabled: sendEmail.isPending || sendEmail.isSuccess, children: _jsxs(Field, { children: [_jsxs(FieldLabel, { htmlFor: 'email', children: [t('registration.component.form.email'), "*"] }), _jsx(FieldRow, { children: _jsx(TextInput, Object.assign({}, register('email', {
                                        required: true,
                                    }), { error: errors.email && t('registration.component.form.requiredField'), "aria-invalid": ((_a = errors === null || errors === void 0 ? void 0 : errors.email) === null || _a === void 0 ? void 0 : _a.type) === 'required', placeholder: t('registration.component.form.emailPlaceholder'), id: 'email' })) }), errors.email && _jsx(FieldError, { children: t('registration.component.form.requiredField') })] }) }), sendEmail.isSuccess && (_jsx(FieldGroup, { children: _jsx(Callout, { type: 'success', children: t('registration.page.emailVerification.sent') }) }))] }), _jsxs(Form.Footer, { children: [_jsx(ButtonGroup, { children: _jsx(Button, { loading: sendEmail.isPending, type: 'submit', primary: true, children: t('registration.component.form.sendConfirmationEmail') }) }), _jsx(ActionLink, { onClick: () => {
                            onBackToLogin();
                        }, children: t('registration.page.register.back') })] })] }));
};
export default EmailConfirmationForm;
//# sourceMappingURL=EmailConfirmationForm.js.map