import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Box, IconButton } from '@rocket.chat/fuselage';
import { VerticalWizardLayout, VerticalWizardLayoutFooter, VerticalWizardLayoutForm, VerticalWizardLayoutTitle } from '@rocket.chat/layout';
import { useSetting, useTranslation, useAssetWithDarkModePath } from '@rocket.chat/ui-contexts';
import { LoginPoweredBy } from './components/LoginPoweredBy';
const CMSPage = ({ page }) => {
    const t = useTranslation();
    const pageContent = useSetting(page, '');
    const customLogo = useAssetWithDarkModePath('logo');
    const customBackground = useAssetWithDarkModePath('background');
    return (_jsxs(VerticalWizardLayout, { background: customBackground, logo: customLogo ? _jsx(Box, { is: 'img', maxHeight: 'x40', mi: 'neg-x8', src: customLogo, alt: 'Logo' }) : undefined, children: [_jsx(VerticalWizardLayoutTitle, { children: t(page) }), _jsx(VerticalWizardLayoutForm, { children: _jsxs(Box, { p: 32, children: [_jsx(IconButton, { title: t('Back'), icon: 'arrow-back', onClick: () => window.history.back(), style: { float: 'right' } }), _jsx(Box, { withRichContent: true, dangerouslySetInnerHTML: { __html: pageContent } })] }) }), _jsx(VerticalWizardLayoutFooter, { children: _jsx(LoginPoweredBy, {}) })] }));
};
export default CMSPage;
//# sourceMappingURL=CMSPage.js.map