import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { ButtonGroup } from '@rocket.chat/fuselage';
import { useTranslation } from 'react-i18next';
import { useMediaCallContext } from '../MediaCallContext';
import { ToggleButton, PeerInfo, Widget, WidgetFooter, WidgetHandle, WidgetHeader, WidgetContent, WidgetInfo, Timer, DevicePicker, ActionButton, } from '../components';
import { useInfoSlots } from '../useInfoSlots';
import { useKeypad } from '../useKeypad';
const OngoingCall = () => {
    const { t } = useTranslation();
    const { muted, held, remoteMuted, remoteHeld, onMute, onHold, onForward, onEndCall, onTone, peerInfo, connectionState } = useMediaCallContext();
    const { element: keypad, buttonProps: keypadButtonProps } = useKeypad(onTone);
    const slots = useInfoSlots(muted, held, connectionState);
    const remoteSlots = useInfoSlots(remoteMuted, remoteHeld);
    const connecting = connectionState === 'CONNECTING';
    const reconnecting = connectionState === 'RECONNECTING';
    // TODO: Figure out how to ensure this always exist before rendering the component
    if (!peerInfo) {
        throw new Error('Peer info is required');
    }
    return (_jsxs(Widget, { children: [_jsx(WidgetHandle, {}), _jsx(WidgetHeader, { title: connecting ? t('meteor_status_connecting') : _jsx(Timer, {}), children: _jsx(DevicePicker, {}) }), _jsx(WidgetContent, { children: _jsx(PeerInfo, Object.assign({}, peerInfo, { slots: remoteSlots, remoteMuted: remoteMuted })) }), _jsx(WidgetInfo, { slots: slots }), _jsxs(WidgetFooter, { children: [keypad, _jsxs(ButtonGroup, { large: true, children: [_jsx(ActionButton, Object.assign({ disabled: connecting || reconnecting, icon: 'dialpad', label: 'Dialpad' }, keypadButtonProps)), _jsx(ToggleButton, { label: t('Mute'), icons: ['mic', 'mic-off'], titles: [t('Mute'), t('Unmute')], pressed: muted, onToggle: onMute }), _jsx(ToggleButton, { label: t('Hold'), icons: ['pause-shape-unfilled', 'pause-shape-unfilled'], titles: [t('Hold'), t('Resume')], pressed: held, onToggle: onHold }), _jsx(ActionButton, { disabled: connecting || reconnecting, label: t('Forward'), icon: 'arrow-forward', onClick: onForward }), _jsx(ActionButton, { label: t('Voice_call__user__hangup', { user: 'userId' in peerInfo ? peerInfo.displayName : peerInfo.number }), icon: 'phone-off', danger: true, onClick: onEndCall })] })] })] }));
};
export default OngoingCall;
//# sourceMappingURL=OngoingCall.js.map