import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Box, Button, ButtonGroup } from '@rocket.chat/fuselage';
import { useTranslation } from 'react-i18next';
import { useMediaCallContext, usePeerAutocomplete } from '../MediaCallContext';
import { PeerInfo, PeerAutocomplete, Widget, WidgetFooter, WidgetHandle, WidgetHeader, WidgetContent, DevicePicker, ActionButton, } from '../components';
const NewCall = () => {
    const { t } = useTranslation();
    const { onCall, onToggleWidget, peerInfo, onSelectPeer } = useMediaCallContext();
    const autocomplete = usePeerAutocomplete(onSelectPeer, peerInfo);
    return (_jsxs(Widget, { children: [_jsx(WidgetHandle, {}), _jsx(WidgetHeader, { title: t('New_call'), children: _jsx(ActionButton, { tiny: true, secondary: false, label: t('Close'), icon: 'cross', onClick: onToggleWidget }) }), _jsxs(WidgetContent, { children: [_jsx(PeerAutocomplete, Object.assign({}, autocomplete)), peerInfo && (_jsx(Box, { mb: 8, children: _jsx(PeerInfo, Object.assign({}, peerInfo)) }))] }), _jsx(WidgetFooter, { children: _jsxs(ButtonGroup, { stretch: true, children: [_jsx(DevicePicker, { secondary: true }), _jsx(Button, { medium: true, icon: 'phone', success: true, flexGrow: 1, onClick: onCall, children: t('Call') })] }) })] }));
};
export default NewCall;
//# sourceMappingURL=NewCall.js.map