import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Button, ButtonGroup } from '@rocket.chat/fuselage';
import { useTranslation } from 'react-i18next';
import { useMediaCallContext } from '../MediaCallContext';
import { DevicePicker, PeerInfo, Widget, WidgetFooter, WidgetHandle, WidgetHeader, WidgetContent, WidgetInfo } from '../components';
const IncomingCallTransfer = () => {
    const { t } = useTranslation();
    const { onEndCall, onAccept, peerInfo, transferredBy } = useMediaCallContext();
    if (!peerInfo) {
        throw new Error('Peer info is required');
    }
    return (_jsxs(Widget, { children: [_jsx(WidgetHandle, {}), _jsx(WidgetHeader, { title: `${t('Transferring_call_incoming')}...`, children: _jsx(DevicePicker, {}) }), transferredBy && _jsx(WidgetInfo, { slots: [{ text: t('Transferring_call_incoming__from_', { from: transferredBy }), type: 'info' }] }), _jsx(WidgetContent, { children: _jsx(PeerInfo, Object.assign({}, peerInfo)) }), _jsx(WidgetFooter, { children: _jsxs(ButtonGroup, { stretch: true, children: [_jsx(Button, { medium: true, name: 'phone', icon: 'phone-off', danger: true, flexGrow: 1, onClick: onEndCall, children: t('Reject') }), _jsx(Button, { medium: true, name: 'phone', icon: 'phone', success: true, flexGrow: 1, onClick: () => void onAccept(), children: t('Accept') })] }) })] }));
};
export default IncomingCallTransfer;
//# sourceMappingURL=IncomingCallTransfer.js.map