import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Button, ButtonGroup } from '@rocket.chat/fuselage';
import { useTranslation } from 'react-i18next';
import { useMediaCallContext } from '../MediaCallContext';
import { DevicePicker, PeerInfo, Widget, WidgetFooter, WidgetHandle, WidgetHeader, WidgetContent } from '../components';
const IncomingCall = () => {
    const { t } = useTranslation();
    const { onEndCall, onAccept, peerInfo } = useMediaCallContext();
    // TODO: Figure out how to ensure this always exist before rendering the component
    if (!peerInfo) {
        throw new Error('Peer info is required');
    }
    return (_jsxs(Widget, { children: [_jsx(WidgetHandle, {}), _jsx(WidgetHeader, { title: `${t('Incoming_call')}...`, children: _jsx(DevicePicker, {}) }), _jsx(WidgetContent, { children: _jsx(PeerInfo, Object.assign({}, peerInfo)) }), _jsx(WidgetFooter, { children: _jsxs(ButtonGroup, { stretch: true, children: [_jsx(Button, { medium: true, name: 'phone', icon: 'phone-off', danger: true, flexGrow: 1, onClick: onEndCall, children: t('Reject') }), _jsx(Button, { medium: true, name: 'phone', icon: 'phone', success: true, flexGrow: 1, onClick: () => void onAccept(), children: t('Accept') })] }) })] }));
};
export default IncomingCall;
//# sourceMappingURL=IncomingCall.js.map