var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { useUserAvatarPath, useUserPresence } from '@rocket.chat/ui-contexts';
import { useEffect, useReducer, useMemo } from 'react';
const defaultSessionInfo = {
    state: 'closed',
    callId: undefined,
    connectionState: 'CONNECTING',
    peerInfo: undefined,
    transferredBy: undefined,
    muted: false,
    held: false,
    remoteMuted: false,
    remoteHeld: false,
    startedAt: new Date(),
    hidden: false,
};
export const getExtensionFromPeerInfo = (peerInfo) => {
    if ('callerId' in peerInfo) {
        return peerInfo.callerId;
    }
    if ('number' in peerInfo) {
        return peerInfo.number;
    }
    return undefined;
};
const deriveWidgetStateFromCallState = (callState, callRole) => {
    switch (callState) {
        case 'active':
        case 'accepted':
        case 'renegotiating':
            return 'ongoing';
        case 'none':
        case 'ringing':
            return callRole === 'callee' ? 'ringing' : 'calling';
    }
};
const deriveConnectionStateFromCallState = (callState) => {
    switch (callState) {
        case 'renegotiating':
            return 'RECONNECTING';
        case 'ringing':
        case 'active':
            return 'CONNECTED';
        case 'none':
        case 'accepted':
        default:
            return 'CONNECTING';
    }
};
const reducer = (reducerState, action) => {
    var _a, _b, _c, _d, _e, _f;
    if (action.type === 'mute') {
        return Object.assign(Object.assign({}, reducerState), { muted: (_b = (_a = action.payload) === null || _a === void 0 ? void 0 : _a.muted) !== null && _b !== void 0 ? _b : reducerState.muted });
    }
    if (action.type === 'hold') {
        return Object.assign(Object.assign({}, reducerState), { held: (_d = (_c = action.payload) === null || _c === void 0 ? void 0 : _c.held) !== null && _d !== void 0 ? _d : reducerState.held });
    }
    if (action.type === 'toggleWidget') {
        if (reducerState.state === 'closed') {
            return Object.assign(Object.assign({}, reducerState), { state: 'new', peerInfo: (_e = action.payload) === null || _e === void 0 ? void 0 : _e.peerInfo });
        }
        if (reducerState.state === 'new') {
            return Object.assign(Object.assign({}, reducerState), { state: 'closed' });
        }
    }
    if (action.type === 'instance_updated') {
        return Object.assign(Object.assign({}, reducerState), action.payload);
    }
    if (action.type === 'selectPeer') {
        if (reducerState.state !== 'new') {
            return reducerState;
        }
        return Object.assign(Object.assign({}, reducerState), { peerInfo: (_f = action.payload) === null || _f === void 0 ? void 0 : _f.peerInfo });
    }
    if (action.type === 'reset') {
        return defaultSessionInfo;
    }
    return reducerState;
};
export const useMediaSession = (instance) => {
    const [mediaSession, dispatch] = useReducer(reducer, defaultSessionInfo);
    const getAvatarUrl = useUserAvatarPath();
    useEffect(() => {
        if (!instance) {
            dispatch({ type: 'reset' });
            return;
        }
        const updateSessionState = () => {
            const mainCall = instance.getMainCall();
            if (!mainCall) {
                dispatch({ type: 'reset' });
                return;
            }
            const { contact, transferredBy: callTransferredBy, state: callState, role, muted, held, hidden, remoteHeld, remoteMute, callId, } = mainCall;
            const state = deriveWidgetStateFromCallState(callState, role);
            const connectionState = deriveConnectionStateFromCallState(callState);
            const transferredBy = (callTransferredBy === null || callTransferredBy === void 0 ? void 0 : callTransferredBy.displayName) || (callTransferredBy === null || callTransferredBy === void 0 ? void 0 : callTransferredBy.username) || undefined;
            if (contact.type === 'sip') {
                dispatch({
                    type: 'instance_updated',
                    payload: {
                        peerInfo: { number: contact.id || 'unknown' },
                        transferredBy,
                        state,
                        muted,
                        held,
                        connectionState,
                        hidden,
                        remoteHeld,
                        remoteMuted: remoteMute,
                        callId,
                    },
                });
                return;
            }
            const avatarUrl = (() => {
                if (contact.username) {
                    return getAvatarUrl({ username: contact.username });
                }
                if (contact.id) {
                    return getAvatarUrl({ userId: contact.id });
                }
                return undefined;
            })();
            const peerInfo = {
                displayName: contact.displayName,
                userId: contact.id,
                username: contact.username,
                avatarUrl,
                callerId: contact.sipExtension,
            };
            dispatch({
                type: 'instance_updated',
                payload: { state, peerInfo, transferredBy, muted, held, connectionState, hidden, remoteHeld, remoteMuted: remoteMute, callId },
            });
        };
        const offCbs = [instance.on('sessionStateChange', updateSessionState), instance.on('hiddenCall', updateSessionState)];
        return () => {
            offCbs.forEach((offCb) => offCb());
        };
    }, [getAvatarUrl, instance]);
    const cbs = useMemo(() => {
        const toggleWidget = (peerInfo) => {
            dispatch({ type: 'toggleWidget', payload: { peerInfo } });
        };
        const selectPeer = (peerInfo) => {
            dispatch({ type: 'selectPeer', payload: { peerInfo } });
        };
        const toggleMute = () => {
            const mainCall = instance === null || instance === void 0 ? void 0 : instance.getMainCall();
            if (!mainCall) {
                return;
            }
            mainCall.setMuted(!mainCall.muted);
            dispatch({ type: 'mute', payload: { muted: mainCall.muted } });
        };
        const toggleHold = () => {
            const mainCall = instance === null || instance === void 0 ? void 0 : instance.getMainCall();
            if (!mainCall) {
                return;
            }
            mainCall.setHeld(!mainCall.held);
            dispatch({ type: 'hold', payload: { held: mainCall.held } });
        };
        const endCall = () => {
            if (!instance) {
                return;
            }
            const mainCall = instance.getMainCall();
            if (!mainCall) {
                return;
            }
            const { role } = mainCall;
            if (role === 'caller' || mainCall.state !== 'ringing') {
                mainCall.hangup();
                return;
            }
            mainCall.reject();
        };
        const acceptCall = () => __awaiter(void 0, void 0, void 0, function* () {
            if (!instance) {
                return;
            }
            const call = instance.getMainCall();
            if (!call || call.state !== 'ringing') {
                return;
            }
            call.accept();
        });
        const startCall = (id, kind) => __awaiter(void 0, void 0, void 0, function* () {
            if (!instance) {
                return;
            }
            try {
                yield instance.startCall(kind, id);
            }
            catch (error) {
                console.error('Error starting call', error);
            }
        });
        const changeDevice = (deviceId) => __awaiter(void 0, void 0, void 0, function* () {
            if (!instance) {
                return;
            }
            instance.setDeviceId({ exact: deviceId });
        });
        const forwardCall = (type, id) => {
            if (!instance) {
                return;
            }
            const mainCall = instance.getMainCall();
            if (!mainCall) {
                return;
            }
            mainCall.transfer({ type, id });
        };
        const sendTone = (tone) => {
            if (!instance) {
                return;
            }
            const mainCall = instance.getMainCall();
            if (!mainCall) {
                return;
            }
            try {
                mainCall.sendDTMF(tone);
            }
            catch (error) {
                console.error('Error sending tone', error);
            }
        };
        return {
            toggleWidget,
            toggleHold,
            endCall,
            startCall,
            changeDevice,
            forwardCall,
            sendTone,
            selectPeer,
            toggleMute,
            acceptCall,
        };
    }, [instance]);
    const status = useUserPresence(mediaSession.peerInfo && 'userId' in mediaSession.peerInfo ? mediaSession.peerInfo.userId : undefined);
    const peerInfo = useMemo(() => {
        return mediaSession.peerInfo ? Object.assign(Object.assign({}, mediaSession.peerInfo), { status: status === null || status === void 0 ? void 0 : status.status }) : undefined;
    }, [mediaSession.peerInfo, status]);
    return Object.assign(Object.assign(Object.assign({}, mediaSession), { peerInfo }), cbs);
};
//# sourceMappingURL=useMediaSession.js.map