var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { useUserPreference } from '@rocket.chat/ui-contexts';
import { useEffect, useRef } from 'react';
import { useTranslation } from 'react-i18next';
import { convertAvatarUrlToPng } from './utils/convertAvatarUrlToPng';
const getDisplayInfo = (peerInfo) => {
    if (!peerInfo) {
        return undefined;
    }
    if ('number' in peerInfo) {
        return { title: peerInfo.number };
    }
    if ('displayName' in peerInfo) {
        return { title: peerInfo.displayName, avatar: peerInfo.avatarUrl };
    }
    return undefined;
};
export const useDesktopNotifications = (sessionInfo) => {
    const previousCallId = useRef(undefined);
    const { t } = useTranslation();
    const desktopNotificationsEnabled = useUserPreference('desktopNotificationVoiceCalls');
    const displayInfo = getDisplayInfo(sessionInfo.peerInfo);
    useEffect(() => {
        var _a, _b;
        if (!desktopNotificationsEnabled) {
            return;
        }
        if (typeof ((_a = window.RocketChatDesktop) === null || _a === void 0 ? void 0 : _a.dispatchCustomNotification) !== 'function' ||
            typeof ((_b = window.RocketChatDesktop) === null || _b === void 0 ? void 0 : _b.closeCustomNotification) !== 'function') {
            return;
        }
        let isMounted = true;
        if (sessionInfo.state !== 'ringing') {
            if (previousCallId.current) {
                window.RocketChatDesktop.closeCustomNotification(previousCallId.current);
                previousCallId.current = undefined;
            }
            return;
        }
        if (!(displayInfo === null || displayInfo === void 0 ? void 0 : displayInfo.title)) {
            return;
        }
        const notifyDesktop = () => __awaiter(void 0, void 0, void 0, function* () {
            var _a;
            const avatarAsPng = yield convertAvatarUrlToPng(displayInfo.avatar);
            if (!isMounted) {
                return;
            }
            (_a = window.RocketChatDesktop) === null || _a === void 0 ? void 0 : _a.dispatchCustomNotification({
                type: 'voice',
                id: sessionInfo.callId,
                payload: {
                    title: displayInfo.title,
                    body: t('Incoming_call_ellipsis'),
                    avatar: avatarAsPng || undefined,
                    requireInteraction: true,
                },
            });
        });
        notifyDesktop();
        previousCallId.current = sessionInfo.callId;
        return () => {
            isMounted = false;
        };
    }, [displayInfo === null || displayInfo === void 0 ? void 0 : displayInfo.avatar, displayInfo === null || displayInfo === void 0 ? void 0 : displayInfo.title, sessionInfo.callId, sessionInfo.state, t, desktopNotificationsEnabled]);
};
//# sourceMappingURL=useDesktopNotifications.js.map