import { useCustomSound } from '@rocket.chat/ui-contexts';
import { useEffect } from 'react';
export const useCallSounds = (state, subscribeCallEnded) => {
    const { voipSounds } = useCustomSound();
    useEffect(() => {
        if (state === 'calling') {
            return voipSounds.playDialer();
        }
        if (state === 'ringing') {
            return voipSounds.playRinger();
        }
    }, [voipSounds, state]);
    useEffect(() => {
        return subscribeCallEnded(voipSounds.playCallEnded);
    }, [voipSounds, subscribeCallEnded]);
};
//# sourceMappingURL=useCallSounds.js.map