var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { jsx as _jsx } from "react/jsx-runtime";
import { Palette } from '@rocket.chat/fuselage';
import styled from '@rocket.chat/styled';
import { useLayoutEffect } from 'react';
import { FocusScope } from 'react-aria';
import { DragContext } from './WidgetDraggableContext';
import { useDraggable } from '../../../components/VoipPopupDraggable/DraggableCore';
// TODO: Initial position from the draggable api instead of style props
// TODO: A11Y
const WidgetBase = styled('article') `
	position: fixed;
	right: 2em;
	top: 11em;
	display: flex;
	flex-direction: column;
	width: 248px;
	min-height: 128px;
	border-radius: 4px;
	border: 1px solid ${Palette.stroke['stroke-dark'].toString()};
	box-shadow:
		0px 0px 1px 0px ${Palette.shadow['shadow-elevation-2x'].toString()},
		0px 0px 12px 0px ${Palette.shadow['shadow-elevation-2y'].toString()};
	background-color: ${Palette.surface['surface-tint'].toString()};
	color: ${Palette.text['font-default'].toString()};
	z-index: 100;
	overflow: hidden;
`;
const Widget = (_a) => {
    var { children } = _a, props = __rest(_a, ["children"]);
    const [draggableRef, boundingRef, handleRef] = useDraggable();
    useLayoutEffect(() => {
        boundingRef(document.body);
    }, [boundingRef]);
    return (_jsx(DragContext.Provider, { value: { draggableRef, boundingRef, handleRef }, children: _jsx(FocusScope, { autoFocus: true, children: _jsx(WidgetBase, Object.assign({}, props, { ref: draggableRef, "aria-labelledby": 'rcx-media-call-widget-title rcx-media-call-widget-caller-info', children: children })) }) }));
};
export default Widget;
//# sourceMappingURL=Widget.js.map