import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Box, Button, Modal, ModalClose, ModalContent, ModalFooter, ModalFooterControllers, ModalHeader, ModalTitle, } from '@rocket.chat/fuselage';
import { useId, useState } from 'react';
import { useTranslation } from 'react-i18next';
import { usePeerAutocomplete } from './MediaCallContext';
import { PeerAutocomplete, PeerInfo } from './components';
const TransferModal = ({ onCancel, onConfirm }) => {
    const { t } = useTranslation();
    const modalId = useId();
    const [peer, setPeer] = useState(undefined);
    const [error, setError] = useState(undefined);
    const autocomplete = usePeerAutocomplete(setPeer, peer);
    const onChangeValue = (value) => {
        if (error) {
            setError(undefined);
        }
        autocomplete.onChangeValue(value);
    };
    const confirm = () => {
        if (!peer) {
            setError(t('Field_required'));
            return;
        }
        setError(undefined);
        if ('userId' in peer) {
            onConfirm('user', { id: peer.userId, displayName: peer.displayName });
            return;
        }
        if ('number' in peer) {
            onConfirm('sip', { id: peer.number, displayName: peer.number });
            return;
        }
        throw new Error('Peer info is missing userId and/or number');
    };
    return (_jsxs(Modal, { open: true, "aria-labelledby": modalId, children: [_jsxs(ModalHeader, { children: [_jsx(ModalTitle, { id: modalId, children: t('Transfer_call') }), _jsx(ModalClose, { "aria-label": t('Close'), onClick: onCancel })] }), _jsxs(ModalContent, { children: [_jsx(PeerAutocomplete, Object.assign({}, autocomplete, { error: error, onChangeValue: onChangeValue })), peer && (_jsx(Box, { mb: 8, children: _jsx(PeerInfo, Object.assign({}, peer)) }))] }), _jsx(ModalFooter, { children: _jsxs(ModalFooterControllers, { children: [_jsx(Button, { secondary: true, onClick: onCancel, children: t('Cancel') }), _jsx(Button, { danger: true, onClick: confirm, icon: 'phone-off', children: t('Hang_up_and_transfer_call') })] }) })] }));
};
export default TransferModal;
//# sourceMappingURL=TransferModal.js.map