export class MediaCallLogger {
    constructor() {
        const searchParams = new URLSearchParams(window.location.search);
        this.isDebug = Boolean(searchParams.get('debug') || searchParams.get('debug-voip'));
    }
    log(...what) {
        this.isDebug && console.log(...what);
    }
    debug(...what) {
        this.isDebug && console.debug(...what);
    }
    error(...what) {
        console.error(...what);
    }
    warn(...what) {
        console.warn(...what);
    }
}
//# sourceMappingURL=MediaCallLogger.js.map