var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { jsx as _jsx } from "react/jsx-runtime";
import { useMediaDeviceMicrophonePermission, useSelectedDevices, useSetInputMediaDevice, useSetModal } from '@rocket.chat/ui-contexts';
import { useQueryClient } from '@tanstack/react-query';
import { useCallback } from 'react';
import PermissionFlowModal from '../components/PermissionFlow/PermissionFlowModal';
const getModalType = (actionType, state) => {
    if (state === 'denied') {
        return 'denied';
    }
    if (actionType === 'device-change') {
        return 'deviceChangePrompt';
    }
    if (actionType === 'outgoing') {
        return 'outgoingPrompt';
    }
    // actionType === 'incoming'
    return 'incomingPrompt';
};
export const stopTracks = (stream) => {
    stream.getTracks().forEach((track) => {
        track.stop();
    });
};
export class PermissionRequestCancelledCallRejectedError extends Error {
    constructor(message) {
        super(message);
        this.name = 'PermissionRequestDeniedError';
    }
}
// TODO: Remove this hook
export const useDevicePermissionPrompt = ({ onAccept: _onAccept, onReject, actionType }) => {
    const { state, requestDevice } = useMediaDeviceMicrophonePermission();
    const setModal = useSetModal();
    const setInputMediaDevice = useSetInputMediaDevice();
    const queryClient = useQueryClient();
    return useCallback((stopTracks = true) => {
        const onAccept = (stream) => {
            // Since we now have requested a stream, we can now invalidate the devices list and generate a complete one.
            // Obs2: Safari does not seem to be dispatching the change event when permission is granted, so we need to invalidate the permission query as well.
            queryClient.invalidateQueries({ queryKey: ['media-devices-list'] });
            stream.getTracks().forEach((track) => {
                const { deviceId } = track.getSettings();
                if (!deviceId) {
                    return;
                }
                if (track.kind === 'audio' && navigator.mediaDevices.enumerateDevices) {
                    navigator.mediaDevices.enumerateDevices().then((devices) => {
                        const device = devices.find((device) => device.deviceId === deviceId);
                        if (!device) {
                            return;
                        }
                        setInputMediaDevice({
                            id: device.deviceId,
                            label: device.label,
                            type: 'audioinput',
                        });
                    });
                }
            });
            _onAccept(stream);
            // For now we only need this stream to be able to list the devices (firefox doesn't list devices without a stream)
            // and also to get the selected device from the tracks settings (firefox requests permission per device)
            // This is set as a flag in case we need to use the stream in the future.
            if (stopTracks) {
                stream.getTracks().forEach((track) => {
                    track.stop();
                });
            }
        };
        if (state === 'granted') {
            requestDevice({
                onAccept,
            });
            return;
        }
        const onConfirm = () => {
            requestDevice === null || requestDevice === void 0 ? void 0 : requestDevice({
                onReject,
                onAccept: (...args) => {
                    onAccept(...args);
                    setModal(null);
                },
            });
        };
        const onCancel = () => {
            if (onReject) {
                onReject();
            }
            setModal(null);
        };
        setModal(_jsx(PermissionFlowModal, { type: getModalType(actionType, state), onCancel: onCancel, onConfirm: onConfirm }));
    }, [state, setModal, actionType, queryClient, _onAccept, setInputMediaDevice, requestDevice, onReject]);
};
export const useDevicePermissionPrompt2 = () => {
    const { state, requestDevice } = useMediaDeviceMicrophonePermission();
    const setModal = useSetModal();
    const setInputMediaDevice = useSetInputMediaDevice();
    const queryClient = useQueryClient();
    const { audioInput } = useSelectedDevices() || {};
    const selectedDeviceId = audioInput === null || audioInput === void 0 ? void 0 : audioInput.id;
    return useCallback((_a) => __awaiter(void 0, [_a], void 0, function* ({ constraints: _constraints, actionType, }) {
        return new Promise((_resolve, reject) => {
            const resolve = (stream) => {
                // Since we now have requested a stream, we can now invalidate the devices list and generate a complete one.
                // Obs2: Safari does not seem to be dispatching the change event when permission is granted, so we need to invalidate the permission query as well.
                queryClient.invalidateQueries({ queryKey: ['media-devices-list'] });
                _resolve(stream);
            };
            const onAccept = (stream) => {
                stream.getTracks().forEach((track) => {
                    const { deviceId } = track.getSettings();
                    if (!deviceId) {
                        return;
                    }
                    if (track.kind === 'audio' && navigator.mediaDevices.enumerateDevices) {
                        navigator.mediaDevices.enumerateDevices().then((devices) => {
                            const device = devices.find((device) => device.deviceId === deviceId);
                            if (!device) {
                                return;
                            }
                            setInputMediaDevice({
                                id: device.deviceId,
                                label: device.label,
                                type: 'audioinput',
                            });
                        });
                    }
                });
                resolve(stream);
            };
            const constraints = _constraints || {
                audio: selectedDeviceId ? { deviceId: { exact: selectedDeviceId } } : true,
            };
            if (state === 'granted') {
                requestDevice({
                    onAccept: resolve,
                    onReject: reject,
                    constraints,
                });
                return;
            }
            const onConfirm = () => {
                requestDevice === null || requestDevice === void 0 ? void 0 : requestDevice({
                    onReject: (...args) => {
                        reject(...args);
                        setModal(_jsx(PermissionFlowModal, { type: 'denied', onCancel: () => setModal(null), onConfirm: () => setModal(null) }));
                    },
                    onAccept: (...args) => {
                        onAccept(...args);
                        setModal(null);
                    },
                    constraints,
                });
            };
            const modalType = getModalType(actionType, state);
            const onCancel = () => {
                if (modalType === 'incomingPrompt') {
                    reject(new PermissionRequestCancelledCallRejectedError('Permission request modal closed'));
                }
                setModal(null);
            };
            setModal(_jsx(PermissionFlowModal, { type: modalType, onCancel: onCancel, onConfirm: onConfirm }));
        });
    }), [selectedDeviceId, state, setModal, queryClient, setInputMediaDevice, requestDevice]);
};
//# sourceMappingURL=useDevicePermissionPrompt.js.map