"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useUserSubscriptionByName = void 0;
const react_1 = require("react");
const UserContext_1 = require("../UserContext");
const useUserSubscriptionByName = (name) => {
    const { querySubscription } = (0, react_1.useContext)(UserContext_1.UserContext);
    const [subscribe, getSnapshot] = (0, react_1.useMemo)(() => querySubscription({ name }), [querySubscription, name]);
    return (0, react_1.useSyncExternalStore)(subscribe, getSnapshot);
};
exports.useUserSubscriptionByName = useUserSubscriptionByName;
//# sourceMappingURL=useUserSubscriptionByName.js.map