"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useUserSubscription = void 0;
const react_1 = require("react");
const UserContext_1 = require("../UserContext");
const useUserSubscription = (rid) => {
    const { querySubscription } = (0, react_1.useContext)(UserContext_1.UserContext);
    const [subscribe, getSnapshot] = (0, react_1.useMemo)(() => querySubscription({ rid }), [querySubscription, rid]);
    return (0, react_1.useSyncExternalStore)(subscribe, getSnapshot);
};
exports.useUserSubscription = useUserSubscription;
//# sourceMappingURL=useUserSubscription.js.map