"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const jsx_runtime_1 = require("react/jsx-runtime");
const react_1 = require("@testing-library/react");
const useMediaDevicePermission_1 = require("./useMediaDevicePermission");
const DeviceContext_1 = require("../DeviceContext");
const states = [
    { expectedState: 'granted', state: 'granted', requestDevice: 'function' },
    { expectedState: 'denied', state: 'denied', requestDevice: 'undefined' },
    { expectedState: 'prompt', state: 'prompt', requestDevice: 'function' },
];
const getWrapper = (state, availableAudioInputDevices = [], enabled = true) => ({ children }) => {
    return ((0, jsx_runtime_1.jsx)(DeviceContext_1.DeviceContext.Provider, { value: {
            enabled,
            selectedAudioOutputDevice: undefined,
            selectedAudioInputDevice: undefined,
            availableAudioOutputDevices: [],
            availableAudioInputDevices,
            permissionStatus: state ? { state } : undefined,
            setAudioOutputDevice: () => undefined,
            setAudioInputDevice: () => undefined,
        }, children: children }));
};
describe('useMediaDeviceMicrophonePermission', () => {
    it('Should return permission state denied and requestDevice is undefined if context is disabled', () => __awaiter(void 0, void 0, void 0, function* () {
        const { result } = (0, react_1.renderHook)(() => (0, useMediaDevicePermission_1.useMediaDeviceMicrophonePermission)(), {
            wrapper: getWrapper(undefined, ['device1', 'device2'], false),
        });
        expect(result.current.state).toBe('denied');
        expect(result.current.requestDevice).toBeUndefined();
    }));
    it.each(states)('Should return permission state $state and requestDevice is $requestDevice', (_a) => __awaiter(void 0, [_a], void 0, function* ({ state, requestDevice }) {
        const { result } = (0, react_1.renderHook)(() => (0, useMediaDevicePermission_1.useMediaDeviceMicrophonePermission)(), {
            wrapper: getWrapper(state),
        });
        expect(result.current.state).toBe(state);
        expect(typeof result.current.requestDevice).toBe(requestDevice);
    }));
    it('Should return permission state granted and requestDevice is function if permissionStatus is undefined and availableAudioInputDevices has records', () => __awaiter(void 0, void 0, void 0, function* () {
        const { result } = (0, react_1.renderHook)(() => (0, useMediaDevicePermission_1.useMediaDeviceMicrophonePermission)(), {
            wrapper: getWrapper(undefined, ['device1', 'device2']),
        });
        expect(result.current.state).toBe('granted');
        expect(typeof result.current.requestDevice).toBe('function');
    }));
    it('Should return permission state prompt and requestDevice is function if permissionStatus is undefined and availableAudioInputDevices is empty', () => __awaiter(void 0, void 0, void 0, function* () {
        const { result } = (0, react_1.renderHook)(() => (0, useMediaDevicePermission_1.useMediaDeviceMicrophonePermission)(), {
            wrapper: getWrapper(undefined),
        });
        expect(result.current.state).toBe('prompt');
        expect(typeof result.current.requestDevice).toBe('function');
    }));
});
//# sourceMappingURL=useMediaDevicePermission.spec.js.map