"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useMediaDeviceMicrophonePermission = exports.requestDevice = void 0;
const react_1 = require("react");
const DeviceContext_1 = require("../DeviceContext");
const requestDevice = (_a) => __awaiter(void 0, [_a], void 0, function* ({ onAccept, onReject, constraints = { audio: true }, }) {
    if (!navigator.mediaDevices) {
        return;
    }
    navigator.mediaDevices.getUserMedia(constraints).then(onAccept, onReject);
});
exports.requestDevice = requestDevice;
const isPermissionDenied = (state) => {
    return state === 'denied';
};
/**
 * @description Hook to check if the microphone permission is granted. If the permission is denied, or the permission is not requested, the hook will return a function to request the permission. Right now just the microphone permission is handled with this hook, since DeviceContext is only used for audio input and output.
 * @returns { state: 'granted' } if the permission is granted
 * @returns { state: 'denied' } if the permission is denied
 * @returns { state: 'prompt', requestPrompt: function ({onAccept, onReject}) {} } if the permission is in prompt state.
 */
const useMediaDeviceMicrophonePermission = () => {
    const context = (0, react_1.useContext)(DeviceContext_1.DeviceContext);
    if (!(0, DeviceContext_1.isDeviceContextEnabled)(context)) {
        return {
            state: 'denied',
        };
    }
    const { permissionStatus, availableAudioInputDevices } = context;
    if (permissionStatus) {
        if (isPermissionDenied(permissionStatus.state)) {
            return { state: permissionStatus.state };
        }
        return { state: permissionStatus.state, requestDevice: exports.requestDevice };
    }
    if (availableAudioInputDevices.length > 0) {
        return { state: 'granted', requestDevice: exports.requestDevice };
    }
    return {
        state: 'prompt',
        requestDevice: exports.requestDevice,
    };
};
exports.useMediaDeviceMicrophonePermission = useMediaDeviceMicrophonePermission;
//# sourceMappingURL=useMediaDevicePermission.js.map