var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { css } from '@rocket.chat/css-in-js';
import { Box, IconButton } from '@rocket.chat/fuselage';
import { useState, forwardRef } from 'react';
import { useTranslation } from 'react-i18next';
import MessageComposerInput from './MessageComposerInput';
const MessageComposerInputExpandable = forwardRef((_a, ref) => {
    var { dimensions, onChange } = _a, props = __rest(_a, ["dimensions", "onChange"]);
    const { t } = useTranslation();
    const [expanded, setExpanded] = useState(false);
    const handleChange = (event) => {
        if (event.target.value.length === 0) {
            setExpanded(false);
        }
        onChange === null || onChange === void 0 ? void 0 : onChange(event);
    };
    return (_jsxs(_Fragment, { children: [dimensions.blockSize > 100 && (_jsx(Box, { position: 'absolute', padding: 8, className: css `
							top: 0;
							right: 0;
						`, children: _jsx(IconButton, { small: true, icon: expanded ? 'arrow-collapse' : 'arrow-expand', title: expanded ? t('Collapse') : t('Expand'), onClick: () => setExpanded(!expanded) }) })), _jsx(MessageComposerInput, Object.assign({ ref: ref, onChange: handleChange }, (!!expanded && { height: 500, maxHeight: '50vh' }), props))] }));
});
MessageComposerInputExpandable.displayName = 'MessageComposerInputExpandable';
export default MessageComposerInputExpandable;
//# sourceMappingURL=MessageComposerInputExpandable.js.map