import { jsx as _jsx } from "react/jsx-runtime";
import { css } from '@rocket.chat/css-in-js';
import { Box, Palette } from '@rocket.chat/fuselage';
import { forwardRef } from 'react';
const messageComposerInputStyle = css `
	resize: none;

	&::placeholder {
		color: ${Palette.text['font-annotation']};
	}
`;
const MessageComposerInput = forwardRef(function MessageComposerInput(props, ref) {
    return (_jsx(Box, Object.assign({ className: [messageComposerInputStyle, 'rc-message-box__textarea js-input-message'], color: 'default', width: 'full', minHeight: 52, maxHeight: 155, rows: 1, fontScale: 'p2', ref: ref, pi: 12, pb: 16, borderWidth: 0, is: 'textarea' }, props)));
});
export default MessageComposerInput;
//# sourceMappingURL=MessageComposerInput.js.map