import { useSetting, useUserPreference } from '@rocket.chat/ui-contexts';
import { useMemo } from 'react';
import { parseSetting, useFeaturePreviewList } from './useFeaturePreviewList';
export const usePreferenceFeaturePreviewList = () => {
    const featurePreviewEnabled = useSetting('Accounts_AllowFeaturePreview', false);
    const userFeaturesPreviewPreference = useUserPreference('featuresPreview');
    const userFeaturesPreview = useMemo(() => parseSetting(userFeaturesPreviewPreference), [userFeaturesPreviewPreference]);
    const { unseenFeatures, features } = useFeaturePreviewList(userFeaturesPreview !== null && userFeaturesPreview !== void 0 ? userFeaturesPreview : []);
    if (!featurePreviewEnabled) {
        return { unseenFeatures: 0, features: [], featurePreviewEnabled };
    }
    return { unseenFeatures, features, featurePreviewEnabled };
};
//# sourceMappingURL=usePreferenceFeaturePreviewList.js.map