import { Emitter } from '@rocket.chat/emitter';
import { createElement } from 'react';
import { modalStore } from '../providers/ModalProvider/ModalStore';
const mapCurrentModal = (descriptor) => {
    if (descriptor === null) {
        return null;
    }
    if ('component' in descriptor) {
        return createElement(descriptor.component, Object.assign({ key: Math.random() }, descriptor.props));
    }
};
class ImperativeModalEmmiter extends Emitter {
    constructor(store) {
        super();
        this.open = (descriptor) => this.store.open(mapCurrentModal(descriptor));
        this.push = (descriptor) => this.store.push(mapCurrentModal(descriptor));
        this.close = () => {
            this.store.close();
        };
        this.store = store;
    }
}
export const imperativeModal = new ImperativeModalEmmiter(modalStore);
//# sourceMappingURL=imperativeModal.js.map