import { jsx as _jsx } from "react/jsx-runtime";
import { Tabs, TabsItem } from '@rocket.chat/fuselage';
import { useWizardContext } from './useWizardContext';
import { useWizardSteps } from './useWizardSteps';
const WizardTabs = ({ ordered }) => {
    const { steps, currentStep, goTo } = useWizardContext();
    const items = useWizardSteps(steps);
    return (_jsx(Tabs, { display: 'flex', flexDirection: 'column', children: items.map((step, index) => (_jsx(TabsItem, { textAlign: 'center', flexGrow: 1, selected: (currentStep === null || currentStep === void 0 ? void 0 : currentStep.id) === step.id, disabled: step.disabled, onClick: () => goTo(step), children: ordered ? `${index + 1}. ${step.title}` : step.title }, index))) }));
};
export default WizardTabs;
//# sourceMappingURL=WizardTabs.js.map