var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Box } from '@rocket.chat/fuselage';
import { useButtonPattern, useOutsideClick, useToggle } from '@rocket.chat/fuselage-hooks';
import { useCallback, useRef } from 'react';
import MultiSelectCustomAnchor from './MultiSelectCustomAnchor';
import MultiSelectCustomList from './MultiSelectCustomList';
import MultiSelectCustomListWrapper from './MultiSelectCustomListWrapper';
const isValidReference = (reference, event) => {
    var _a;
    const isValidTarget = Boolean(event.target);
    const isValidReference = event.target !== reference.current && !((_a = reference.current) === null || _a === void 0 ? void 0 : _a.contains(event.target));
    return isValidTarget && isValidReference;
};
const onMouseEventPreventSideEffects = (e) => {
    e.preventDefault();
    e.stopPropagation();
    e.stopImmediatePropagation();
};
export const MultiSelectCustom = (_a) => {
    var { dropdownOptions, defaultTitle, selectedOptionsTitle, selectedOptions, setSelectedOptions, searchBarText } = _a, props = __rest(_a, ["dropdownOptions", "defaultTitle", "selectedOptionsTitle", "selectedOptions", "setSelectedOptions", "searchBarText"]);
    const reference = useRef(null);
    const target = useRef(null);
    const [collapsed, toggleCollapsed] = useToggle(false);
    const onClose = useCallback((e) => {
        if (isValidReference(reference, e)) {
            toggleCollapsed(false);
            return;
        }
        onMouseEventPreventSideEffects(e);
    }, [toggleCollapsed]);
    useOutsideClick([target], onClose);
    const onSelect = useCallback((selectedOption, e) => {
        e === null || e === void 0 ? void 0 : e.stopPropagation();
        if (selectedOption.hasOwnProperty('checked')) {
            selectedOption.checked = !selectedOption.checked;
            if (selectedOption.checked) {
                setSelectedOptions([...new Set([...selectedOptions, selectedOption])]);
                return;
            }
            // the user has disabled this option -> remove this from the selected options list
            setSelectedOptions(selectedOptions.filter((option) => option.id !== selectedOption.id));
        }
    }, [selectedOptions, setSelectedOptions]);
    const selectedOptionsCount = dropdownOptions.filter((option) => option.hasOwnProperty('checked') && option.checked).length;
    const buttonProps = useButtonPattern(() => toggleCollapsed(!collapsed));
    return (_jsxs(Box, { display: 'flex', position: 'relative', children: [_jsx(MultiSelectCustomAnchor, Object.assign({ ref: reference, collapsed: collapsed, defaultTitle: defaultTitle, selectedOptionsTitle: selectedOptionsTitle, selectedOptionsCount: selectedOptionsCount, maxCount: dropdownOptions.length }, buttonProps, props)), collapsed && (_jsx(MultiSelectCustomListWrapper, { ref: target, children: _jsx(MultiSelectCustomList, { options: dropdownOptions, onSelected: onSelect, searchBarText: searchBarText }) }))] }));
};
//# sourceMappingURL=MultiSelectCustom.js.map