import { jsx as _jsx } from "react/jsx-runtime";
import { useEffectEvent } from '@rocket.chat/fuselage-hooks';
import { useCurrentModal, useModal } from '@rocket.chat/ui-contexts';
import { lazy, Suspense } from 'react';
import ModalBackdrop from './ModalBackdrop';
import ModalPortal from './ModalPortal';
const FocusScope = lazy(() => import('react-aria').then(({ FocusScope }) => ({ default: FocusScope })));
const ModalRegion = () => {
    const currentModal = useCurrentModal();
    const { setModal } = useModal();
    const handleDismiss = useEffectEvent(() => {
        setModal(null);
    });
    if (!currentModal) {
        return null;
    }
    return (_jsx(ModalPortal, { children: _jsx(ModalBackdrop, { onDismiss: handleDismiss, children: _jsx(Suspense, { fallback: null, children: _jsx(FocusScope, { contain: true, restoreFocus: true, autoFocus: true, children: currentModal }) }) }) }));
};
export default ModalRegion;
//# sourceMappingURL=ModalRegion.js.map